/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalZonedDateTimeObject
extends JSTemporalCalendarHolder {
    private final BigInt nanoseconds;
    private final JSDynamicObject timeZone;

    protected JSTemporalZonedDateTimeObject(Shape shape, JSDynamicObject proto, BigInt nanoseconds, JSDynamicObject timeZone, JSDynamicObject calendar) {
        super(shape, proto, calendar);
        assert (TemporalUtil.isValidEpochNanoseconds(nanoseconds));
        this.nanoseconds = nanoseconds;
        this.timeZone = timeZone;
    }

    public BigInt getNanoseconds() {
        return this.nanoseconds;
    }

    public JSDynamicObject getTimeZone() {
        return this.timeZone;
    }

    @CompilerDirectives.TruffleBoundary
    private Instant toInstant() {
        BigInteger[] res = this.nanoseconds.bigIntegerValue().divideAndRemainder(TemporalUtil.BI_10_POW_9);
        return Instant.ofEpochSecond(res[0].longValue(), res[1].intValue());
    }

    @ExportMessage
    boolean isTimeZone() {
        return this.getZoneIdIntl() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone() throws UnsupportedMessageException {
        ZoneId tzObj = this.getZoneIdIntl();
        if (tzObj == null) {
            throw UnsupportedMessageException.create();
        }
        return tzObj;
    }

    @CompilerDirectives.TruffleBoundary
    private ZoneId getZoneIdIntl() {
        JSDynamicObject jSDynamicObject = this.timeZone;
        if (jSDynamicObject instanceof JSTemporalTimeZoneObject) {
            JSTemporalTimeZoneObject tzObj = (JSTemporalTimeZoneObject)jSDynamicObject;
            return tzObj.asTimeZone();
        }
        Object tzID = JSObject.get(this.timeZone, TemporalConstants.TIME_ZONE);
        if (tzID instanceof TruffleString) {
            String id = ((TruffleString)tzID).toJavaStringUncached();
            return ZoneId.of(id);
        }
        return null;
    }

    @ExportMessage
    boolean isDate() {
        return this.isTimeZone();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() throws UnsupportedMessageException {
        return LocalDate.ofInstant(this.toInstant(), this.asTimeZone());
    }

    @ExportMessage
    boolean isTime() {
        return this.isTimeZone();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() throws UnsupportedMessageException {
        return LocalTime.ofInstant(this.toInstant(), this.asTimeZone());
    }
}

