/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.generation.EventBinder;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public final class ActionScriptEventDispatchUtils {
    public static boolean isEventDispatcher(JSClass jsClass) {
        PsiElement eventClass = JSClassResolver.findClassFromNamespace((String)"flash.events.IEventDispatcher", (PsiElement)jsClass);
        if (!(eventClass instanceof JSClass)) {
            return false;
        }
        return JSInheritanceUtil.isParentClass((JSClass)jsClass, (JSClass)((JSClass)eventClass));
    }

    @NotNull
    public static EventBinder createTestEventBinder(final JSClass jsClass) {
        final boolean isEventDispatcher = ActionScriptEventDispatchUtils.isEventDispatcher(jsClass);
        return new EventBinder(){

            @Override
            public boolean isBindEvent() {
                return isEventDispatcher;
            }

            @Override
            public String getEventName(String parameterName) {
                return JSFormatterUtil.transformVarNameToAccessorName((String)parameterName, (PsiElement)jsClass) + "Changed";
            }

            @Override
            public boolean isCreateEventConstant() {
                return isEventDispatcher;
            }

            @Override
            public String getEventConstantName(String parameterName) {
                return StringUtil.toUpperCase((String)JSFormatterUtil.transformVarNameToAccessorName((String)parameterName, (PsiElement)jsClass)) + "_CHANGED_EVENT";
            }
        };
    }
}

