/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.terminal.highlighting;

import com.intellij.ideolog.statistics.IdeologUsagesCollector;
import com.intellij.ideolog.terminal.highlighting.TerminalCommandBlockHighlighterKt;
import com.intellij.ideolog.terminal.highlighting.TerminalLogEditorHighlighter;
import com.intellij.ideolog.util.IdeologContextDetectorKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ideolog/terminal/highlighting/TerminalCommandBlockHighlighter;", "Lorg/jetbrains/plugins/terminal/block/output/highlighting/TerminalCommandBlockHighlighter;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "highlightingInfos", "Ljava/util/TreeSet;", "Lcom/intellij/ideolog/terminal/highlighting/TerminalCommandBlockHighlighter$HighlightingInfo;", "highlighter", "Lcom/intellij/ideolog/terminal/highlighting/TerminalLogEditorHighlighter;", "editor", "Lcom/intellij/openapi/editor/highlighter/HighlighterClient;", "shouldHighlight", "", "startOffset", "", "applyHighlightingInfoToBlock", "", "block", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "createIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "setEditor", "shouldHighlightCommandBlock", "command", "", "HighlightingInfo", "intellij.ideolog.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCommandBlockHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCommandBlockHighlighter.kt\ncom/intellij/ideolog/terminal/highlighting/TerminalCommandBlockHighlighter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1869#2,2:110\n1761#2,3:112\n*S KotlinDebug\n*F\n+ 1 TerminalCommandBlockHighlighter.kt\ncom/intellij/ideolog/terminal/highlighting/TerminalCommandBlockHighlighter\n*L\n72#1:110,2\n97#1:112,3\n*E\n"})
public final class TerminalCommandBlockHighlighter
implements org.jetbrains.plugins.terminal.block.output.highlighting.TerminalCommandBlockHighlighter {
    @NotNull
    private final TreeSet<HighlightingInfo> highlightingInfos;
    @NotNull
    private final TerminalLogEditorHighlighter highlighter;
    private HighlighterClient editor;

    public TerminalCommandBlockHighlighter(@NotNull EditorColorsScheme colorsScheme) {
        Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
        this.highlightingInfos = new TreeSet();
        this.highlighter = new TerminalLogEditorHighlighter(this.highlightingInfos, colorsScheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldHighlight(int startOffset) {
        if (!Registry.Companion.is("ideolog.terminal.enabled")) {
            return false;
        }
        if (this.editor == null) {
            return false;
        }
        HighlighterClient highlighterClient = this.editor;
        if (highlighterClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
            highlighterClient = null;
        }
        Document document = highlighterClient.getDocument();
        int lineNumber = document.getLineNumber(startOffset);
        HighlightingInfo dummyHighlightingInfo = new HighlightingInfo(startOffset, false, 2, null);
        TreeSet<HighlightingInfo> treeSet = this.highlightingInfos;
        synchronized (treeSet) {
            HighlightingInfo highlightingInfo;
            HighlightingInfo lowerBoundInfo;
            block11: {
                HighlightingInfo highlightingInfo2;
                block10: {
                    boolean bl = false;
                    if (this.highlightingInfos.floor(dummyHighlightingInfo) != null) break block10;
                    return false;
                }
                lowerBoundInfo = highlightingInfo2;
                if (lowerBoundInfo.getCommandStartOffset() == startOffset) {
                    return false;
                }
                if (this.highlightingInfos.higher(dummyHighlightingInfo) != null) break block11;
                return lowerBoundInfo.getShouldHighlight();
            }
            HighlightingInfo followingInfo = highlightingInfo;
            if (document.getLineCount() > lineNumber + 1 && followingInfo.getCommandStartOffset() == document.getLineStartOffset(lineNumber + 1)) {
                return false;
            }
            boolean bl = lowerBoundInfo.getShouldHighlight();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyHighlightingInfoToBlock(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String command = block.getCommand();
        if (command != null) {
            TreeSet<HighlightingInfo> treeSet = this.highlightingInfos;
            synchronized (treeSet) {
                boolean bl = false;
                boolean shouldHighlight = this.shouldHighlightCommandBlock(command);
                if (shouldHighlight && this.editor != null) {
                    HighlighterClient highlighterClient = this.editor;
                    if (highlighterClient == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
                        highlighterClient = null;
                    }
                    Project project = highlighterClient.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    IdeologUsagesCollector.INSTANCE.logOpenLogFileInTerminal(project);
                }
                boolean bl2 = this.highlightingInfos.add(new HighlightingInfo(block.getCommandStartOffset(), shouldHighlight));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getDocument().getTextLength() == 0) {
            TreeSet<HighlightingInfo> treeSet = this.highlightingInfos;
            synchronized (treeSet) {
                boolean bl = false;
                this.highlightingInfos.clear();
                Unit unit = Unit.INSTANCE;
                return;
            }
        }
        if (event.getOldLength() <= event.getNewLength()) return;
        CharSequence charSequence = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = true;
        boolean isRemovedNonEmptyPrompt = bl2;
        if (!isRemovedNonEmptyPrompt) return;
        HighlighterClient highlighterClient = this.highlightingInfos;
        synchronized (highlighterClient) {
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.highlightingInfos;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HighlightingInfo info = (HighlightingInfo)element$iv;
                boolean bl4 = false;
                if (event.getOffset() >= info.getCommandStartOffset()) continue;
                info.setCommandStartOffset(info.getCommandStartOffset() - (event.getOldLength() - event.getNewLength()));
            }
            bl3 = this.highlightingInfos.removeIf(arg_0 -> TerminalCommandBlockHighlighter.documentChanged$lambda$1$2(TerminalCommandBlockHighlighter::documentChanged$lambda$1$1, arg_0));
        }
        if (this.editor == null) return;
        HighlighterClient highlighterClient2 = this.editor;
        if (highlighterClient2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
            highlighterClient2 = null;
        }
        if (!((highlighterClient = highlighterClient2) instanceof Editor)) return;
        Editor editor = (Editor)highlighterClient;
        if (editor == null) return;
        Editor $this$documentChanged_u24lambda_u242 = editor;
        boolean bl5 = false;
        IdeologContextDetectorKt.detectIdeologContext($this$documentChanged_u24lambda_u242).clear();
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        return this.highlighter.createIterator(startOffset);
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.highlighter.setEditor(editor);
        this.editor = editor;
    }

    private final boolean shouldHighlightCommandBlock(CharSequence command) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = TerminalCommandBlockHighlighterKt.getFileReadCommands();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String baseCommand = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((CharSequence)command, (CharSequence)baseCommand, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && StringsKt.endsWith((CharSequence)command, (CharSequence)".log", (boolean)true);
    }

    private static final boolean documentChanged$lambda$1$1(HighlightingInfo info) {
        return info.getCommandStartOffset() < 0;
    }

    private static final boolean documentChanged$lambda$1$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ideolog/terminal/highlighting/TerminalCommandBlockHighlighter$HighlightingInfo;", "", "commandStartOffset", "", "shouldHighlight", "", "<init>", "(IZ)V", "getCommandStartOffset", "()I", "setCommandStartOffset", "(I)V", "getShouldHighlight", "()Z", "setShouldHighlight", "(Z)V", "compareTo", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "intellij.ideolog.terminal"})
    public static final class HighlightingInfo
    implements Comparable<HighlightingInfo> {
        private int commandStartOffset;
        private boolean shouldHighlight;

        public HighlightingInfo(int commandStartOffset, boolean shouldHighlight) {
            this.commandStartOffset = commandStartOffset;
            this.shouldHighlight = shouldHighlight;
        }

        public /* synthetic */ HighlightingInfo(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(n, bl);
        }

        public final int getCommandStartOffset() {
            return this.commandStartOffset;
        }

        public final void setCommandStartOffset(int n) {
            this.commandStartOffset = n;
        }

        public final boolean getShouldHighlight() {
            return this.shouldHighlight;
        }

        public final void setShouldHighlight(boolean bl) {
            this.shouldHighlight = bl;
        }

        @Override
        public int compareTo(@NotNull HighlightingInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)this.commandStartOffset, (int)other.commandStartOffset);
        }

        public final int component1() {
            return this.commandStartOffset;
        }

        public final boolean component2() {
            return this.shouldHighlight;
        }

        @NotNull
        public final HighlightingInfo copy(int commandStartOffset, boolean shouldHighlight) {
            return new HighlightingInfo(commandStartOffset, shouldHighlight);
        }

        public static /* synthetic */ HighlightingInfo copy$default(HighlightingInfo highlightingInfo, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = highlightingInfo.commandStartOffset;
            }
            if ((n2 & 2) != 0) {
                bl = highlightingInfo.shouldHighlight;
            }
            return highlightingInfo.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "HighlightingInfo(commandStartOffset=" + this.commandStartOffset + ", shouldHighlight=" + this.shouldHighlight + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.commandStartOffset);
            result = result * 31 + Boolean.hashCode(this.shouldHighlight);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HighlightingInfo)) {
                return false;
            }
            HighlightingInfo highlightingInfo = (HighlightingInfo)other;
            if (this.commandStartOffset != highlightingInfo.commandStartOffset) {
                return false;
            }
            return this.shouldHighlight == highlightingInfo.shouldHighlight;
        }
    }
}

