/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting.settings;

import com.intellij.ideolog.highlighting.settings.DefaultSettingsStoreItems;
import com.intellij.ideolog.highlighting.settings.ExternalPatternsStore;
import com.intellij.ideolog.highlighting.settings.LogHighlightingPattern;
import com.intellij.ideolog.highlighting.settings.LogParsingPattern;
import com.intellij.ideolog.util.KotlinBeautyKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="LogHighlightingSettings", storages={@Storage(value="log_highlighting.xml", roamingType=RoamingType.DEFAULT)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000fH\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0003J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0002J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0006\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;", "", "<init>", "()V", "myState", "getMyState", "()Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;", "setMyState", "(Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;)V", "myListeners", "Ljava/util/HashSet;", "Lkotlin/Function0;", "", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsListener;", "addSettingsListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "fireListeners", "getState", "upgradeState", "state", "loadState", "initializeComponent", "mergeAnotherState", "newState", "equals", "", "other", "", "hashCode", "", "Companion", "State", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogHighlightingSettingsStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHighlightingSettingsStore.kt\ncom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,599:1\n1869#2,2:600\n1869#2,2:602\n774#2:604\n865#2:605\n866#2:607\n774#2:608\n865#2,2:609\n1869#2,2:611\n1869#2,2:613\n1563#2:615\n1634#2,3:616\n1563#2:619\n1634#2,3:620\n1563#2:623\n1634#2,3:624\n1563#2:627\n1634#2,3:628\n1869#2,2:631\n1869#2,2:637\n1563#2:639\n1634#2,3:640\n1563#2:643\n1634#2,3:644\n1563#2:647\n1634#2,3:648\n1#3:606\n37#4,2:633\n37#4,2:635\n*S KotlinDebug\n*F\n+ 1 LogHighlightingSettingsStore.kt\ncom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore\n*L\n354#1:600,2\n372#1:602,2\n403#1:604\n403#1:605\n403#1:607\n407#1:608\n407#1:609,2\n174#1:611,2\n191#1:613,2\n205#1:615\n205#1:616,3\n215#1:619\n215#1:620,3\n225#1:623\n225#1:624,3\n276#1:627\n276#1:628,3\n284#1:631,2\n300#1:637,2\n302#1:639\n302#1:640,3\n306#1:643\n306#1:644,3\n322#1:647\n322#1:648,3\n298#1:633,2\n299#1:635,2\n*E\n"})
public final class LogHighlightingSettingsStore
implements PersistentStateComponent<State>,
Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State myState = cleanState.clone();
    @NotNull
    private final HashSet<Function0<Unit>> myListeners = new HashSet();
    @NotNull
    private static final Logger logger;
    public static final int CURRENT_SETTINGS_VERSION = 14;
    @NotNull
    private static final State cleanState;
    @NotNull
    private static final Map<Integer, Function1<State, State>> settingsUpgraders;
    @NotNull
    private static final Set<Function1<State, State>> externalSettingsUpgraders;

    @NotNull
    public final State getMyState() {
        return this.myState;
    }

    public final void setMyState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"<set-?>");
        this.myState = state;
    }

    @RequiresEdt
    public final void addSettingsListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.myListeners.add(listener);
        Disposer.register((Disposable)disposable, () -> LogHighlightingSettingsStore.addSettingsListener$lambda$0(this, listener));
    }

    @RequiresEdt
    private final void fireListeners() {
        Iterable $this$forEach$iv = this.myListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    private final State upgradeState(State state) {
        Object newState = null;
        newState = state;
        while (((State)newState).getVersion() < 14) {
            State state2;
            Function1<State, State> upgrader = settingsUpgraders.get(((State)newState).getVersion());
            if (upgrader == null) {
                logger.warn("Upgrader for version " + ((State)newState).getVersion() + " not found, performing hard reset of settings");
                state2 = cleanState.clone();
            } else {
                state2 = (State)upgrader.invoke(newState);
            }
            newState = state2;
        }
        Iterable $this$forEach$iv = externalSettingsUpgraders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 externalUpgrader = (Function1)element$iv;
            boolean bl = false;
            newState = externalUpgrader.invoke(newState);
        }
        return newState;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
        this.fireListeners();
    }

    public void initializeComponent() {
        int n;
        this.myState = this.upgradeState(this.myState);
        try {
            n = Integer.parseInt(this.myState.getLastAddedDefaultFormat());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        int lastAddedDefaultFormatOld = n;
        if (lastAddedDefaultFormatOld < cleanState.getParsingPatterns().size()) {
            this.myState.getParsingPatterns().addAll((Collection<LogParsingPattern>)cleanState.getParsingPatterns().subList(Integer.parseInt(this.myState.getLastAddedDefaultFormat()), cleanState.getParsingPatterns().size()));
            this.myState.setLastAddedDefaultFormat(String.valueOf(cleanState.getParsingPatterns().size()));
            this.fireListeners();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeAnotherState(@NotNull State newState) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Iterable $this$filter$iv = newState.getParsingPatterns();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Object v0;
            block4: {
                LogParsingPattern newParsingPattern = (LogParsingPattern)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = this.myState.getParsingPatterns();
                for (Object object : iterable2) {
                    LogParsingPattern parsingPattern = (LogParsingPattern)object;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)parsingPattern.getUuid(), (Object)newParsingPattern.getUuid())) continue;
                    v0 = object;
                    break block4;
                }
                v0 = null;
            }
            if (!(v0 == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newParsingPatterns = (List)destination$iv$iv;
        this.myState.getParsingPatterns().addAll(newParsingPatterns);
        Iterable $this$filter$iv2 = newState.getPatterns();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v1;
            block5: {
                Object object;
                LogHighlightingPattern newHighlightingPattern = (LogHighlightingPattern)element$iv$iv;
                boolean bl = false;
                Iterable iterable3 = this.myState.getPatterns();
                object = iterable3.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    LogHighlightingPattern highlightingPattern = (LogHighlightingPattern)e;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)highlightingPattern.getUuid(), (Object)newHighlightingPattern.getUuid())) continue;
                    v1 = e;
                    break block5;
                }
                v1 = null;
            }
            if (!(v1 == null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newHighlightingPatterns = (List)destination$iv$iv2;
        this.myState.getPatterns().addAll(newHighlightingPatterns);
        this.fireListeners();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass())) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore");
        LogHighlightingSettingsStore cfr_ignored_0 = (LogHighlightingSettingsStore)object2;
        return Intrinsics.areEqual((Object)this.myState, (Object)((LogHighlightingSettingsStore)other).myState);
    }

    public int hashCode() {
        return this.myState.hashCode();
    }

    private static final void addSettingsListener$lambda$0(LogHighlightingSettingsStore this$0, Function0 $listener) {
        this$0.myListeners.remove($listener);
    }

    private static final State settingsUpgraders$lambda$0(State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return cleanState.clone();
    }

    private static final State settingsUpgraders$lambda$1(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        newState.setVersion(1);
        newState.getParsingPatterns().addAll((Collection<LogParsingPattern>)cleanState.getParsingPatterns());
        return newState;
    }

    private static final State settingsUpgraders$lambda$2(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        newState.setErrorStripeMode("heatmap");
        newState.setLastAddedDefaultFormat("3");
        newState.setVersion(2);
        return newState;
    }

    private static final State settingsUpgraders$lambda$3(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        newState.setVersion(3);
        newState.setReadonlySizeThreshold("16");
        return newState;
    }

    private static final State settingsUpgraders$lambda$4(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        if (newState.getPatterns().size() >= 3 && Intrinsics.areEqual((Object)newState.getPatterns().get(1).getPattern(), (Object)"^\\s*w(arning)?\\s*$")) {
            ArrayList<LogHighlightingPattern> arrayList = newState.getPatterns();
            LogHighlightingPattern logHighlightingPattern = newState.getPatterns().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)logHighlightingPattern, (String)"get(...)");
            arrayList.set(1, LogHighlightingPattern.copy$default(logHighlightingPattern, false, "^\\s*w(arn(ing)?)?\\s*$", null, 0, null, null, null, false, false, false, null, 2045, null));
        }
        newState.setVersion(4);
        return newState;
    }

    /*
     * WARNING - void declaration
     */
    private static final State settingsUpgraders$lambda$5(State oldState) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        Cloneable it;
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        Iterable $this$forEach$iv = newState.getParsingPatterns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LogParsingPattern)element$iv;
            boolean bl = false;
            string = ((LogParsingPattern)it).getName();
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getTeamCityBuildLog().getName())) {
                ((LogParsingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getTeamCityBuildLog().getUuid());
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getIntelliJIDEA().getName())) {
                ((LogParsingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getIntelliJIDEA().getUuid());
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getPipeSeparated().getName())) {
                ((LogParsingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getPipeSeparated().getUuid());
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getLogcat().getName())) {
                ((LogParsingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getLogcat().getUuid());
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getLoguru().getName())) {
                ((LogParsingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getLoguru().getUuid());
                continue;
            }
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            ((LogParsingPattern)it).setUuid(uUID);
        }
        $this$forEach$iv = newState.getPatterns();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LogHighlightingPattern)element$iv;
            boolean bl = false;
            string = ((LogHighlightingPattern)it).getPattern();
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getError().getPattern())) {
                ((LogHighlightingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getError().getUuid());
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getWarning().getPattern())) {
                ((LogHighlightingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getWarning().getUuid());
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)DefaultSettingsStoreItems.INSTANCE.getInfo().getPattern())) {
                ((LogHighlightingPattern)it).setUuid(DefaultSettingsStoreItems.INSTANCE.getInfo().getUuid());
                continue;
            }
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            ((LogHighlightingPattern)it).setUuid(uUID);
        }
        $this$forEach$iv = DefaultSettingsStoreItems.INSTANCE.getParsingPatternsUUIDs$intellij_ideolog();
        State state = newState;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.toString());
        }
        state.setLastAddedDefaultFormat(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, LogHighlightingSettingsStore::settingsUpgraders$lambda$5$3, (int)30, null));
        newState.setVersion(5);
        return newState;
    }

    private static final CharSequence settingsUpgraders$lambda$5$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final State settingsUpgraders$lambda$6(State oldState) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        Iterable iterable = DefaultSettingsStoreItems.INSTANCE.getParsingPatternsUUIDs$intellij_ideolog();
        State state = newState;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        state.setLastAddedDefaultFormat(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, LogHighlightingSettingsStore::settingsUpgraders$lambda$6$1, (int)30, null));
        newState.setVersion(6);
        return newState;
    }

    private static final CharSequence settingsUpgraders$lambda$6$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final State settingsUpgraders$lambda$7(State oldState) {
        Object v0;
        State newState;
        block3: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
            newState = oldState.clone();
            newState.getParsingPatterns().removeIf(arg_0 -> LogHighlightingSettingsStore.settingsUpgraders$lambda$7$1(LogHighlightingSettingsStore::settingsUpgraders$lambda$7$0, arg_0));
            Iterable iterable = DefaultSettingsStoreItems.INSTANCE.getParsingPatternsUUIDs$intellij_ideolog();
            State state = newState;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UUID uUID = (UUID)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            state.setLastAddedDefaultFormat(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, LogHighlightingSettingsStore::settingsUpgraders$lambda$7$3, (int)30, null));
            iterable2 = newState.getPatterns();
            for (Object t : iterable2) {
                LogHighlightingPattern it = (LogHighlightingPattern)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)DefaultSettingsStoreItems.INSTANCE.getError().getUuid())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        LogHighlightingPattern logHighlightingPattern = v0;
        if (logHighlightingPattern != null) {
            logHighlightingPattern.setPattern(DefaultSettingsStoreItems.INSTANCE.getError().getPattern());
        }
        newState.setVersion(7);
        return newState;
    }

    private static final boolean settingsUpgraders$lambda$7$0(LogParsingPattern it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getUuid(), (Object)UUID.fromString("db0779ce-9fd3-11ec-b909-0242ac120002"));
    }

    private static final boolean settingsUpgraders$lambda$7$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence settingsUpgraders$lambda$7$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final State settingsUpgraders$lambda$8(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        newState.setVersion(8);
        return newState;
    }

    private static final State settingsUpgraders$lambda$9(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        newState.setVersion(9);
        return newState;
    }

    private static final State settingsUpgraders$lambda$10(State oldState) {
        Object v0;
        State newState;
        block2: {
            Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
            newState = oldState.clone();
            Iterable iterable = newState.getPatterns();
            for (Object t : iterable) {
                LogHighlightingPattern it = (LogHighlightingPattern)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)DefaultSettingsStoreItems.INSTANCE.getError().getUuid())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        LogHighlightingPattern logHighlightingPattern = v0;
        if (logHighlightingPattern != null) {
            logHighlightingPattern.setPattern(DefaultSettingsStoreItems.INSTANCE.getError().getPattern());
        }
        newState.setErrorStripeMode("normal");
        newState.setVersion(10);
        return newState;
    }

    private static final State settingsUpgraders$lambda$11(State oldState) {
        Object v0;
        State newState;
        block2: {
            Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
            newState = oldState.clone();
            Iterable iterable = newState.getPatterns();
            for (Object t : iterable) {
                LogHighlightingPattern it = (LogHighlightingPattern)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)DefaultSettingsStoreItems.INSTANCE.getError().getUuid())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        LogHighlightingPattern logHighlightingPattern = v0;
        if (logHighlightingPattern != null) {
            logHighlightingPattern.setShowOnStripe(DefaultSettingsStoreItems.INSTANCE.getError().getShowOnStripe());
        }
        newState.setVersion(11);
        return newState;
    }

    private static final State settingsUpgraders$lambda$12(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        newState.setReadonlySizeThreshold("20971520");
        newState.setVersion(12);
        return newState;
    }

    private static final State settingsUpgraders$lambda$13(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        newState.getParsingPatterns().removeIf(arg_0 -> LogHighlightingSettingsStore.settingsUpgraders$lambda$13$1(LogHighlightingSettingsStore::settingsUpgraders$lambda$13$0, arg_0));
        newState.setVersion(13);
        return newState;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean settingsUpgraders$lambda$13$0(LogParsingPattern highlightingPattern) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)highlightingPattern, (String)"highlightingPattern");
        Object[] objectArray = new String[]{"9a75fe1c-24f0-4e5d-8359-ce4dbb9c4c33", "c1c8800e-b27c-4433-8d4a-3ec5a28f72a9"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UUID.fromString((String)p0));
        }
        return ((List)destination$iv$iv).contains(highlightingPattern.getUuid());
    }

    private static final boolean settingsUpgraders$lambda$13$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final State settingsUpgraders$lambda$14(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        Iterable $this$forEach$iv = newState.getPatterns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogHighlightingPattern highlightingPattern = (LogHighlightingPattern)element$iv;
            boolean bl = false;
            if (!DefaultSettingsStoreItems.INSTANCE.getHighlightingPatternsUUIDs$intellij_ideolog().contains(highlightingPattern.getUuid())) continue;
            highlightingPattern.setCaptureGroup(-1);
        }
        newState.setVersion(14);
        return newState;
    }

    /*
     * WARNING - void declaration
     */
    private static final State externalSettingsUpgraders$lambda$0(State oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        State newState = oldState.clone();
        if (!LogHighlightingSettingsStore.Companion.isExternalParamsUpToDate(newState)) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Object element$iv2;
            Collection $this$toTypedArray$iv = ExternalPatternsStore.INSTANCE.getParsingPatterns();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Cloneable[] cloneableArray = thisCollection$iv.toArray(new LogParsingPattern[0]);
            newState.setExternalParsingPatterns(CollectionsKt.arrayListOf((Object[])Arrays.copyOf(cloneableArray, cloneableArray.length)));
            $this$toTypedArray$iv = ExternalPatternsStore.INSTANCE.getHighlightingPatterns();
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            cloneableArray = thisCollection$iv.toArray(new LogHighlightingPattern[0]);
            newState.setExternalHighlightingPatterns(CollectionsKt.arrayListOf((Object[])Arrays.copyOf(cloneableArray, cloneableArray.length)));
            Iterable $this$forEach$iv = newState.getParsingPatterns();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                LogParsingPattern parsingPattern = (LogParsingPattern)element$iv2;
                boolean bl = false;
                parsingPattern.setEnabled(false);
            }
            Iterable $this$map$iv = ExternalPatternsStore.INSTANCE.getParsingPatterns();
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                LogParsingPattern logParsingPattern = (LogParsingPattern)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUuid());
            }
            List externalParsingPatternUuids = (List)destination$iv$iv;
            newState.getParsingPatterns().removeIf(arg_0 -> LogHighlightingSettingsStore.externalSettingsUpgraders$lambda$0$3(arg_0 -> LogHighlightingSettingsStore.externalSettingsUpgraders$lambda$0$2(externalParsingPatternUuids, arg_0), arg_0));
            newState.getParsingPatterns().addAll((Collection<LogParsingPattern>)ExternalPatternsStore.INSTANCE.getParsingPatterns());
            Iterable $this$map$iv2 = ExternalPatternsStore.INSTANCE.getHighlightingPatterns();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LogHighlightingPattern bl = (LogHighlightingPattern)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getUuid());
            }
            List externalHighlightingPatternUuids = (List)destination$iv$iv2;
            newState.getPatterns().removeIf(arg_0 -> LogHighlightingSettingsStore.externalSettingsUpgraders$lambda$0$6(arg_0 -> LogHighlightingSettingsStore.externalSettingsUpgraders$lambda$0$5(externalHighlightingPatternUuids, arg_0), arg_0));
            newState.getPatterns().addAll((Collection<LogHighlightingPattern>)ExternalPatternsStore.INSTANCE.getHighlightingPatterns());
        }
        newState.getPatterns().removeIf(arg_0 -> LogHighlightingSettingsStore.externalSettingsUpgraders$lambda$0$8(LogHighlightingSettingsStore::externalSettingsUpgraders$lambda$0$7, arg_0));
        return newState;
    }

    private static final boolean externalSettingsUpgraders$lambda$0$2(List $externalParsingPatternUuids, LogParsingPattern existingParsingPattern) {
        Intrinsics.checkNotNullParameter((Object)existingParsingPattern, (String)"existingParsingPattern");
        return $externalParsingPatternUuids.contains(existingParsingPattern.getUuid());
    }

    private static final boolean externalSettingsUpgraders$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean externalSettingsUpgraders$lambda$0$5(List $externalHighlightingPatternUuids, LogHighlightingPattern existingHighlightingPattern) {
        Intrinsics.checkNotNullParameter((Object)existingHighlightingPattern, (String)"existingHighlightingPattern");
        return $externalHighlightingPatternUuids.contains(existingHighlightingPattern.getUuid());
    }

    private static final boolean externalSettingsUpgraders$lambda$0$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean externalSettingsUpgraders$lambda$0$7(LogHighlightingPattern highlightingPattern) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)highlightingPattern, (String)"highlightingPattern");
        Object[] objectArray = new String[]{"ceb277ea-e937-431f-93c7-fef9aab016c5", "a1f4e368-1ab5-4920-b0cc-6701063bd08e", "2dc05512-9066-4439-83b3-fada1287e486", "9d83979c-74f1-41cc-b342-7f471e225c1e", "f29fc557-7be9-4289-bea3-f4cfb235f23b", "1dcadf54-8ba8-431d-9e58-76a10ce12241", "18a36367-bd09-4163-8e6d-e2410e6ffd08", "acab2e5f-b0b7-4d16-8a88-617c818abfb6", "a72b5cbd-5420-47af-91ca-ef8339d2bb82", "b4d82f98-2420-47ae-a8d2-a383e7082b85"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UUID.fromString((String)p0));
        }
        return ((List)destination$iv$iv).contains(highlightingPattern.getUuid());
    }

    private static final boolean externalSettingsUpgraders$lambda$0$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance((String)"LogHighlightingSettingsStore");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LogHighlightingSettingsStore.logger = logger;
        cleanState = new State(null, null, null, 0, null, null, null, false, null, null, 1023, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)-1, LogHighlightingSettingsStore::settingsUpgraders$lambda$0), TuplesKt.to((Object)0, LogHighlightingSettingsStore::settingsUpgraders$lambda$1), TuplesKt.to((Object)1, LogHighlightingSettingsStore::settingsUpgraders$lambda$2), TuplesKt.to((Object)2, LogHighlightingSettingsStore::settingsUpgraders$lambda$3), TuplesKt.to((Object)3, LogHighlightingSettingsStore::settingsUpgraders$lambda$4), TuplesKt.to((Object)4, LogHighlightingSettingsStore::settingsUpgraders$lambda$5), TuplesKt.to((Object)5, LogHighlightingSettingsStore::settingsUpgraders$lambda$6), TuplesKt.to((Object)6, LogHighlightingSettingsStore::settingsUpgraders$lambda$7), TuplesKt.to((Object)7, LogHighlightingSettingsStore::settingsUpgraders$lambda$8), TuplesKt.to((Object)8, LogHighlightingSettingsStore::settingsUpgraders$lambda$9), TuplesKt.to((Object)9, LogHighlightingSettingsStore::settingsUpgraders$lambda$10), TuplesKt.to((Object)10, LogHighlightingSettingsStore::settingsUpgraders$lambda$11), TuplesKt.to((Object)11, LogHighlightingSettingsStore::settingsUpgraders$lambda$12), TuplesKt.to((Object)12, LogHighlightingSettingsStore::settingsUpgraders$lambda$13), TuplesKt.to((Object)13, LogHighlightingSettingsStore::settingsUpgraders$lambda$14)};
        settingsUpgraders = MapsKt.mapOf((Pair[])pairArray);
        externalSettingsUpgraders = SetsKt.setOf(LogHighlightingSettingsStore::externalSettingsUpgraders$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CURRENT_SETTINGS_VERSION", "", "cleanState", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;", "settingsUpgraders", "", "Lkotlin/Function1;", "externalSettingsUpgraders", "", "isExternalParamsUpToDate", "", "state", "intellij.ideolog"})
    @SourceDebugExtension(value={"SMAP\nLogHighlightingSettingsStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHighlightingSettingsStore.kt\ncom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$Companion\n+ 2 KotlinBeauty.kt\ncom/intellij/ideolog/util/KotlinBeautyKt\n*L\n1#1,599:1\n6#2:600\n*S KotlinDebug\n*F\n+ 1 LogHighlightingSettingsStore.kt\ncom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$Companion\n*L\n134#1:600\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogHighlightingSettingsStore getInstance() {
            boolean $i$f$getService = false;
            return (LogHighlightingSettingsStore)KotlinBeautyKt.getApplication().getService(LogHighlightingSettingsStore.class);
        }

        private final boolean isExternalParamsUpToDate(State state) {
            if (state.getExternalParsingPatterns().size() != ExternalPatternsStore.INSTANCE.getParsingPatterns().size() || state.getExternalHighlightingPatterns().size() != ExternalPatternsStore.INSTANCE.getHighlightingPatterns().size()) {
                return false;
            }
            return CollectionsKt.toHashSet((Iterable)state.getExternalParsingPatterns()).containsAll((Collection)ExternalPatternsStore.INSTANCE.getParsingPatterns()) && CollectionsKt.toHashSet((Iterable)ExternalPatternsStore.INSTANCE.getParsingPatterns()).containsAll((Collection)state.getExternalParsingPatterns()) && CollectionsKt.toHashSet((Iterable)state.getExternalHighlightingPatterns()).containsAll((Collection)ExternalPatternsStore.INSTANCE.getHighlightingPatterns()) && CollectionsKt.toHashSet((Iterable)ExternalPatternsStore.INSTANCE.getHighlightingPatterns()).containsAll((Collection)state.getExternalHighlightingPatterns());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b+\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0089\u0001\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010-\u001a\u00020\u0000H\u0016J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\nH\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J\t\u00103\u001a\u00020\u0006H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\u000fH\u00c6\u0003J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u008b\u0001\u00108\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u00109\u001a\u00020\u000f2\b\u0010:\u001a\u0004\u0018\u00010;H\u00d6\u0003J\t\u0010<\u001a\u00020\nH\u00d6\u0001J\t\u0010=\u001a\u00020\u0006H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u000b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010\f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR\u001e\u0010\r\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001fR\u001e\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010*R$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010*\u00a8\u0006>"}, d2={"Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;", "", "patterns", "Ljava/util/ArrayList;", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingPattern;", "hidden", "", "parsingPatterns", "Lcom/intellij/ideolog/highlighting/settings/LogParsingPattern;", "version", "", "lastAddedDefaultFormat", "errorStripeMode", "readonlySizeThreshold", "highlightLinks", "", "externalParsingPatterns", "externalHighlightingPatterns", "<init>", "(Ljava/util/ArrayList;Ljava/util/ArrayList;Ljava/util/ArrayList;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/ArrayList;Ljava/util/ArrayList;)V", "getPatterns", "()Ljava/util/ArrayList;", "getHidden", "getParsingPatterns", "getVersion", "()I", "setVersion", "(I)V", "getLastAddedDefaultFormat", "()Ljava/lang/String;", "setLastAddedDefaultFormat", "(Ljava/lang/String;)V", "getErrorStripeMode", "setErrorStripeMode", "getReadonlySizeThreshold", "setReadonlySizeThreshold", "getHighlightLinks", "()Z", "setHighlightLinks", "(Z)V", "getExternalParsingPatterns", "setExternalParsingPatterns", "(Ljava/util/ArrayList;)V", "getExternalHighlightingPatterns", "setExternalHighlightingPatterns", "clone", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "", "hashCode", "toString", "intellij.ideolog"})
    @SourceDebugExtension(value={"SMAP\nLogHighlightingSettingsStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHighlightingSettingsStore.kt\ncom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,599:1\n1563#2:600\n1634#2,3:601\n1869#2,2:604\n1869#2,2:606\n1869#2,2:608\n1869#2,2:610\n1869#2,2:612\n*S KotlinDebug\n*F\n+ 1 LogHighlightingSettingsStore.kt\ncom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State\n*L\n452#1:600\n452#1:601,3\n469#1:604,2\n472#1:606,2\n475#1:608,2\n478#1:610,2\n481#1:612,2\n*E\n"})
    public static final class State
    implements Cloneable {
        @XCollection(style=XCollection.Style.v2)
        @Tag(value="highlightingPatterns")
        @NotNull
        private final ArrayList<LogHighlightingPattern> patterns;
        @XCollection(style=XCollection.Style.v2)
        @Tag(value="hiddenSubstrings")
        @NotNull
        private final ArrayList<String> hidden;
        @XCollection(style=XCollection.Style.v2)
        @Tag(value="parsingPatterns")
        @NotNull
        private final ArrayList<LogParsingPattern> parsingPatterns;
        @Tag(value="settingsVersion")
        @Property(alwaysWrite=true)
        private int version;
        @Tag(value="lastAddedDefaultFormat")
        @NotNull
        private String lastAddedDefaultFormat;
        @Tag(value="errorStripeModel")
        @NotNull
        private String errorStripeMode;
        @Tag(value="readonlySizeThreshold")
        @NotNull
        private String readonlySizeThreshold;
        @Tag(value="highlight_links")
        private boolean highlightLinks;
        @XCollection(style=XCollection.Style.v2)
        @Tag(value="externalParsingPatterns")
        @NotNull
        private ArrayList<LogParsingPattern> externalParsingPatterns;
        @XCollection(style=XCollection.Style.v2)
        @Tag(value="externalHighlightingPatterns")
        @NotNull
        private ArrayList<LogHighlightingPattern> externalHighlightingPatterns;

        public State(@NotNull ArrayList<LogHighlightingPattern> patterns, @NotNull ArrayList<String> hidden, @NotNull ArrayList<LogParsingPattern> parsingPatterns, int version, @NotNull String lastAddedDefaultFormat, @NotNull String errorStripeMode, @NotNull String readonlySizeThreshold, boolean highlightLinks, @NotNull ArrayList<LogParsingPattern> externalParsingPatterns, @NotNull ArrayList<LogHighlightingPattern> externalHighlightingPatterns) {
            Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
            Intrinsics.checkNotNullParameter(hidden, (String)"hidden");
            Intrinsics.checkNotNullParameter(parsingPatterns, (String)"parsingPatterns");
            Intrinsics.checkNotNullParameter((Object)lastAddedDefaultFormat, (String)"lastAddedDefaultFormat");
            Intrinsics.checkNotNullParameter((Object)errorStripeMode, (String)"errorStripeMode");
            Intrinsics.checkNotNullParameter((Object)readonlySizeThreshold, (String)"readonlySizeThreshold");
            Intrinsics.checkNotNullParameter(externalParsingPatterns, (String)"externalParsingPatterns");
            Intrinsics.checkNotNullParameter(externalHighlightingPatterns, (String)"externalHighlightingPatterns");
            this.patterns = patterns;
            this.hidden = hidden;
            this.parsingPatterns = parsingPatterns;
            this.version = version;
            this.lastAddedDefaultFormat = lastAddedDefaultFormat;
            this.errorStripeMode = errorStripeMode;
            this.readonlySizeThreshold = readonlySizeThreshold;
            this.highlightLinks = highlightLinks;
            this.externalParsingPatterns = externalParsingPatterns;
            this.externalHighlightingPatterns = externalHighlightingPatterns;
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ State(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, String string, String string2, String string3, boolean bl, ArrayList arrayList4, ArrayList arrayList5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            Cloneable[] cloneableArray;
            if ((n2 & 1) != 0) {
                cloneableArray = new LogHighlightingPattern[]{DefaultSettingsStoreItems.INSTANCE.getError(), DefaultSettingsStoreItems.INSTANCE.getWarning(), DefaultSettingsStoreItems.INSTANCE.getInfo()};
                arrayList = CollectionsKt.arrayListOf((Object[])cloneableArray);
            }
            if ((n2 & 2) != 0) {
                arrayList2 = new ArrayList<String>();
            }
            if ((n2 & 4) != 0) {
                cloneableArray = new LogParsingPattern[]{DefaultSettingsStoreItems.INSTANCE.getPipeSeparated(), DefaultSettingsStoreItems.INSTANCE.getIntelliJIDEA(), DefaultSettingsStoreItems.INSTANCE.getTeamCityBuildLog(), DefaultSettingsStoreItems.INSTANCE.getLoguru(), DefaultSettingsStoreItems.INSTANCE.getLogcat()};
                arrayList3 = CollectionsKt.arrayListOf((Object[])cloneableArray);
            }
            if ((n2 & 8) != 0) {
                n = 1;
            }
            if ((n2 & 0x10) != 0) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = DefaultSettingsStoreItems.INSTANCE.getParsingPatternsUUIDs$intellij_ideolog();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UUID uUID = (UUID)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.toString());
                }
                string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, State::_init_$lambda$1, (int)30, null);
            }
            if ((n2 & 0x20) != 0) {
                string2 = "normal";
            }
            if ((n2 & 0x40) != 0) {
                string3 = "20480";
            }
            if ((n2 & 0x80) != 0) {
                bl = true;
            }
            if ((n2 & 0x100) != 0) {
                arrayList4 = new ArrayList<LogParsingPattern>();
            }
            if ((n2 & 0x200) != 0) {
                arrayList5 = new ArrayList<LogHighlightingPattern>();
            }
            this(arrayList, arrayList2, arrayList3, n, string, string2, string3, bl, arrayList4, arrayList5);
        }

        @NotNull
        public final ArrayList<LogHighlightingPattern> getPatterns() {
            return this.patterns;
        }

        @NotNull
        public final ArrayList<String> getHidden() {
            return this.hidden;
        }

        @NotNull
        public final ArrayList<LogParsingPattern> getParsingPatterns() {
            return this.parsingPatterns;
        }

        public final int getVersion() {
            return this.version;
        }

        public final void setVersion(int n) {
            this.version = n;
        }

        @NotNull
        public final String getLastAddedDefaultFormat() {
            return this.lastAddedDefaultFormat;
        }

        public final void setLastAddedDefaultFormat(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.lastAddedDefaultFormat = string;
        }

        @NotNull
        public final String getErrorStripeMode() {
            return this.errorStripeMode;
        }

        public final void setErrorStripeMode(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.errorStripeMode = string;
        }

        @NotNull
        public final String getReadonlySizeThreshold() {
            return this.readonlySizeThreshold;
        }

        public final void setReadonlySizeThreshold(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.readonlySizeThreshold = string;
        }

        public final boolean getHighlightLinks() {
            return this.highlightLinks;
        }

        public final void setHighlightLinks(boolean bl) {
            this.highlightLinks = bl;
        }

        @NotNull
        public final ArrayList<LogParsingPattern> getExternalParsingPatterns() {
            return this.externalParsingPatterns;
        }

        public final void setExternalParsingPatterns(@NotNull ArrayList<LogParsingPattern> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.externalParsingPatterns = arrayList;
        }

        @NotNull
        public final ArrayList<LogHighlightingPattern> getExternalHighlightingPatterns() {
            return this.externalHighlightingPatterns;
        }

        public final void setExternalHighlightingPatterns(@NotNull ArrayList<LogHighlightingPattern> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.externalHighlightingPatterns = arrayList;
        }

        @NotNull
        public State clone() {
            Object it;
            State result = new State(new ArrayList<LogHighlightingPattern>(), new ArrayList<String>(), new ArrayList<LogParsingPattern>(), this.version, this.lastAddedDefaultFormat, this.errorStripeMode, this.readonlySizeThreshold, this.highlightLinks, new ArrayList<LogParsingPattern>(), new ArrayList<LogHighlightingPattern>());
            Iterable $this$forEach$iv = this.patterns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LogHighlightingPattern)element$iv;
                boolean bl = false;
                result.patterns.add(((LogHighlightingPattern)it).clone());
            }
            $this$forEach$iv = this.hidden;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                result.hidden.add((String)it);
            }
            $this$forEach$iv = this.parsingPatterns;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LogParsingPattern)element$iv;
                boolean bl = false;
                result.parsingPatterns.add(((LogParsingPattern)it).clone());
            }
            $this$forEach$iv = this.externalParsingPatterns;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LogParsingPattern)element$iv;
                boolean bl = false;
                result.externalParsingPatterns.add(((LogParsingPattern)it).clone());
            }
            $this$forEach$iv = this.externalHighlightingPatterns;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LogHighlightingPattern)element$iv;
                boolean bl = false;
                result.externalHighlightingPatterns.add(((LogHighlightingPattern)it).clone());
            }
            return result;
        }

        @NotNull
        public final ArrayList<LogHighlightingPattern> component1() {
            return this.patterns;
        }

        @NotNull
        public final ArrayList<String> component2() {
            return this.hidden;
        }

        @NotNull
        public final ArrayList<LogParsingPattern> component3() {
            return this.parsingPatterns;
        }

        public final int component4() {
            return this.version;
        }

        @NotNull
        public final String component5() {
            return this.lastAddedDefaultFormat;
        }

        @NotNull
        public final String component6() {
            return this.errorStripeMode;
        }

        @NotNull
        public final String component7() {
            return this.readonlySizeThreshold;
        }

        public final boolean component8() {
            return this.highlightLinks;
        }

        @NotNull
        public final ArrayList<LogParsingPattern> component9() {
            return this.externalParsingPatterns;
        }

        @NotNull
        public final ArrayList<LogHighlightingPattern> component10() {
            return this.externalHighlightingPatterns;
        }

        @NotNull
        public final State copy(@NotNull ArrayList<LogHighlightingPattern> patterns, @NotNull ArrayList<String> hidden, @NotNull ArrayList<LogParsingPattern> parsingPatterns, int version, @NotNull String lastAddedDefaultFormat, @NotNull String errorStripeMode, @NotNull String readonlySizeThreshold, boolean highlightLinks, @NotNull ArrayList<LogParsingPattern> externalParsingPatterns, @NotNull ArrayList<LogHighlightingPattern> externalHighlightingPatterns) {
            Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
            Intrinsics.checkNotNullParameter(hidden, (String)"hidden");
            Intrinsics.checkNotNullParameter(parsingPatterns, (String)"parsingPatterns");
            Intrinsics.checkNotNullParameter((Object)lastAddedDefaultFormat, (String)"lastAddedDefaultFormat");
            Intrinsics.checkNotNullParameter((Object)errorStripeMode, (String)"errorStripeMode");
            Intrinsics.checkNotNullParameter((Object)readonlySizeThreshold, (String)"readonlySizeThreshold");
            Intrinsics.checkNotNullParameter(externalParsingPatterns, (String)"externalParsingPatterns");
            Intrinsics.checkNotNullParameter(externalHighlightingPatterns, (String)"externalHighlightingPatterns");
            return new State(patterns, hidden, parsingPatterns, version, lastAddedDefaultFormat, errorStripeMode, readonlySizeThreshold, highlightLinks, externalParsingPatterns, externalHighlightingPatterns);
        }

        public static /* synthetic */ State copy$default(State state, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, String string, String string2, String string3, boolean bl, ArrayList arrayList4, ArrayList arrayList5, int n2, Object object) {
            if ((n2 & 1) != 0) {
                arrayList = state.patterns;
            }
            if ((n2 & 2) != 0) {
                arrayList2 = state.hidden;
            }
            if ((n2 & 4) != 0) {
                arrayList3 = state.parsingPatterns;
            }
            if ((n2 & 8) != 0) {
                n = state.version;
            }
            if ((n2 & 0x10) != 0) {
                string = state.lastAddedDefaultFormat;
            }
            if ((n2 & 0x20) != 0) {
                string2 = state.errorStripeMode;
            }
            if ((n2 & 0x40) != 0) {
                string3 = state.readonlySizeThreshold;
            }
            if ((n2 & 0x80) != 0) {
                bl = state.highlightLinks;
            }
            if ((n2 & 0x100) != 0) {
                arrayList4 = state.externalParsingPatterns;
            }
            if ((n2 & 0x200) != 0) {
                arrayList5 = state.externalHighlightingPatterns;
            }
            return state.copy(arrayList, arrayList2, arrayList3, n, string, string2, string3, bl, arrayList4, arrayList5);
        }

        @NotNull
        public String toString() {
            return "State(patterns=" + this.patterns + ", hidden=" + this.hidden + ", parsingPatterns=" + this.parsingPatterns + ", version=" + this.version + ", lastAddedDefaultFormat=" + this.lastAddedDefaultFormat + ", errorStripeMode=" + this.errorStripeMode + ", readonlySizeThreshold=" + this.readonlySizeThreshold + ", highlightLinks=" + this.highlightLinks + ", externalParsingPatterns=" + this.externalParsingPatterns + ", externalHighlightingPatterns=" + this.externalHighlightingPatterns + ")";
        }

        public int hashCode() {
            int result = this.patterns.hashCode();
            result = result * 31 + this.hidden.hashCode();
            result = result * 31 + this.parsingPatterns.hashCode();
            result = result * 31 + Integer.hashCode(this.version);
            result = result * 31 + this.lastAddedDefaultFormat.hashCode();
            result = result * 31 + this.errorStripeMode.hashCode();
            result = result * 31 + this.readonlySizeThreshold.hashCode();
            result = result * 31 + Boolean.hashCode(this.highlightLinks);
            result = result * 31 + this.externalParsingPatterns.hashCode();
            result = result * 31 + this.externalHighlightingPatterns.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.patterns, state.patterns)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hidden, state.hidden)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parsingPatterns, state.parsingPatterns)) {
                return false;
            }
            if (this.version != state.version) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastAddedDefaultFormat, (Object)state.lastAddedDefaultFormat)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.errorStripeMode, (Object)state.errorStripeMode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.readonlySizeThreshold, (Object)state.readonlySizeThreshold)) {
                return false;
            }
            if (this.highlightLinks != state.highlightLinks) {
                return false;
            }
            if (!Intrinsics.areEqual(this.externalParsingPatterns, state.externalParsingPatterns)) {
                return false;
            }
            return Intrinsics.areEqual(this.externalHighlightingPatterns, state.externalHighlightingPatterns);
        }

        private static final CharSequence _init_$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        public State() {
            this(null, null, null, 0, null, null, null, false, null, null, 1023, null);
        }
    }
}

