/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting.settings;

import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.highlighting.settings.LogParsingPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\"\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0003J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0007J\u001f\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00100\u001a0 H\u0000\u00a2\u0006\u0002\b\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ideolog/highlighting/settings/LogFormatTableModel;", "Ljavax/swing/table/AbstractTableModel;", "state", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;", "<init>", "(Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;)V", "getRowCount", "", "getColumnCount", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "isCellEditable", "", "rowIndex", "getColumnName", "", "column", "setValueAt", "", "aValue", "", "getValueAt", "updateStore", "store", "addNewFormat", "Lkotlin/Pair;", "Lcom/intellij/ideolog/highlighting/settings/LogParsingPattern;", "name", "removeFormat", "index", "getParsingPatterns", "", "Ljava/util/UUID;", "getParsingPatterns$intellij_ideolog", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogFormatTableModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFormatTableModel.kt\ncom/intellij/ideolog/highlighting/settings/LogFormatTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1563#2:82\n1634#2,3:83\n*S KotlinDebug\n*F\n+ 1 LogFormatTableModel.kt\ncom/intellij/ideolog/highlighting/settings/LogFormatTableModel\n*L\n77#1:82\n77#1:83,3\n*E\n"})
public final class LogFormatTableModel
extends AbstractTableModel {
    @NotNull
    private LogHighlightingSettingsStore.State state;

    public LogFormatTableModel(@NotNull LogHighlightingSettingsStore.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @Override
    public int getRowCount() {
        return this.state.getParsingPatterns().size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> Boolean.class;
            case 1, 2, 3, 4 -> String.class;
            default -> Object.class;
        };
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return switch (column) {
            case 0 -> IdeologBundle.message("column.enabled", new Object[0]);
            case 1 -> IdeologBundle.message("column.name", new Object[0]);
            case 2 -> IdeologBundle.message("column.message.pattern", new Object[0]);
            case 3 -> IdeologBundle.message("column.message.start.pattern", new Object[0]);
            case 4 -> IdeologBundle.message("column.time.format", new Object[0]);
            default -> "";
        };
    }

    @Override
    public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        if (columnIndex == 0) {
            this.state.getParsingPatterns().get(rowIndex).setEnabled((Boolean)aValue);
        }
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case -1 -> this.state.getParsingPatterns().get(rowIndex);
            case 0 -> this.state.getParsingPatterns().get(rowIndex).getEnabled();
            case 1 -> this.state.getParsingPatterns().get(rowIndex).getName();
            case 2 -> this.state.getParsingPatterns().get(rowIndex).getPattern();
            case 3 -> this.state.getParsingPatterns().get(rowIndex).getLineStartPattern();
            case 4 -> this.state.getParsingPatterns().get(rowIndex).getTimePattern();
            default -> null;
        };
    }

    public final void updateStore(@NotNull LogHighlightingSettingsStore.State store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.state = store;
        this.fireTableDataChanged();
    }

    @NotNull
    public final Pair<Integer, LogParsingPattern> addNewFormat(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        LogParsingPattern pattern = new LogParsingPattern(false, name, "", "", "", -1, -1, -1, uUID);
        this.state.getParsingPatterns().add(pattern);
        int index = this.state.getParsingPatterns().size() - 1;
        this.fireTableRowsInserted(index, index);
        return new Pair((Object)index, (Object)pattern);
    }

    public final void removeFormat(int index) {
        this.state.getParsingPatterns().remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<UUID, String>> getParsingPatterns$intellij_ideolog() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.state.getParsingPatterns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LogParsingPattern logParsingPattern = (LogParsingPattern)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getUuid(), (Object)it.getName()));
        }
        return (List)destination$iv$iv;
    }
}

