/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting;

import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.ideolog.lex.LogToken;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\fJ,\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ideolog/highlighting/LogParsingUtils;", "", "<init>", "()V", "myTokensTL", "Ljava/lang/ThreadLocal;", "Ljava/util/ArrayList;", "Lcom/intellij/ideolog/lex/LogToken;", "myTokens", "getMyTokens", "()Ljava/util/ArrayList;", "getColumnByOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "fileType", "Lcom/intellij/ideolog/lex/LogFileFormat;", "lineSet", "Lcom/intellij/openapi/editor/Document;", "data", "", "offset", "getColumnValueByOffset", "getEventColumnCount", "getEvent", "Lkotlin/Pair;", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogParsingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogParsingUtils.kt\ncom/intellij/ideolog/highlighting/LogParsingUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,85:1\n1#2:86\n1332#3,3:87\n1332#3,3:90\n*S KotlinDebug\n*F\n+ 1 LogParsingUtils.kt\ncom/intellij/ideolog/highlighting/LogParsingUtils\n*L\n30#1:87,3\n51#1:90,3\n*E\n"})
public final class LogParsingUtils {
    @NotNull
    public static final LogParsingUtils INSTANCE = new LogParsingUtils();
    @NotNull
    private static final ThreadLocal<ArrayList<LogToken>> myTokensTL = new ThreadLocal();

    private LogParsingUtils() {
    }

    private final ArrayList<LogToken> getMyTokens() {
        ThreadLocal<ArrayList<LogToken>> threadLocal = myTokensTL;
        ArrayList<LogToken> arrayList = threadLocal.get();
        if (arrayList == null) {
            ArrayList arrayList2;
            boolean bl = false;
            ArrayList arrayList3 = arrayList2 = new ArrayList();
            threadLocal.set(arrayList3);
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public final int getColumnByOffset(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LogFileFormat logFileFormat = LogFileFormatsKt.detectLogFileFormat(editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        return this.getColumnByOffset(logFileFormat, document, charSequence, editor.getCaretModel().getOffset());
    }

    private final int getColumnByOffset(LogFileFormat fileType, Document lineSet, CharSequence data, int offset) {
        Pair<CharSequence, Integer> pair = this.getEvent(lineSet, data, offset);
        CharSequence event = (CharSequence)pair.component1();
        int eventOffset = ((Number)pair.component2()).intValue();
        int inEventTargetOffset = offset - eventOffset;
        this.getMyTokens().clear();
        LogFileFormat.tokenize$default(fileType, event, this.getMyTokens(), false, 4, null);
        Sequence $this$forEachIndexed$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getMyTokens()), LogParsingUtils::getColumnByOffset$lambda$0);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LogToken logToken = (LogToken)item$iv;
            int index = n;
            boolean bl = false;
            int startOffset = logToken.component1();
            int endOffset = logToken.component2();
            boolean bl2 = startOffset <= inEventTargetOffset ? inEventTargetOffset <= endOffset : false;
            if (!bl2) continue;
            return index;
        }
        return -1;
    }

    @Nullable
    public final CharSequence getColumnValueByOffset(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LogFileFormat logFileFormat = LogFileFormatsKt.detectLogFileFormat(editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        return this.getColumnValueByOffset(logFileFormat, document, charSequence, editor.getCaretModel().getOffset());
    }

    private final CharSequence getColumnValueByOffset(LogFileFormat fileType, Document lineSet, CharSequence data, int offset) {
        Pair<CharSequence, Integer> pair = this.getEvent(lineSet, data, offset);
        CharSequence event = (CharSequence)pair.component1();
        int eventOffset = ((Number)pair.component2()).intValue();
        int inEventTargetOffset = offset - eventOffset;
        this.getMyTokens().clear();
        LogFileFormat.tokenize$default(fileType, event, this.getMyTokens(), false, 4, null);
        Sequence $this$forEachIndexed$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getMyTokens()), LogParsingUtils::getColumnValueByOffset$lambda$0);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LogToken logToken = (LogToken)item$iv;
            boolean bl = false;
            if (logToken.getStartOffset() > inEventTargetOffset || logToken.getEndOffset() < inEventTargetOffset) continue;
            return logToken.takeFrom(event);
        }
        return null;
    }

    public final int getEventColumnCount(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LogFileFormat logFileFormat = LogFileFormatsKt.detectLogFileFormat(editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        return this.getEventColumnCount(logFileFormat, document, charSequence, editor.getCaretModel().getOffset());
    }

    private final int getEventColumnCount(LogFileFormat fileType, Document lineSet, CharSequence data, int offset) {
        CharSequence event = (CharSequence)this.getEvent(lineSet, data, offset).component1();
        this.getMyTokens().clear();
        LogFileFormat.tokenize$default(fileType, event, this.getMyTokens(), false, 4, null);
        return SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getMyTokens()), LogParsingUtils::getEventColumnCount$lambda$0));
    }

    @NotNull
    public final Pair<CharSequence, Integer> getEvent(@NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        return this.getEvent(document, charSequence, offset);
    }

    public static /* synthetic */ Pair getEvent$default(LogParsingUtils logParsingUtils, Editor editor, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = editor.getCaretModel().getOffset();
        }
        return logParsingUtils.getEvent(editor, n);
    }

    private final Pair<CharSequence, Integer> getEvent(Document lineSet, CharSequence data, int offset) {
        int line = lineSet.getLineNumber(offset);
        IntRange eventLines = IdeologDocumentContextKt.getIdeologContext(lineSet).getEvent(line);
        int startIndex = lineSet.getLineStartOffset(eventLines.getFirst());
        return TuplesKt.to((Object)data.subSequence(startIndex, lineSet.getLineEndOffset(eventLines.getLast())), (Object)startIndex);
    }

    private static final boolean getColumnByOffset$lambda$0(LogToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSeparator();
    }

    private static final boolean getColumnValueByOffset$lambda$0(LogToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSeparator();
    }

    private static final boolean getEventColumnCount$lambda$0(LogToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSeparator();
    }
}

