/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.project;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import org.jdom.Element;

public final class CucumberJavaScriptProjectConverter
extends ProjectConverter {
    private static final String OLD_CUCUMBER_JS_RUN_CONFIGURATION_TYPE = "CucumberJavaScriptRunConfigurationType";
    private static final String NEW_CUCUMBER_JS_RUN_CONFIGURATION_TYPE = "cucumber.js";
    private static final String TYPE_ATTRIBUTE_NAME = "type";

    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new ConversionProcessor<RunManagerSettings>(this){

            public boolean isConversionNeeded(RunManagerSettings settings) {
                for (Element element : settings.getRunConfigurations()) {
                    String confType = element.getAttributeValue(CucumberJavaScriptProjectConverter.TYPE_ATTRIBUTE_NAME);
                    if (!CucumberJavaScriptProjectConverter.OLD_CUCUMBER_JS_RUN_CONFIGURATION_TYPE.equals(confType)) continue;
                    return true;
                }
                return false;
            }

            public void process(RunManagerSettings settings) throws CannotConvertException {
                for (Element element : settings.getRunConfigurations()) {
                    String confType = element.getAttributeValue(CucumberJavaScriptProjectConverter.TYPE_ATTRIBUTE_NAME);
                    if (!CucumberJavaScriptProjectConverter.OLD_CUCUMBER_JS_RUN_CONFIGURATION_TYPE.equals(confType)) continue;
                    element.setAttribute(CucumberJavaScriptProjectConverter.TYPE_ATTRIBUTE_NAME, CucumberJavaScriptProjectConverter.NEW_CUCUMBER_JS_RUN_CONFIGURATION_TYPE);
                }
            }
        };
    }
}

