/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.behat.steps.BehatPatternPolicy;
import com.jetbrains.php.behat.steps.BehatPatternTextCustomValueProviderKt;
import com.jetbrains.php.behat.steps.BehatRegexPatternPolicy;
import com.jetbrains.php.behat.steps.BehatTurnipPatterPolicy;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public final class BehatPatternExtractor {
    private static final List<BehatPatternPolicy> myPatternPolicies = new ArrayList<BehatPatternPolicy>();

    @NotNull
    public static List<String> getAllPatternsFromStepDefinition(@NotNull Method method) {
        if (method == null) {
            BehatPatternExtractor.$$$reportNull$$$0(0);
        }
        SmartList patterns = new SmartList();
        for (PhpDocTag tag : PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)method.getDocComment(), PhpDocTag.class)) {
            String pattern = BehatPatternExtractor.getPatternFromTag(tag);
            if (!StringUtil.isNotEmpty((String)pattern)) continue;
            patterns.add(pattern);
        }
        BehatPatternExtractor.processBehatStepAttributes((PhpAttributesOwner)method, arg_0 -> BehatPatternExtractor.lambda$getAllPatternsFromStepDefinition$0((List)patterns, arg_0));
        SmartList smartList = patterns;
        if (smartList == null) {
            BehatPatternExtractor.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    public static void processBehatStepAttributes(PhpAttributesOwner attributesOwner, Consumer<PhpAttribute> consumer) {
        for (PhpAttribute attribute : attributesOwner.getAttributes()) {
            String fqn = attribute.getFQN();
            if (fqn == null || !fqn.startsWith("\\Behat\\Step\\") || !JsonGherkinKeywordProvider.getKeywordProvider((PsiElement)attribute).isStepKeyword(attribute.getName())) continue;
            consumer.accept(attribute);
        }
    }

    @Nullable
    private static String getPatternFromTag(@NotNull PhpDocTag tag) {
        String text;
        if (tag == null) {
            BehatPatternExtractor.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(text = BehatPatternExtractor.extractPatternText(tag)))) {
            return null;
        }
        return BehatPatternExtractor.applyPatternPolicy(text);
    }

    @Nullable
    public static String extractPatternText(@NotNull PhpDocTag tag) {
        GherkinKeywordProvider keywordProvider;
        String tagName;
        if (tag == null) {
            BehatPatternExtractor.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(tagName = tag.getName())) && tag.isValid() && BehatPatternTextCustomValueProviderKt.canBeStepKeyword(tag) && (keywordProvider = JsonGherkinKeywordProvider.getKeywordProvider((PsiElement)tag)).isStepKeyword(StringUtil.trimStart((String)tagName, (String)"@"))) {
            String string;
            if (tag instanceof PhpDocTagImpl) {
                PhpDocTagImpl docTag = (PhpDocTagImpl)tag;
                string = docTag.getCustomTagValue();
            } else {
                string = tag.getTagValue();
            }
            return string;
        }
        return null;
    }

    private static String applyPatternPolicy(@NotNull String regex) {
        if (regex == null) {
            BehatPatternExtractor.$$$reportNull$$$0(4);
        }
        for (BehatPatternPolicy processor : myPatternPolicies) {
            if (!processor.isApplicable(regex)) continue;
            return processor.process(regex);
        }
        return regex;
    }

    private static /* synthetic */ void lambda$getAllPatternsFromStepDefinition$0(List patterns, PhpAttribute attribute) {
        PhpExpectedFunctionArgument item = (PhpExpectedFunctionArgument)ContainerUtil.getFirstItem((List)attribute.getArgumentsValues());
        if (item instanceof PhpExpectedFunctionScalarArgument) {
            patterns.add(BehatPatternExtractor.applyPatternPolicy(StringUtil.unquoteString((String)item.getValue())));
        }
    }

    static {
        myPatternPolicies.add(BehatRegexPatternPolicy.INSTANCE);
        myPatternPolicies.add(BehatTurnipPatterPolicy.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/steps/BehatPatternExtractor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/steps/BehatPatternExtractor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatternsFromStepDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllPatternsFromStepDefinition";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPatternFromTag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractPatternText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyPatternPolicy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

