/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.behat.BehatUtil;
import com.jetbrains.php.behat.run.BehatRunConfiguration;
import com.jetbrains.php.behat.run.BehatRunConfigurationType;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

public final class BehatRuntimeConfigurationProducer
extends LazyRunConfigurationProducer<BehatRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        BehatRunConfigurationType behatRunConfigurationType = BehatRunConfigurationType.getInstance();
        if (behatRunConfigurationType == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        return behatRunConfigurationType;
    }

    protected boolean setupConfigurationFromContext(@NotNull BehatRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location location;
        if (configuration == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!((location = context.getLocation()) instanceof PsiLocation)) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        PsiElement element = BehatRuntimeConfigurationProducer.findTestElement(originalElement);
        if (element == null) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return false;
        }
        PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
        PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
        if (element instanceof GherkinFeature) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.File);
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
        } else if (element instanceof PsiDirectory) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Directory);
            testRunnerSettings.setDirectoryPath(virtualFile.getPresentableUrl());
        } else if (element instanceof GherkinStepsHolder) {
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Method);
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
            testRunnerSettings.setMethodName(BehatUtil.getScenarioName((GherkinStepsHolder)element));
        } else {
            return false;
        }
        configuration.setName(configuration.suggestedName());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull BehatRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        Location location;
        if (configuration == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiElement psiElement = BehatRuntimeConfigurationProducer.findTestElement(location.getPsiElement());
        if (psiElement instanceof PsiDirectory) {
            String directoryPath = ((PsiDirectory)psiElement).getVirtualFile().getPath();
            PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
            PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
            String path = testRunnerSettings.getDirectoryPath();
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Directory && path != null && FileUtil.comparePaths((String)directoryPath, (String)FileUtil.toSystemIndependentName((String)path)) == 0;
        }
        if (psiElement instanceof GherkinFeature) {
            PsiFile psiFile2 = psiElement.getContainingFile();
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            if (virtualFile2 != null) {
                String path = virtualFile2.getPath();
                PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
                PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
                String filePath = testRunnerSettings.getFilePath();
                return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.File && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0;
            }
        } else if (psiElement instanceof GherkinStepsHolder && (virtualFile = (psiFile = psiElement.getContainingFile()).getVirtualFile()) != null) {
            String path = virtualFile.getPath();
            PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
            PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
            String filePath = testRunnerSettings.getFilePath();
            String scenarioName = BehatUtil.getScenarioName((GherkinStepsHolder)psiElement);
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Method && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0 && StringUtil.equals((CharSequence)scenarioName, (CharSequence)testRunnerSettings.getMethodName());
        }
        return false;
    }

    @Nullable
    public static PsiElement findTestElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            return BehatRuntimeConfigurationProducer.checkDirectoryContainsGherkinFiles(element.getProject(), ((PsiDirectory)element).getVirtualFile()) ? element : null;
        }
        GherkinStepsHolder stepsHolder = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStepsHolder.class);
        if (stepsHolder != null && BehatUtil.isRunnableStepHolder(stepsHolder)) {
            return stepsHolder;
        }
        GherkinFeature feature = (GherkinFeature)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinFeature.class);
        if (feature != null) {
            return feature;
        }
        PsiFile file = element.getContainingFile();
        if (file != null && file.isValid() && file instanceof GherkinFile) {
            return PsiTreeUtil.getChildOfType((PsiElement)file, GherkinFeature.class);
        }
        return null;
    }

    public static boolean checkDirectoryContainsGherkinFiles(@NotNull Project project, @NotNull VirtualFile directory) {
        Module module;
        if (project == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            BehatRuntimeConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(directory)) != null) {
            GlobalSearchScope scope = module.getModuleContentWithDependenciesScope().intersectWith(GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)directory, (boolean)true));
            return !FileTypeIndex.getFiles((FileType)GherkinFileType.INSTANCE, (GlobalSearchScope)scope).isEmpty();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/run/BehatRuntimeConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/run/BehatRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkDirectoryContainsGherkinFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

