/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.jetbrains.php.framework.data.FrameworkDataServiceBase;
import org.jetbrains.annotations.Nullable;

final class FrameworkProjectDataService
extends FrameworkDataServiceBase {
    private final Project myProject;

    FrameworkProjectDataService(Project project) {
        this.myProject = project;
        this.initialize();
    }

    @Override
    @Nullable
    protected VirtualFile getDescriptionsDir(boolean createIfNotFound) {
        if (this.myProject == null || this.myProject.isDefault()) {
            return null;
        }
        IProjectStore store = ProjectKt.getStateStore((Project)this.myProject);
        Object path = ProjectKt.isDirectoryBased((Project)this.myProject) ? FileUtil.toSystemIndependentName((String)store.getDirectoryStorePath().resolve("commandlinetools").toString()) : String.valueOf(store.getProjectBasePath()) + "/.commandlinetools";
        return FrameworkProjectDataService.getOrCreateChildDir(null, (String)path, createIfNotFound);
    }

    @Override
    protected boolean isProjectLevel() {
        return true;
    }
}

