/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.jetbrains.php.framework.data.FrameworkCommand;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrameworkCurrentInputData {
    private final String userInput;
    private final FrameworkCommand strictMatchingCommand;
    private final List<? extends FrameworkCommand> matchingCommands;

    private FrameworkCurrentInputData(@NotNull String userInput, @Nullable FrameworkCommand strictMatchingCommand, @NotNull List<? extends FrameworkCommand> matchingCommands) {
        if (userInput == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(0);
        }
        if (matchingCommands == null) {
            FrameworkCurrentInputData.$$$reportNull$$$0(1);
        }
        this.userInput = userInput;
        this.strictMatchingCommand = strictMatchingCommand;
        this.matchingCommands = matchingCommands;
    }

    @Nullable
    public FrameworkCommand findCommand(boolean returnStrictMatchIfFound, boolean userTextMustContainCommand) {
        if (returnStrictMatchIfFound && this.strictMatchingCommand != null) {
            return this.strictMatchingCommand;
        }
        if (this.matchingCommands.size() != 1 || userTextMustContainCommand && !this.userInput.startsWith(this.matchingCommands.get(0).getAliasedBasicText().trim())) {
            return null;
        }
        return this.matchingCommands.get(0);
    }

    @NotNull
    public static FrameworkCurrentInputData countInputData(String userText, List<? extends FrameworkCommand> commands) {
        ArrayList<FrameworkCommand> matchingCommands = new ArrayList<FrameworkCommand>();
        FrameworkCommand strictMatchingCommand = null;
        for (FrameworkCommand frameworkCommand : commands) {
            if (!frameworkCommand.isEnabled()) continue;
            String aliasedText = frameworkCommand.getAliasedBasicText().trim();
            if (userText.equals(aliasedText) || userText.startsWith(aliasedText + " ")) {
                if (strictMatchingCommand == null || strictMatchingCommand.getAliasedBasicText().length() < frameworkCommand.getAliasedBasicText().length()) {
                    strictMatchingCommand = frameworkCommand;
                }
                matchingCommands.add(frameworkCommand);
                continue;
            }
            if (!aliasedText.startsWith(userText)) continue;
            matchingCommands.add(frameworkCommand);
        }
        return new FrameworkCurrentInputData(userText, strictMatchingCommand, matchingCommands);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "userInput";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "matchingCommands";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/framework/FrameworkCurrentInputData";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

