/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.psalm;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.psalm.PsalmConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmGlobalInspection;
import com.jetbrains.php.tools.quality.psalm.PsalmMessageProcessor;
import com.jetbrains.php.tools.quality.psalm.PsalmQualityToolType;
import com.jetbrains.php.tools.quality.psalm.PsalmValidationInspection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmAnnotatorProxy
extends QualityToolAnnotator<PsalmValidationInspection> {
    private static final Logger LOG = Logger.getInstance(PsalmAnnotatorProxy.class);
    public static final PsalmAnnotatorProxy INSTANCE = new PsalmAnnotatorProxy();

    @Nullable
    protected List<String> getOptions(@Nullable String filePath, @NotNull PsalmValidationInspection inspection, @Nullable InspectionProfile profile, @NotNull Project project) {
        PsalmGlobalInspection tool;
        if (inspection == null) {
            PsalmAnnotatorProxy.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PsalmAnnotatorProxy.$$$reportNull$$$0(1);
        }
        if ((tool = (PsalmGlobalInspection)this.getQualityToolType().getGlobalTool(project, profile)) == null) {
            return ContainerUtil.emptyList();
        }
        return tool.getCommandLineOptions(filePath, project);
    }

    protected void checkOptions(@NotNull List<String> options, @NotNull String workingDir, @NotNull Project project) {
        if (options == null) {
            PsalmAnnotatorProxy.$$$reportNull$$$0(2);
        }
        if (workingDir == null) {
            PsalmAnnotatorProxy.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PsalmAnnotatorProxy.$$$reportNull$$$0(4);
        }
        Path path = Paths.get(workingDir, "psalm.xml");
        if (!options.contains("-c") && !Files.exists(path, new LinkOption[0])) {
            PsalmGlobalInspection.notifyAboutMissingConfig(project, path.toString());
        } else {
            path = Paths.get(options.get(options.indexOf("-c") + 1), new String[0]);
            path = Path.of(PsalmAnnotatorProxy.updateToLocalIfRemote((String)path.toString(), (Project)project, (QualityToolType)PsalmQualityToolType.INSTANCE), new String[0]);
            if (options.contains("-c") && !Files.exists(path, new LinkOption[0]) && FileUtil.isAncestor((String)project.getBasePath(), (String)path.toString(), (boolean)false)) {
                PsalmGlobalInspection.notifyAboutMissingConfig(project, path.toString());
            }
        }
    }

    protected List<AnAction> getAdditionalTimeoutActions() {
        return Collections.singletonList(new AnAction(PhpBundle.message((String)"init.cache", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null && !project.isDisposed()) {
                    PsalmValidationInspection inspection = new PsalmValidationInspection();
                    QualityToolConfiguration configuration = PsalmAnnotatorProxy.this.getConfiguration(project, (LocalInspectionTool)inspection);
                    try {
                        if (configuration != null) {
                            QualityToolProcessCreator.getToolOutput((Project)project, (String)configuration.getInterpreterId(), (String)configuration.getToolPath(), (int)configuration.getTimeout(), (String)PhpBundle.message((String)"cache.creating", (Object[])new Object[0]), null, (String[])ArrayUtil.toStringArray(PsalmAnnotatorProxy.this.getOptions((String)null, inspection, (InspectionProfile)null, project)));
                        }
                    }
                    catch (ExecutionException exception) {
                        LOG.warn("PhpStorm couldn't create psalm cache");
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/psalm/PsalmAnnotatorProxy$1", "actionPerformed"));
            }
        });
    }

    public String getPairedBatchInspectionShortName() {
        return this.getQualityToolType().getInspectionId();
    }

    protected QualityToolMessageProcessor createMessageProcessor(@NotNull QualityToolAnnotatorInfo<PsalmValidationInspection> collectedInfo) {
        if (collectedInfo == null) {
            PsalmAnnotatorProxy.$$$reportNull$$$0(5);
        }
        return new PsalmMessageProcessor(collectedInfo);
    }

    @NotNull
    protected QualityToolType<PsalmConfiguration> getQualityToolType() {
        PsalmQualityToolType psalmQualityToolType = PsalmQualityToolType.INSTANCE;
        if (psalmQualityToolType == null) {
            PsalmAnnotatorProxy.$$$reportNull$$$0(6);
        }
        return psalmQualityToolType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/psalm/PsalmAnnotatorProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/psalm/PsalmAnnotatorProxy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualityToolType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkOptions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMessageProcessor";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

