/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.paths;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.lang.psi.elements.impl.PhpFileReferenceSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPGetTemplateFunctionFileReferenceSet
extends PhpFileReferenceSet {
    private final String mySecondParameterAsText;
    private final String myFirstParameterAsText;
    private final boolean myClickOnFirstParam;

    public WPGetTemplateFunctionFileReferenceSet(FunctionReference functionReference, PhpPsiElement parameter) {
        super((PsiElement)parameter, parameter, null);
        this.myClickOnFirstParam = parameter == functionReference.getParameter(0);
        this.myFirstParameterAsText = PhpFilePathUtils.getStaticPath((PhpPsiElement)((PhpPsiElement)functionReference.getParameter(0)));
        this.mySecondParameterAsText = PhpFilePathUtils.getStaticPath((PhpPsiElement)((PhpPsiElement)functionReference.getParameter(1)));
        this.reparse();
    }

    @Nullable
    public PhpFileReferenceSet.PhpFileReference createFileReference(TextRange range, int index, String text) {
        if (this.myClickOnFirstParam && this.isLastPartOfFilePath((String)text) && !StringUtil.isEmpty((String)this.mySecondParameterAsText)) {
            text = (String)text + "-" + this.mySecondParameterAsText;
        } else if (((String)text).equals(this.mySecondParameterAsText)) {
            text = this.myFirstParameterAsText + "-" + this.mySecondParameterAsText;
        }
        return new WPTemplateFileReference(range, index, (String)text, this);
    }

    private boolean isLastPartOfFilePath(String text) {
        return this.myFirstParameterAsText.endsWith(text);
    }

    private class WPTemplateFileReference
    extends PhpFileReferenceSet.PhpFileReference {
        WPTemplateFileReference(TextRange range, int index, String text, PhpFileReferenceSet set) {
            super((PhpFileReferenceSet)WPGetTemplateFunctionFileReferenceSet.this, set, range, index, text);
        }

        protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<? super ResolveResult> result, boolean caseSensitive) {
            if (text == null) {
                WPTemplateFileReference.$$$reportNull$$$0(0);
            }
            if (context == null) {
                WPTemplateFileReference.$$$reportNull$$$0(1);
            }
            if (result == null) {
                WPTemplateFileReference.$$$reportNull$$$0(2);
            }
            int oldSize = result.size();
            if (!WPGetTemplateFunctionFileReferenceSet.this.isLastPartOfFilePath(text)) {
                super.innerResolveInContext(text, context, result, caseSensitive);
            }
            if (result.size() != oldSize || !this.isLast()) {
                return;
            }
            super.innerResolveInContext(text + "." + PhpFileType.INSTANCE.getDefaultExtension(), context, result, caseSensitive);
            if (result.size() != oldSize) {
                return;
            }
            String part = WPTemplateFileReference.getFilePathWithoutSpecializedPart(text);
            if (StringUtil.isEmpty((String)part)) {
                return;
            }
            super.innerResolveInContext(part + "." + PhpFileType.INSTANCE.getDefaultExtension(), context, result, caseSensitive);
        }

        @Nullable
        private static String getFilePathWithoutSpecializedPart(String filePath) {
            int lastDash = StringUtil.lastIndexOf((CharSequence)filePath, (char)'-', (int)0, (int)filePath.length());
            if (lastDash < 0) {
                return null;
            }
            return filePath.substring(0, lastDash);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/wordpress/paths/WPGetTemplateFunctionFileReferenceSet$WPTemplateFileReference";
            objectArray[2] = "innerResolveInContext";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

