/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.wordpress.hooks.WPHook;
import com.jetbrains.php.wordpress.hooks.WPHookName;
import com.jetbrains.php.wordpress.hooks.WPHookNamePart;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import com.jetbrains.php.wordpress.hooks.WPHookUtils;
import com.jetbrains.php.wordpress.hooks.WPHooksIndex;
import icons.WordPressIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPHooksSymbolContributor
implements ChooseByNameContributorEx {
    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(1);
        }
        Processor hookProcessor = Processors.map(processor, o -> WPHooksSymbolContributor.hookToString(o.getName()));
        FileBasedIndex.getInstance().processAllKeys(WPHooksIndex.KEY, hookProcessor, scope, filter);
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(4);
        }
        WPHookName hookName = WPHooksSymbolContributor.stringToHook(name);
        WPHook actionKey = new WPHook(hookName, WPHookType.ACTION);
        WPHook filterKey = new WPHook(hookName, WPHookType.FILTER);
        PsiManager psiManager = PsiManager.getInstance((Project)parameters.getProject());
        VirtualFileSet visited = VfsUtilCore.createCompactVirtualFileSet();
        Processor fileProcessor = arg_0 -> WPHooksSymbolContributor.lambda$processElementsWithName$2((Set)visited, psiManager, name, processor, arg_0);
        FileBasedIndex index = FileBasedIndex.getInstance();
        GlobalSearchScope scope = parameters.getSearchScope();
        if (!index.getFilesWithKey(WPHooksIndex.KEY, Set.of(actionKey), fileProcessor, scope)) {
            return;
        }
        if (!index.getFilesWithKey(WPHooksIndex.KEY, Set.of(filterKey), fileProcessor, scope)) {
            return;
        }
    }

    private static String hookToString(@NotNull WPHookName name) {
        String pureStringText;
        if (name == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(5);
        }
        if ((pureStringText = name.getPureStringText()) != null) {
            return pureStringText;
        }
        StringBuilder sb = new StringBuilder();
        for (WPHookNamePart part : name.getParts()) {
            if (part.isStringValue()) {
                sb.append(part.getText());
                continue;
            }
            sb.append('{').append(part.getText()).append('}');
        }
        return sb.toString();
    }

    private static WPHookName stringToHook(@NotNull String presentation) {
        int beginningIndex;
        if (presentation == null) {
            WPHooksSymbolContributor.$$$reportNull$$$0(6);
        }
        if ((beginningIndex = presentation.indexOf(123)) == -1) {
            return new WPHookName(Collections.singletonList(new WPHookNamePart(presentation, true)));
        }
        ArrayList<WPHookNamePart> parts = new ArrayList<WPHookNamePart>();
        if (beginningIndex > 0) {
            parts.add(new WPHookNamePart(presentation.substring(0, beginningIndex), true));
        }
        int level = 1;
        for (int i = beginningIndex + 1; i < presentation.length(); ++i) {
            char c = presentation.charAt(i);
            if (c == '{') {
                if (++level != 1) continue;
                parts.add(new WPHookNamePart(presentation.substring(beginningIndex + 1, i), true));
                beginningIndex = i;
                continue;
            }
            if (c != '}' || --level != 0) continue;
            parts.add(new WPHookNamePart(presentation.substring(beginningIndex + 1, i), false));
            beginningIndex = i;
        }
        if (beginningIndex + 1 != presentation.length()) {
            parts.add(new WPHookNamePart(presentation.substring(beginningIndex + 1), level == 0));
        }
        return new WPHookName(parts);
    }

    private static /* synthetic */ boolean lambda$processElementsWithName$2(Set visited, PsiManager psiManager, String name, Processor processor, VirtualFile file) {
        if (!visited.add(file)) {
            return true;
        }
        PsiFile psiFile = psiManager.findFile(file);
        return SyntaxTraverser.psiTraverser((PsiElement)psiFile).filter(FunctionReference.class).processEach(reference -> {
            String functionName = reference.getName();
            WPHookType type = WPHookType.findByInvocationMethod(functionName);
            if (type == null) {
                return true;
            }
            WPHookName hn = WPHookUtils.getHookNameFromInvocation(reference, false);
            return hn == null || !name.equals(WPHooksSymbolContributor.hookToString(hn)) || processor.process((Object)new WPHookNavigatable(name, (FunctionReference)reference));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHooksSymbolContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hookToString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "stringToHook";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WPHookNavigatable
    implements PsiElementNavigationItem {
        private final FunctionReference myInvocation;
        private final String myName;

        private WPHookNavigatable(@NotNull String name, @NotNull FunctionReference invocation) {
            if (name == null) {
                WPHookNavigatable.$$$reportNull$$$0(0);
            }
            if (invocation == null) {
                WPHookNavigatable.$$$reportNull$$$0(1);
            }
            this.myInvocation = invocation;
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                WPHookNavigatable.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @NotNull
                public String getPresentableText() {
                    String string = myName;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Nullable
                public String getLocationString() {
                    PsiFile containingFile = myInvocation.getContainingFile();
                    return containingFile != null ? containingFile.getName() : null;
                }

                @NotNull
                public Icon getIcon(boolean unused) {
                    Icon icon = WordPressIcons.HookElement;
                    if (icon == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return icon;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/jetbrains/php/wordpress/hooks/WPHooksSymbolContributor$WPHookNavigatable$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIcon";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        public void navigate(boolean requestFocus) {
            this.myInvocation.navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.myInvocation.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.myInvocation.canNavigateToSource();
        }

        @NotNull
        public PsiElement getTargetElement() {
            FunctionReference functionReference = this.myInvocation;
            if (functionReference == null) {
                WPHookNavigatable.$$$reportNull$$$0(3);
            }
            return functionReference;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WPHookNavigatable that = (WPHookNavigatable)o;
            if (!this.myInvocation.equals((Object)that.myInvocation)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myInvocation.hashCode();
            result = 31 * result + this.myName.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocation";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHooksSymbolContributor$WPHookNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHooksSymbolContributor$WPHookNavigatable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

