/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WPHookFunctionReference
extends PsiReferenceBase<PsiElement> {
    private final PsiElement myOriginalElement;

    private WPHookFunctionReference(PsiElement element, @Nullable PsiElement originalElement) {
        super(element, false);
        this.myOriginalElement = originalElement;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myOriginalElement;
    }

    static WPHookFunctionReference[] getFunctionReferences(Collection<? extends Function> functions, StringLiteralExpression literal) {
        if (functions.isEmpty()) {
            return new WPHookFunctionReference[]{new FunctionHookFunctionReference(literal, null)};
        }
        com.intellij.util.Function functionReferenceCreator = function -> new FunctionHookFunctionReference(literal, (Function)function);
        return (WPHookFunctionReference[])ContainerUtil.map2Array(functions, WPHookFunctionReference.class, (com.intellij.util.Function)functionReferenceCreator);
    }

    static WPHookFunctionReference[] getClassReferences(Collection<? extends PhpClass> classes, StringLiteralExpression literal) {
        if (classes.isEmpty()) {
            return new WPHookFunctionReference[]{new ClassHookFunctionReference(literal, null)};
        }
        com.intellij.util.Function classReferenceCreator = function -> new ClassHookFunctionReference(literal, (PhpClass)function);
        return (WPHookFunctionReference[])ContainerUtil.map2Array(classes, WPHookFunctionReference.class, (com.intellij.util.Function)classReferenceCreator);
    }

    static WPHookFunctionReference createReference(@NotNull StringLiteralExpression element, @Nullable Method originalElement, @NotNull PhpClass phpClass, boolean isStatic) {
        if (element == null) {
            WPHookFunctionReference.$$$reportNull$$$0(0);
        }
        if (phpClass == null) {
            WPHookFunctionReference.$$$reportNull$$$0(1);
        }
        return new MethodHookFunctionReference(element, originalElement, phpClass, isStatic);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "phpClass";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference";
        objectArray[2] = "createReference";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FunctionHookFunctionReference
    extends WPHookFunctionReference {
        private FunctionHookFunctionReference(@NotNull StringLiteralExpression element, @Nullable Function originalElement) {
            if (element == null) {
                FunctionHookFunctionReference.$$$reportNull$$$0(0);
            }
            super((PsiElement)element, (PsiElement)originalElement);
        }

        public Object @NotNull [] getVariants() {
            ArrayList<HookActionLookupElement> variants = new ArrayList<HookActionLookupElement>();
            PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getElement().getProject());
            for (String functionName : phpIndex.getAllFunctionNames(null)) {
                for (Function function : phpIndex.getFunctionsByName(functionName)) {
                    variants.add(new HookActionLookupElement(function));
                }
            }
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                FunctionHookFunctionReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$FunctionHookFunctionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$FunctionHookFunctionReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ClassHookFunctionReference
    extends WPHookFunctionReference {
        private ClassHookFunctionReference(@NotNull StringLiteralExpression element, @Nullable PhpClass originalElement) {
            if (element == null) {
                ClassHookFunctionReference.$$$reportNull$$$0(0);
            }
            super((PsiElement)element, (PsiElement)originalElement);
        }

        public Object @NotNull [] getVariants() {
            HashSet variants = new HashSet(PhpCompletionUtil.getAllClasses(null, (PhpIndex)PhpIndex.getInstance((Project)this.getElement().getProject())));
            ArrayList<HookActionLookupElement> elements = new ArrayList<HookActionLookupElement>();
            for (PhpClass phpClass : variants) {
                elements.add(new HookActionLookupElement(phpClass));
            }
            Object[] objectArray = elements.toArray();
            if (objectArray == null) {
                ClassHookFunctionReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$ClassHookFunctionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$ClassHookFunctionReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MethodHookFunctionReference
    extends WPHookFunctionReference {
        private final PhpClass myClass;
        private final boolean myIsStatic;

        private MethodHookFunctionReference(@NotNull StringLiteralExpression element, @Nullable Method originalElement, @NotNull PhpClass phpClass, boolean isStatic) {
            if (element == null) {
                MethodHookFunctionReference.$$$reportNull$$$0(0);
            }
            if (phpClass == null) {
                MethodHookFunctionReference.$$$reportNull$$$0(1);
            }
            super((PsiElement)element, (PsiElement)originalElement);
            this.myClass = phpClass;
            this.myIsStatic = isStatic;
        }

        public Object @NotNull [] getVariants() {
            ArrayList<HookActionLookupElement> variants = new ArrayList<HookActionLookupElement>();
            for (Method method : this.myClass.getMethods()) {
                if (this.myIsStatic && !method.isStatic()) continue;
                variants.add(new HookActionLookupElement(method));
            }
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                MethodHookFunctionReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$MethodHookFunctionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$MethodHookFunctionReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class HookActionLookupElement
    extends PhpLookupElement {
        private HookActionLookupElement(Function function) {
            this((PhpNamedElement)function, HookActionLookupElement.getLookupString((PhpNamedElement)function));
        }

        private HookActionLookupElement(Method method) {
            this((PhpNamedElement)method, method.getName());
        }

        private HookActionLookupElement(PhpClass phpClass) {
            this((PhpNamedElement)phpClass, HookActionLookupElement.getLookupString((PhpNamedElement)phpClass));
        }

        private static String getLookupString(PhpNamedElement namedElement) {
            String namespace = namedElement.getNamespaceName();
            if ("".equals(namespace)) {
                return namedElement.getName();
            }
            return namedElement.getNamespaceName().substring(1) + namedElement.getName();
        }

        private HookActionLookupElement(PhpNamedElement element, String lookupString) {
            super(element);
            this.lookupString = lookupString;
        }

        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                HookActionLookupElement.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public Set<String> getAllLookupStrings() {
            HashSet<String> lookupStrings = super.getAllLookupStrings();
            if (this.lookupString.contains("\\")) {
                String doubleSeparator = StringUtil.replace((String)this.lookupString, (String)"\\", (String)"\\\\");
                lookupStrings = new HashSet<String>(lookupStrings);
                lookupStrings.add(doubleSeparator);
            }
            HashSet<String> hashSet = lookupStrings;
            if (hashSet == null) {
                HookActionLookupElement.$$$reportNull$$$0(1);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$HookActionLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookFunctionReference$HookActionLookupElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLookupStrings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

