/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.clt;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.framework.ui.FrameworkCompositePathDialog;
import com.jetbrains.php.wordpress.WPBundle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

final class WPCliPathDialog
extends FrameworkCompositePathDialog {
    @NonNls
    private static final String WP_CLI_EXECUTABLE_NAME = SystemInfo.isWindows ? "wp.bat" : "wp";

    private WPCliPathDialog(FrameworkCompositePathDialog.TextsBuilder textsBuilder) {
        super(textsBuilder, false);
    }

    private WPCliPathDialog(Project project, FrameworkCompositePathDialog.TextsBuilder builder) {
        super(project, builder, false);
    }

    static WPCliPathDialog getInstance(@Nullable Project project) {
        FrameworkCompositePathDialog.TextsBuilder textsBuilder = new FrameworkCompositePathDialog.TextsBuilder(){
            {
                this.myTitle = WPBundle.message("wp.cli.title", new Object[0]);
                this.myScriptRadioButtonText = WPBundle.message("wp.cli.path.dlg.script.radio.button.installed.via.phar", new Object[0]);
                this.myScriptPathLabelText = WPBundle.message("wp.cli.path.dlg.script.descriptor.title.path.to.phar", new Object[0]);
                this.myExecutableRadioButtonText = WPBundle.message("wp.cli.path.dlg.radio.button.executable.available.installed.via.composer.etc", new Object[0]);
                this.myExecutablePathLabelText = WPBundle.message("wp.cli.path.dlg.executable.path.path.to.0.colon", WP_CLI_EXECUTABLE_NAME);
                this.myScriptFileDescriptorTitle = WPBundle.message("wp.cli.path.dlg.script.descriptor.title.path.to.phar", new Object[0]);
                this.myScriptFileDescriptorDescription = WPBundle.message("wp.cli.path.dlg.script.descriptor.description.specify.path.to.phar", new Object[0]);
                this.myExecutableFileDescriptorTitle = WPBundle.message("wp.cli.path.dlg.executable.descriptor.title.path.to.0", WP_CLI_EXECUTABLE_NAME);
                this.myExecutableFileDescriptorDescription = WPBundle.message("wp.cli.path.dlg.executable.descriptor.description.specify.wp.cli.executable.0", WP_CLI_EXECUTABLE_NAME);
            }
        };
        return project == null ? new WPCliPathDialog(textsBuilder) : new WPCliPathDialog(project, textsBuilder);
    }

    @Nullable
    protected ValidationInfo createExecutableValidationInfo(TextFieldWithBrowseButton executablePathField) {
        return WPCliPathDialog.createStandardValidationInfo((JComponent)executablePathField, (String)this.getExecutablePath(), (String)WP_CLI_EXECUTABLE_NAME, (String)WPBundle.message("wp.cli.wp.cli.executable", new Object[0]), (Project)this.myProject);
    }

    @Nullable
    protected ValidationInfo createScriptValidationInfo(TextFieldWithBrowseButton phpCodePathField) {
        return WPCliPathDialog.createValidationInfo((JComponent)phpCodePathField, (String)this.getScriptPath(), (String)WPBundle.message("wp.cli.path.to.phar.file.is.not.provided", new Object[0]), (String)WPBundle.message("wp.cli.phar.file.is.not.chosen", new Object[0]));
    }

    @Nullable
    protected String getInitialExecutablePath() {
        VirtualFile file = ComposerUtils.findFileInProject((Project)this.myProject, (String)WP_CLI_EXECUTABLE_NAME);
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    @Nullable
    protected String getInitialScriptPath() {
        VirtualFile file = ComposerUtils.findFileInProject((Project)this.myProject, (String)"wp-cli.phar");
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    @Nullable
    protected String getScriptPath(String input) {
        String pharPath = WPCliPathDialog.getPath((String)input, null);
        if (StringUtil.isEmpty((String)pharPath)) {
            return pharPath;
        }
        if (pharPath.endsWith(".phar")) {
            return pharPath;
        }
        return null;
    }

    @Nullable
    protected String getExecutablePath(String input) {
        return WPCliPathDialog.getPath((String)input, (String)WP_CLI_EXECUTABLE_NAME);
    }

    protected String getDimensionServiceKey() {
        return "WPCliPathDialog";
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return null;
    }
}

