/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class WPVariableTypeProvider
implements PhpTypeProvider3 {
    @NonNls
    static final Map<CharSequence, String> knownVars = new HashMap<CharSequence, String>();

    public char getKey() {
        return '\u0432';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        PsiElement parent;
        if (!(element instanceof Variable)) {
            return null;
        }
        Variable var = (Variable)element;
        Project project = element.getProject();
        if (!WPDataService.getInstance(project).isEnabled()) {
            return null;
        }
        final String varName = var.getName();
        String varType = knownVars.get(varName);
        if (varType == null) {
            return null;
        }
        if (var.isDeclaration() && (parent = var.getParent()) instanceof Global && ArrayUtilRt.find((Object[])((Global)parent).getVariables(), (Object)var) > -1) {
            return new PhpType().add(varType);
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)var);
        if (scopeHolder == null || scopeHolder instanceof Function) {
            return null;
        }
        PhpControlFlow controlFlow = scopeHolder.getControlFlow();
        PhpInstruction[] instructions = controlFlow.getInstructions();
        int i = PhpControlFlowUtil.processFlow((PhpControlFlow)controlFlow, (PhpInstructionProcessor)new PhpInstructionProcessor(this){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                return !StringUtil.equals((CharSequence)varName, (CharSequence)instruction.getVariableName());
            }
        });
        if (i == 0 || i == instructions.length) {
            if (scopeHolder instanceof PhpExpressionCodeFragment && i == 0) {
                return new PhpType().add(varType);
            }
            return null;
        }
        PhpAccessVariableInstruction instruction = (PhpAccessVariableInstruction)instructions[i];
        if (instruction.getAnchor() == var && instruction.getAccess() != PhpAccessInstruction.Access.WRITE_ACCESS) {
            return new PhpType().add(varType);
        }
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    static {
        knownVars.put("current_user", "\\WP_User");
        knownVars.put("post", "\\WP_Post");
        knownVars.put("wp", "\\WP");
        knownVars.put("wp_embed", "\\WP_Embed");
        knownVars.put("wp_locale", "\\WP_Locale");
        knownVars.put("wp_object_cache", "\\WP_Object_Cache");
        knownVars.put("wp_query", "\\WP_Query");
        knownVars.put("wp_rewrite", "\\WP_Rewrite");
        knownVars.put("wp_roles", "\\WP_Roles");
        knownVars.put("wp_the_query", "\\WP_Query");
        knownVars.put("wp_widget_factory", "\\WP_Widget_Factory");
        knownVars.put("wpdb", "\\wpdb");
    }
}

