/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 19388573269156L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1090895610 - -1229, -1090895610 - -6497, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1090895610 - -1228, -1090895610 - -11104, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 109490814242265L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.i();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(787075350 - (char)-25494, -787075350 - -((char)-16139), (int)l2) + string + WindowsNamedPipeAgentIpc.b(787075350 - (char)-25495, 787075350 - 22449, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(787075350 - (char)-25492, -787075350 - -((char)-32613), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 82016874256986L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.i();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-178779480 - -6272, -178779480 - -12144, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-178779480 - -6275, 178779480 - 28203, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-178779480 - -6274, 178779480 - 4204, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-178779480 - -6269, 178779480 - 10398, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-178779480 - -6268, 178779480 - 2279, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-178779480 - -6271, 178779480 - 15427, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-178779480 - -6269, 178779480 - 10398, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-178779480 - -6270, 178779480 - 13218, (int)l2));
            if (ActionTimestamp.i() == null) {
                SshAgentIpcService.i(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 58109113333376L;
                    actionTimestampArray = SshAgentIpcService.i();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 130737932938975L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                actionTimestampArray = SshAgentIpcService.i();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(871615500 - (char)-2968, 871484430 + (char)-2882, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(871615500 - (char)-2964, -871484430 + -((char)-1101), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(871615500 - (char)-2969, -871615500 - -((char)-3557), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(871615500 - (char)-2964, -871484430 + -((char)-1101), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(871615500 - (char)-2970, 871615500 - (char)-10258, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(871615500 - (char)-2968, 871484430 + (char)-2882, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(871615500 - (char)-2964, -871484430 + -((char)-1101), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(871615500 - (char)-2971, -871484430 + -((char)-9974), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(871615500 - (char)-2968, 871484430 + (char)-2882, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(871615500 - (char)-2964, -871484430 + -((char)-1101), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(871615500 - (char)-2988, 871615500 - (char)-12481, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(871615500 - (char)-2964, -871484430 + -((char)-1101), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(871615500 - (char)-2989, 871615500 - (char)-6168, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(871615500 - (char)-2964, -871484430 + -((char)-1101), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(871615500 - (char)-2970, 871615500 - (char)-10258, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(871615500 - (char)-2968, 871484430 + (char)-2882, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(871615500 - (char)-2964, -871484430 + -((char)-1101), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(871615500 - (char)-2990, 871484430 + (char)-13779, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 47467585250404L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(393341070 - (char)-22564, -393341070 - -((char)-28220), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 83468431784182L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-37354950 - -6631, -37354950 - -17011, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "r\u00e8\u0000\u0089-\u001c\u00f5\u00e3sh1HF+\u00c7\u00cea\b4\u0014\u009a>\u001dU\u0095E\u009fM\u00bc\u00bb\r\u00e6\u0003\u0007\u00ae\u00c0\u00a1\u000f+\u001e";
                        var4_3 = "r\u00e8\u0000\u0089-\u001c\u00f5\u00e3sh1HF+\u00c7\u00cea\b4\u0014\u009a>\u001dU\u0095E\u009fM\u00bc\u00bb\r\u00e6\u0003\u0007\u00ae\u00c0\u00a1\u000f+\u001e".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 59;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 22;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 90;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 4;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 3;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 6;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 1;
                                        break;
                                    }
                                    default: {
                                        v11 = 26;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFE4D6) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 244;
                            case 1 -> 156;
                            case 2 -> 238;
                            case 3 -> 36;
                            case 4 -> 205;
                            case 5 -> 247;
                            case 6 -> 115;
                            case 7 -> 241;
                            case 8 -> 73;
                            case 9 -> 248;
                            case 10 -> 39;
                            case 11 -> 199;
                            case 12 -> 152;
                            case 13 -> 37;
                            case 14 -> 228;
                            case 15 -> 236;
                            case 16 -> 220;
                            case 17 -> 213;
                            case 18 -> 94;
                            case 19 -> 218;
                            case 20 -> 154;
                            case 21 -> 183;
                            case 22 -> 62;
                            case 23 -> 126;
                            case 24 -> 98;
                            case 25 -> 173;
                            case 26 -> 121;
                            case 27 -> 123;
                            case 28 -> 92;
                            case 29 -> 113;
                            case 30 -> 14;
                            case 31 -> 50;
                            case 32 -> 109;
                            case 33 -> 20;
                            case 34 -> 186;
                            case 35 -> 134;
                            case 36 -> 239;
                            case 37 -> 139;
                            case 38 -> 144;
                            case 39 -> 226;
                            case 40 -> 209;
                            case 41 -> 184;
                            case 42 -> 68;
                            case 43 -> 17;
                            case 44 -> 59;
                            case 45 -> 237;
                            case 46 -> 69;
                            case 47 -> 185;
                            case 48 -> 106;
                            case 49 -> 216;
                            case 50 -> 254;
                            case 51 -> 125;
                            case 52 -> 66;
                            case 53 -> 179;
                            case 54 -> 224;
                            case 55 -> 7;
                            case 56 -> 90;
                            case 57 -> 31;
                            case 58 -> 48;
                            case 59 -> 146;
                            case 60 -> 140;
                            case 61 -> 8;
                            case 62 -> 74;
                            case 63 -> 26;
                            case 64 -> 93;
                            case 65 -> 158;
                            case 66 -> 219;
                            case 67 -> 18;
                            case 68 -> 124;
                            case 69 -> 169;
                            case 70 -> 167;
                            case 71 -> 172;
                            case 72 -> 3;
                            case 73 -> 44;
                            case 74 -> 41;
                            case 75 -> 87;
                            case 76 -> 42;
                            case 77 -> 102;
                            case 78 -> 240;
                            case 79 -> 43;
                            case 80 -> 95;
                            case 81 -> 232;
                            case 82 -> 197;
                            case 83 -> 76;
                            case 84 -> 112;
                            case 85 -> 207;
                            case 86 -> 243;
                            case 87 -> 24;
                            case 88 -> 16;
                            case 89 -> 150;
                            case 90 -> 58;
                            case 91 -> 202;
                            case 92 -> 133;
                            case 93 -> 127;
                            case 94 -> 132;
                            case 95 -> 33;
                            case 96 -> 47;
                            case 97 -> 46;
                            case 98 -> 28;
                            case 99 -> 80;
                            case 100 -> 225;
                            case 101 -> 118;
                            case 102 -> 61;
                            case 103 -> 214;
                            case 104 -> 45;
                            case 105 -> 168;
                            case 106 -> 210;
                            case 107 -> 235;
                            case 108 -> 230;
                            case 109 -> 6;
                            case 110 -> 162;
                            case 111 -> 101;
                            case 112 -> 105;
                            case 113 -> 221;
                            case 114 -> 79;
                            case 115 -> 188;
                            case 116 -> 137;
                            case 117 -> 104;
                            case 118 -> 250;
                            case 119 -> 157;
                            case 120 -> 180;
                            case 121 -> 83;
                            case 122 -> 151;
                            case 123 -> 107;
                            case 124 -> 22;
                            case 125 -> 148;
                            case 126 -> 175;
                            case 127 -> 164;
                            case 128 -> 85;
                            case 129 -> 81;
                            case 130 -> 191;
                            case 131 -> 5;
                            case 132 -> 249;
                            case 133 -> 215;
                            case 134 -> 100;
                            case 135 -> 84;
                            case 136 -> 246;
                            case 137 -> 170;
                            case 138 -> 190;
                            case 139 -> 252;
                            case 140 -> 55;
                            case 141 -> 242;
                            case 142 -> 189;
                            case 143 -> 111;
                            case 144 -> 163;
                            case 145 -> 15;
                            case 146 -> 4;
                            case 147 -> 13;
                            case 148 -> 245;
                            case 149 -> 198;
                            case 150 -> 116;
                            case 151 -> 29;
                            case 152 -> 193;
                            case 153 -> 200;
                            case 154 -> 174;
                            case 155 -> 229;
                            case 156 -> 122;
                            case 157 -> 222;
                            case 158 -> 233;
                            case 159 -> 25;
                            case 160 -> 128;
                            case 161 -> 91;
                            case 162 -> 176;
                            case 163 -> 217;
                            case 164 -> 82;
                            case 165 -> 0;
                            case 166 -> 2;
                            case 167 -> 251;
                            case 168 -> 88;
                            case 169 -> 64;
                            case 170 -> 227;
                            case 171 -> 155;
                            case 172 -> 63;
                            case 173 -> 231;
                            case 174 -> 117;
                            case 175 -> 119;
                            case 176 -> 161;
                            case 177 -> 131;
                            case 178 -> 96;
                            case 179 -> 30;
                            case 180 -> 178;
                            case 181 -> 56;
                            case 182 -> 38;
                            case 183 -> 130;
                            case 184 -> 253;
                            case 185 -> 51;
                            case 186 -> 65;
                            case 187 -> 147;
                            case 188 -> 192;
                            case 189 -> 27;
                            case 190 -> 136;
                            case 191 -> 75;
                            case 192 -> 208;
                            case 193 -> 255;
                            case 194 -> 52;
                            case 195 -> 72;
                            case 196 -> 11;
                            case 197 -> 145;
                            case 198 -> 40;
                            case 199 -> 23;
                            case 200 -> 153;
                            case 201 -> 196;
                            case 202 -> 223;
                            case 203 -> 67;
                            case 204 -> 129;
                            case 205 -> 195;
                            case 206 -> 78;
                            case 207 -> 166;
                            case 208 -> 165;
                            case 209 -> 34;
                            case 210 -> 70;
                            case 211 -> 60;
                            case 212 -> 212;
                            case 213 -> 160;
                            case 214 -> 108;
                            case 215 -> 89;
                            case 216 -> 114;
                            case 217 -> 142;
                            case 218 -> 143;
                            case 219 -> 21;
                            case 220 -> 54;
                            case 221 -> 53;
                            case 222 -> 9;
                            case 223 -> 187;
                            case 224 -> 149;
                            case 225 -> 99;
                            case 226 -> 103;
                            case 227 -> 206;
                            case 228 -> 32;
                            case 229 -> 19;
                            case 230 -> 110;
                            case 231 -> 177;
                            case 232 -> 10;
                            case 233 -> 97;
                            case 234 -> 35;
                            case 235 -> 86;
                            case 236 -> 1;
                            case 237 -> 194;
                            case 238 -> 204;
                            case 239 -> 203;
                            case 240 -> 57;
                            case 241 -> 77;
                            case 242 -> 120;
                            case 243 -> 12;
                            case 244 -> 159;
                            case 245 -> 182;
                            case 246 -> 201;
                            case 247 -> 49;
                            case 248 -> 181;
                            case 249 -> 234;
                            case 250 -> 138;
                            case 251 -> 71;
                            case 252 -> 171;
                            case 253 -> 141;
                            case 254 -> 211;
                            default -> 135;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray != null) {
                ActionTimestamp.i("uyn1dc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 49486834187542L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.i();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-220984020 + -18623, -220984020 + -14887, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-220984020 + -18627, 220984020 + 14626, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-220984020 + -18618, 220984020 + 6554, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-220984020 + -18623, -220984020 + -14887, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-220984020 + -18627, 220984020 + 14626, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-220984020 + -18615, 220984020 + 12832, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 67802464025624L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.i();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-2110227000 + -((char)-1970), -2110227000 + -((char)-30645), (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-2110227000 + -((char)-1969), -2110227000 + -((char)-18470), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 106236005235868L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.i();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18061, 0xA5FF5A - (char)-21301, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18057, -10878810 - -((char)-22058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18082, 0xA5FF5A - (char)-27170, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18057, -10878810 - -((char)-22058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18059, 0xA5FF5A - (char)-26371, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18061, 0xA5FF5A - (char)-21301, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18057, -10878810 - -((char)-22058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18073, 0xA5FF5A - (char)-17718, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18061, 0xA5FF5A - (char)-21301, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18057, -10878810 - -((char)-22058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18072, 0xA5FF5A - (char)-19801, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18061, 0xA5FF5A - (char)-21301, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18057, -10878810 - -((char)-22058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(0xA5FF5A - (char)-18071, 0xA5FF5A - (char)-13620, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 6695470655107L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.i();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(383379750 - 18734, 383379750 - 24726, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(383379750 - 18730, -383379750 - -22921, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(383379750 - 18743, -383379750 - -4260, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(383379750 - 18750, 383379750 + 5224, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(383379750 - 18734, 383379750 - 24726, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(383379750 - 18730, -383379750 - -22921, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(383379750 - 18749, 383379750 - 22671, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(383379750 - 18734, 383379750 - 24726, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(383379750 - 18730, -383379750 - -22921, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(383379750 - 18748, -383379750 - -22639, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(383379750 - 18734, 383379750 - 24726, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(383379750 - 18730, -383379750 - -22921, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(383379750 - 18747, 383379750 - 5749, (int)l2));
                    if (actionTimestampArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(383379750 - 18734, 383379750 - 24726, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(383379750 - 18730, -383379750 - -22921, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(383379750 - 18770, -383379750 - -8076, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(383379750 - 18769, -383379750 - -5306, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00cc\u00de\u00bf\u0014\u00bf\u0011J~\u0014m~\u00b3\u00e7\u00c0\u00e7\n\u00ba\u00f6\u008a?\u001a\u0017Y\u0001\u00a3\u00fdJ\u00e5\u00f2\u0006x;)\u00a8\u0007\u00c7\u0018,\u0005\u00fb\u00b8K\u00c9y\u00bfPW\u00e4\u00d1\n\u00df\u00f0\u00f1ji9\u000b\tr\u008c\u0092\tU5J\u000f\u0016\u00a0\u00ca\u00da\u001a\u0005*\u00cbc\u00b6T\b&\u00b0\u00e2\u00a8F\u00a0s\u00aa\u0014\u00e87{U\u00b4\u00b9\u00b1\u00e6\u00ef\u00dc\u00b7dL5\u00d1\u00c3\u00f5\u0095\u001dK\u0005\u009e?\u00f5(\u0086\u001e\u00b0\u00c1%\u0093\u0001h\u0092\u00f1\u0088\u008a\u00b4\u00edLx\u009aa\u00c6\u00ea~\u008fM\u00cd\b\u00a8\u00b7\u00fbR\u00bf}{\u0010\u00b4\u00c4A\u00f6\u00da\u00f6\u001f\u00dbD}\u00a0\u00ee\u00c8M\u00a5X\t\u00d0},\u0017\u0089\u0084\u001f\u00c1N\u0010\u0003B\u00b7&\u0004\u00ec\u00c4\u0098?\u0015\u00cf\u00e3%\u00ec\u0018l?]\u00e9\u0090\u0096\u00ba\u00c1`\u00a8\u00a7p\u0014I\u00e7\u001a\u00d2\u0014\n!\u009a3_\b1v\u0080\u00c8\u00b9m7wIV\u00ed\u00aef\u00ccmZ0\u000e\u00b2\u00f9\u00e5I\u00f5\u00e4\u0014p\u00b3\u00ec\u0002\u009b\u00c4j\u001e\u008e`zt\u00ddf\u00a8\u0098\bP\u00d7,D\u009f=H\u0019\f\u00069\u00f6\u0082\u00d9\u0087nICg\u0012\u00a9F\u0002\u00bevr\u00c9\u0099l\u008a\u0003\u0013\u0010\u00e3\u00f1G\u000f\u0099M\u00f7rFP\u00f4\u00d3\u00db\u00eaV\u0007\u00b5_E~,7W\u00ff\u00d2\u0084\u00d4\u00a6\u001b\u00f3NFD_\u00c0\u0015\u0089t+\u009c\u00c9\u00f8\u00b6\u008f\u000e\u00cd\u001eW\u00ed1\u00c7.k\u00de\u00e1\u00ac\u00db\u0084\u00c9\u001flA\u00be\u0083rj\u00fc\u00b1E\u0082\r\u00ec{Eww\u0000\u00c0\u00db\u00002\u00bc0-\u00d1\u009b\u0089\u007f\u001b\u0092\u00f4\u000bH`?\u00a9\u00e0\u00e2I\u00e5\u00a7\u00fe\u0084\u0015\u00ed\u00d8\u008b\u00bdq\b\u0097\u00c5B\u001a\u00f04z\u00f2J\u00d7\\@\u008di\u00ce)=\u000e\u0094j7WT\u0016Pv\u00afr+\u009c\u00e3I\u00cd\u008f\u00b9N\u008e\ra\u0003\u0094\u0017\u00f6\u0096\u00db[n\u00d1\u00cbM\u0006\u001c\u00a5\u0010\t*\u00a5\u0007\u008b\u000bH\u00d0\u0088]8\u0007\u0087\u00bc\u00adJ\u00d3\u00e1E(\u00a0\u0084k\u001ax3K\u00bd\u00c3\u00d4\u00f7\u0010\u0003Q\u00a4s\"e\u00eaP\u0085\u00f0ow\u00c5%j\u00ab\u007f\u009c!0\u00d9\u001a\u00da[\u0084\u0085\u00bek\u000fem\u009d\u000eN\u00dd(\u00a3\u00da\u009au\u0088\u00f3\u0016$\"\u008b6Bm\u00ed\u00b7\u000f\n;\u00f5\u00c2\u0002\u0085\u009eR\u00c7\u0010w\u0088\u0013B\u00a6X& \u00e7\u00adV\u0094q%\u0093\u008c\u00f6\u000ec\u00e5]\u001fV\u00ff+\u00e7\u00ba\u0012y\u0099~>\u001b\u00f8@)\u00ae#|\u0010\u00cb\u008a\u0010\u00f2\u00d8_ /\u0006\u0017\u00e5\u00d5\u00dd\u00d2K9=G\u00e9\u0014\nz\u0086\u00bdq\u00a5c\u0013\u0002AK\u0018\u0007U\u00d6\u0001\u00dd5\u00ee\u00bcK7\b\u00a3\u00b9\u001c\u000f\u00a0d0l\u001e\u009dx\u008b\b)t\u00c9\u00bd\u0092\u0012H\u00f0\u00f5\u00c4\n=\u00fd}d\u00b6-\u0019v\u00fc\u00b4\u001cBz\u00e6\u00829\u00a9\u00bfc\"\u00c2o{D\u00c5\u00a9\u0003\u0082\u00ddx?\t\u00ec\u0012\u00ab\u00e4s5\u0016\u00ac\u00d2";
                var4_3 = "\u00cc\u00de\u00bf\u0014\u00bf\u0011J~\u0014m~\u00b3\u00e7\u00c0\u00e7\n\u00ba\u00f6\u008a?\u001a\u0017Y\u0001\u00a3\u00fdJ\u00e5\u00f2\u0006x;)\u00a8\u0007\u00c7\u0018,\u0005\u00fb\u00b8K\u00c9y\u00bfPW\u00e4\u00d1\n\u00df\u00f0\u00f1ji9\u000b\tr\u008c\u0092\tU5J\u000f\u0016\u00a0\u00ca\u00da\u001a\u0005*\u00cbc\u00b6T\b&\u00b0\u00e2\u00a8F\u00a0s\u00aa\u0014\u00e87{U\u00b4\u00b9\u00b1\u00e6\u00ef\u00dc\u00b7dL5\u00d1\u00c3\u00f5\u0095\u001dK\u0005\u009e?\u00f5(\u0086\u001e\u00b0\u00c1%\u0093\u0001h\u0092\u00f1\u0088\u008a\u00b4\u00edLx\u009aa\u00c6\u00ea~\u008fM\u00cd\b\u00a8\u00b7\u00fbR\u00bf}{\u0010\u00b4\u00c4A\u00f6\u00da\u00f6\u001f\u00dbD}\u00a0\u00ee\u00c8M\u00a5X\t\u00d0},\u0017\u0089\u0084\u001f\u00c1N\u0010\u0003B\u00b7&\u0004\u00ec\u00c4\u0098?\u0015\u00cf\u00e3%\u00ec\u0018l?]\u00e9\u0090\u0096\u00ba\u00c1`\u00a8\u00a7p\u0014I\u00e7\u001a\u00d2\u0014\n!\u009a3_\b1v\u0080\u00c8\u00b9m7wIV\u00ed\u00aef\u00ccmZ0\u000e\u00b2\u00f9\u00e5I\u00f5\u00e4\u0014p\u00b3\u00ec\u0002\u009b\u00c4j\u001e\u008e`zt\u00ddf\u00a8\u0098\bP\u00d7,D\u009f=H\u0019\f\u00069\u00f6\u0082\u00d9\u0087nICg\u0012\u00a9F\u0002\u00bevr\u00c9\u0099l\u008a\u0003\u0013\u0010\u00e3\u00f1G\u000f\u0099M\u00f7rFP\u00f4\u00d3\u00db\u00eaV\u0007\u00b5_E~,7W\u00ff\u00d2\u0084\u00d4\u00a6\u001b\u00f3NFD_\u00c0\u0015\u0089t+\u009c\u00c9\u00f8\u00b6\u008f\u000e\u00cd\u001eW\u00ed1\u00c7.k\u00de\u00e1\u00ac\u00db\u0084\u00c9\u001flA\u00be\u0083rj\u00fc\u00b1E\u0082\r\u00ec{Eww\u0000\u00c0\u00db\u00002\u00bc0-\u00d1\u009b\u0089\u007f\u001b\u0092\u00f4\u000bH`?\u00a9\u00e0\u00e2I\u00e5\u00a7\u00fe\u0084\u0015\u00ed\u00d8\u008b\u00bdq\b\u0097\u00c5B\u001a\u00f04z\u00f2J\u00d7\\@\u008di\u00ce)=\u000e\u0094j7WT\u0016Pv\u00afr+\u009c\u00e3I\u00cd\u008f\u00b9N\u008e\ra\u0003\u0094\u0017\u00f6\u0096\u00db[n\u00d1\u00cbM\u0006\u001c\u00a5\u0010\t*\u00a5\u0007\u008b\u000bH\u00d0\u0088]8\u0007\u0087\u00bc\u00adJ\u00d3\u00e1E(\u00a0\u0084k\u001ax3K\u00bd\u00c3\u00d4\u00f7\u0010\u0003Q\u00a4s\"e\u00eaP\u0085\u00f0ow\u00c5%j\u00ab\u007f\u009c!0\u00d9\u001a\u00da[\u0084\u0085\u00bek\u000fem\u009d\u000eN\u00dd(\u00a3\u00da\u009au\u0088\u00f3\u0016$\"\u008b6Bm\u00ed\u00b7\u000f\n;\u00f5\u00c2\u0002\u0085\u009eR\u00c7\u0010w\u0088\u0013B\u00a6X& \u00e7\u00adV\u0094q%\u0093\u008c\u00f6\u000ec\u00e5]\u001fV\u00ff+\u00e7\u00ba\u0012y\u0099~>\u001b\u00f8@)\u00ae#|\u0010\u00cb\u008a\u0010\u00f2\u00d8_ /\u0006\u0017\u00e5\u00d5\u00dd\u00d2K9=G\u00e9\u0014\nz\u0086\u00bdq\u00a5c\u0013\u0002AK\u0018\u0007U\u00d6\u0001\u00dd5\u00ee\u00bcK7\b\u00a3\u00b9\u001c\u000f\u00a0d0l\u001e\u009dx\u008b\b)t\u00c9\u00bd\u0092\u0012H\u00f0\u00f5\u00c4\n=\u00fd}d\u00b6-\u0019v\u00fc\u00b4\u001cBz\u00e6\u00829\u00a9\u00bfc\"\u00c2o{D\u00c5\u00a9\u0003\u0082\u00ddx?\t\u00ec\u0012\u00ab\u00e4s5\u0016\u00ac\u00d2".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 108;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "ve\u0010\u00eaJ\u00aa\u0016D\u00f5\u00d1\u00f6k\u00e9[\u00c9'\u001b\u00d6\u0001\u00c9\u001b?\u0084z\u001b[\u00e6[\u00f7\u0014\u00b3\u00ac\u0085P\u00eb\u00fc\u00824\n\u00b6Mp\u00b4\u00f9\u0098Z#\u0098\u00d3E";
                    var4_3 = "ve\u0010\u00eaJ\u00aa\u0016D\u00f5\u00d1\u00f6k\u00e9[\u00c9'\u001b\u00d6\u0001\u00c9\u001b?\u0084z\u001b[\u00e6[\u00f7\u0014\u00b3\u00ac\u0085P\u00eb\u00fc\u00824\n\u00b6Mp\u00b4\u00f9\u0098Z#\u0098\u00d3E".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 41;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 119;
                            break;
                        }
                        case 1: {
                            v15 = 17;
                            break;
                        }
                        case 2: {
                            v15 = 39;
                            break;
                        }
                        case 3: {
                            v15 = 45;
                            break;
                        }
                        case 4: {
                            v15 = 99;
                            break;
                        }
                        case 5: {
                            v15 = 127;
                            break;
                        }
                        default: {
                            v15 = 30;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFF977) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 230;
                case 1 -> 48;
                case 2 -> 91;
                case 3 -> 21;
                case 4 -> 209;
                case 5 -> 156;
                case 6 -> 122;
                case 7 -> 182;
                case 8 -> 213;
                case 9 -> 5;
                case 10 -> 194;
                case 11 -> 244;
                case 12 -> 149;
                case 13 -> 27;
                case 14 -> 171;
                case 15 -> 214;
                case 16 -> 60;
                case 17 -> 65;
                case 18 -> 186;
                case 19 -> 107;
                case 20 -> 168;
                case 21 -> 236;
                case 22 -> 220;
                case 23 -> 216;
                case 24 -> 148;
                case 25 -> 239;
                case 26 -> 57;
                case 27 -> 46;
                case 28 -> 238;
                case 29 -> 16;
                case 30 -> 67;
                case 31 -> 108;
                case 32 -> 226;
                case 33 -> 181;
                case 34 -> 140;
                case 35 -> 79;
                case 36 -> 96;
                case 37 -> 114;
                case 38 -> 198;
                case 39 -> 42;
                case 40 -> 211;
                case 41 -> 104;
                case 42 -> 10;
                case 43 -> 176;
                case 44 -> 12;
                case 45 -> 99;
                case 46 -> 49;
                case 47 -> 150;
                case 48 -> 137;
                case 49 -> 1;
                case 50 -> 162;
                case 51 -> 38;
                case 52 -> 241;
                case 53 -> 229;
                case 54 -> 100;
                case 55 -> 165;
                case 56 -> 64;
                case 57 -> 58;
                case 58 -> 59;
                case 59 -> 87;
                case 60 -> 178;
                case 61 -> 112;
                case 62 -> 249;
                case 63 -> 4;
                case 64 -> 32;
                case 65 -> 93;
                case 66 -> 106;
                case 67 -> 129;
                case 68 -> 19;
                case 69 -> 167;
                case 70 -> 84;
                case 71 -> 3;
                case 72 -> 233;
                case 73 -> 231;
                case 74 -> 253;
                case 75 -> 80;
                case 76 -> 52;
                case 77 -> 144;
                case 78 -> 250;
                case 79 -> 190;
                case 80 -> 26;
                case 81 -> 142;
                case 82 -> 39;
                case 83 -> 123;
                case 84 -> 247;
                case 85 -> 152;
                case 86 -> 11;
                case 87 -> 146;
                case 88 -> 141;
                case 89 -> 159;
                case 90 -> 245;
                case 91 -> 31;
                case 92 -> 203;
                case 93 -> 62;
                case 94 -> 187;
                case 95 -> 166;
                case 96 -> 95;
                case 97 -> 192;
                case 98 -> 219;
                case 99 -> 243;
                case 100 -> 23;
                case 101 -> 86;
                case 102 -> 51;
                case 103 -> 53;
                case 104 -> 179;
                case 105 -> 153;
                case 106 -> 199;
                case 107 -> 13;
                case 108 -> 50;
                case 109 -> 125;
                case 110 -> 41;
                case 111 -> 117;
                case 112 -> 78;
                case 113 -> 43;
                case 114 -> 88;
                case 115 -> 151;
                case 116 -> 72;
                case 117 -> 124;
                case 118 -> 131;
                case 119 -> 174;
                case 120 -> 208;
                case 121 -> 81;
                case 122 -> 138;
                case 123 -> 248;
                case 124 -> 202;
                case 125 -> 0;
                case 126 -> 200;
                case 127 -> 215;
                case 128 -> 160;
                case 129 -> 224;
                case 130 -> 161;
                case 131 -> 20;
                case 132 -> 92;
                case 133 -> 235;
                case 134 -> 218;
                case 135 -> 173;
                case 136 -> 205;
                case 137 -> 70;
                case 138 -> 210;
                case 139 -> 121;
                case 140 -> 206;
                case 141 -> 134;
                case 142 -> 188;
                case 143 -> 83;
                case 144 -> 133;
                case 145 -> 227;
                case 146 -> 22;
                case 147 -> 225;
                case 148 -> 102;
                case 149 -> 207;
                case 150 -> 61;
                case 151 -> 170;
                case 152 -> 76;
                case 153 -> 94;
                case 154 -> 136;
                case 155 -> 110;
                case 156 -> 7;
                case 157 -> 180;
                case 158 -> 147;
                case 159 -> 2;
                case 160 -> 68;
                case 161 -> 237;
                case 162 -> 119;
                case 163 -> 29;
                case 164 -> 234;
                case 165 -> 145;
                case 166 -> 175;
                case 167 -> 201;
                case 168 -> 183;
                case 169 -> 97;
                case 170 -> 189;
                case 171 -> 154;
                case 172 -> 128;
                case 173 -> 77;
                case 174 -> 8;
                case 175 -> 135;
                case 176 -> 111;
                case 177 -> 40;
                case 178 -> 98;
                case 179 -> 89;
                case 180 -> 155;
                case 181 -> 212;
                case 182 -> 9;
                case 183 -> 184;
                case 184 -> 163;
                case 185 -> 30;
                case 186 -> 242;
                case 187 -> 69;
                case 188 -> 127;
                case 189 -> 37;
                case 190 -> 74;
                case 191 -> 204;
                case 192 -> 130;
                case 193 -> 118;
                case 194 -> 113;
                case 195 -> 55;
                case 196 -> 25;
                case 197 -> 222;
                case 198 -> 132;
                case 199 -> 103;
                case 200 -> 54;
                case 201 -> 15;
                case 202 -> 197;
                case 203 -> 251;
                case 204 -> 177;
                case 205 -> 44;
                case 206 -> 85;
                case 207 -> 240;
                case 208 -> 139;
                case 209 -> 252;
                case 210 -> 246;
                case 211 -> 228;
                case 212 -> 164;
                case 213 -> 105;
                case 214 -> 196;
                case 215 -> 28;
                case 216 -> 14;
                case 217 -> 18;
                case 218 -> 157;
                case 219 -> 66;
                case 220 -> 195;
                case 221 -> 143;
                case 222 -> 191;
                case 223 -> 82;
                case 224 -> 254;
                case 225 -> 71;
                case 226 -> 34;
                case 227 -> 36;
                case 228 -> 47;
                case 229 -> 185;
                case 230 -> 223;
                case 231 -> 193;
                case 232 -> 255;
                case 233 -> 221;
                case 234 -> 158;
                case 235 -> 17;
                case 236 -> 56;
                case 237 -> 115;
                case 238 -> 217;
                case 239 -> 24;
                case 240 -> 63;
                case 241 -> 126;
                case 242 -> 169;
                case 243 -> 6;
                case 244 -> 116;
                case 245 -> 109;
                case 246 -> 172;
                case 247 -> 101;
                case 248 -> 35;
                case 249 -> 33;
                case 250 -> 120;
                case 251 -> 232;
                case 252 -> 73;
                case 253 -> 90;
                case 254 -> 75;
                default -> 45;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 64850893791854L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1182644610 - (char)-11093, -1182513540 + -((char)-7288), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 112550345922224L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.i();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(727962780 - (char)-31596, -727962780 - -((char)-24388), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(727962780 - (char)-31599, 727962780 - (char)-16322, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(727962780 - (char)-31598, 727962780 - 24893, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00e65\u0013\u00d08\u00aa?\u00bc\u0010\u009aJm\u009eM\u00d8h\u00ab1\u009a\u00b7\u0000\t\u0015(\u00c8";
                    var4_3 = "\u00e65\u0013\u00d08\u00aa?\u00bc\u0010\u009aJm\u009eM\u00d8h\u00ab1\u009a\u00b7\u0000\t\u0015(\u00c8".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 120;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00bf&\u00f1{\u00dd5j\u0006\\\u0013\u00ba\u0099G\u00e1j\u00a1\u0087n1\u00fb\u00e3V\u0012\u00d0\u00d5v\u00e6Y\u00f8(\u00a8wI\u00fc\u00c5'\u00e6k?_t\u00cf\u00b80\u00be\u00f39%\u007fh\u00d3[\u00f9\u00ff\u00f6\u0097\u00eb\u00f1\u00cc";
                        var4_3 = "\u00bf&\u00f1{\u00dd5j\u0006\\\u0013\u00ba\u0099G\u00e1j\u00a1\u0087n1\u00fb\u00e3V\u0012\u00d0\u00d5v\u00e6Y\u00f8(\u00a8wI\u00fc\u00c5'\u00e6k?_t\u00cf\u00b80\u00be\u00f39%\u007fh\u00d3[\u00f9\u00ff\u00f6\u0097\u00eb\u00f1\u00cc".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 29;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 127;
                                break;
                            }
                            case 1: {
                                v15 = 83;
                                break;
                            }
                            case 2: {
                                v15 = 89;
                                break;
                            }
                            case 3: {
                                v15 = 74;
                                break;
                            }
                            case 4: {
                                v15 = 40;
                                break;
                            }
                            case 5: {
                                v15 = 38;
                                break;
                            }
                            default: {
                                v15 = 100;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6B9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 209;
                    case 1 -> 179;
                    case 2 -> 133;
                    case 3 -> 61;
                    case 4 -> 43;
                    case 5 -> 193;
                    case 6 -> 120;
                    case 7 -> 161;
                    case 8 -> 189;
                    case 9 -> 249;
                    case 10 -> 48;
                    case 11 -> 86;
                    case 12 -> 105;
                    case 13 -> 213;
                    case 14 -> 128;
                    case 15 -> 168;
                    case 16 -> 143;
                    case 17 -> 167;
                    case 18 -> 52;
                    case 19 -> 76;
                    case 20 -> 225;
                    case 21 -> 154;
                    case 22 -> 229;
                    case 23 -> 224;
                    case 24 -> 108;
                    case 25 -> 102;
                    case 26 -> 36;
                    case 27 -> 252;
                    case 28 -> 251;
                    case 29 -> 27;
                    case 30 -> 30;
                    case 31 -> 2;
                    case 32 -> 250;
                    case 33 -> 45;
                    case 34 -> 5;
                    case 35 -> 55;
                    case 36 -> 74;
                    case 37 -> 111;
                    case 38 -> 138;
                    case 39 -> 97;
                    case 40 -> 160;
                    case 41 -> 79;
                    case 42 -> 22;
                    case 43 -> 162;
                    case 44 -> 242;
                    case 45 -> 6;
                    case 46 -> 202;
                    case 47 -> 221;
                    case 48 -> 93;
                    case 49 -> 28;
                    case 50 -> 175;
                    case 51 -> 35;
                    case 52 -> 8;
                    case 53 -> 7;
                    case 54 -> 130;
                    case 55 -> 72;
                    case 56 -> 234;
                    case 57 -> 204;
                    case 58 -> 131;
                    case 59 -> 4;
                    case 60 -> 247;
                    case 61 -> 82;
                    case 62 -> 216;
                    case 63 -> 83;
                    case 64 -> 191;
                    case 65 -> 248;
                    case 66 -> 171;
                    case 67 -> 198;
                    case 68 -> 137;
                    case 69 -> 190;
                    case 70 -> 26;
                    case 71 -> 181;
                    case 72 -> 60;
                    case 73 -> 95;
                    case 74 -> 253;
                    case 75 -> 243;
                    case 76 -> 155;
                    case 77 -> 109;
                    case 78 -> 236;
                    case 79 -> 103;
                    case 80 -> 205;
                    case 81 -> 100;
                    case 82 -> 10;
                    case 83 -> 215;
                    case 84 -> 3;
                    case 85 -> 218;
                    case 86 -> 41;
                    case 87 -> 81;
                    case 88 -> 231;
                    case 89 -> 32;
                    case 90 -> 134;
                    case 91 -> 219;
                    case 92 -> 182;
                    case 93 -> 33;
                    case 94 -> 233;
                    case 95 -> 107;
                    case 96 -> 152;
                    case 97 -> 18;
                    case 98 -> 50;
                    case 99 -> 92;
                    case 100 -> 217;
                    case 101 -> 125;
                    case 102 -> 124;
                    case 103 -> 163;
                    case 104 -> 153;
                    case 105 -> 19;
                    case 106 -> 170;
                    case 107 -> 63;
                    case 108 -> 203;
                    case 109 -> 47;
                    case 110 -> 192;
                    case 111 -> 13;
                    case 112 -> 151;
                    case 113 -> 188;
                    case 114 -> 255;
                    case 115 -> 211;
                    case 116 -> 185;
                    case 117 -> 57;
                    case 118 -> 106;
                    case 119 -> 119;
                    case 120 -> 178;
                    case 121 -> 207;
                    case 122 -> 173;
                    case 123 -> 98;
                    case 124 -> 99;
                    case 125 -> 159;
                    case 126 -> 222;
                    case 127 -> 94;
                    case 128 -> 254;
                    case 129 -> 87;
                    case 130 -> 196;
                    case 131 -> 118;
                    case 132 -> 239;
                    case 133 -> 228;
                    case 134 -> 165;
                    case 135 -> 129;
                    case 136 -> 96;
                    case 137 -> 241;
                    case 138 -> 220;
                    case 139 -> 112;
                    case 140 -> 180;
                    case 141 -> 166;
                    case 142 -> 89;
                    case 143 -> 146;
                    case 144 -> 1;
                    case 145 -> 67;
                    case 146 -> 16;
                    case 147 -> 140;
                    case 148 -> 246;
                    case 149 -> 51;
                    case 150 -> 157;
                    case 151 -> 245;
                    case 152 -> 53;
                    case 153 -> 11;
                    case 154 -> 34;
                    case 155 -> 85;
                    case 156 -> 15;
                    case 157 -> 150;
                    case 158 -> 0;
                    case 159 -> 29;
                    case 160 -> 91;
                    case 161 -> 177;
                    case 162 -> 237;
                    case 163 -> 230;
                    case 164 -> 214;
                    case 165 -> 70;
                    case 166 -> 199;
                    case 167 -> 235;
                    case 168 -> 23;
                    case 169 -> 244;
                    case 170 -> 176;
                    case 171 -> 195;
                    case 172 -> 113;
                    case 173 -> 37;
                    case 174 -> 174;
                    case 175 -> 39;
                    case 176 -> 147;
                    case 177 -> 73;
                    case 178 -> 66;
                    case 179 -> 144;
                    case 180 -> 71;
                    case 181 -> 223;
                    case 182 -> 145;
                    case 183 -> 56;
                    case 184 -> 59;
                    case 185 -> 227;
                    case 186 -> 183;
                    case 187 -> 142;
                    case 188 -> 75;
                    case 189 -> 240;
                    case 190 -> 197;
                    case 191 -> 88;
                    case 192 -> 40;
                    case 193 -> 126;
                    case 194 -> 169;
                    case 195 -> 25;
                    case 196 -> 77;
                    case 197 -> 14;
                    case 198 -> 200;
                    case 199 -> 148;
                    case 200 -> 42;
                    case 201 -> 156;
                    case 202 -> 158;
                    case 203 -> 49;
                    case 204 -> 122;
                    case 205 -> 62;
                    case 206 -> 54;
                    case 207 -> 44;
                    case 208 -> 184;
                    case 209 -> 206;
                    case 210 -> 104;
                    case 211 -> 46;
                    case 212 -> 38;
                    case 213 -> 69;
                    case 214 -> 116;
                    case 215 -> 20;
                    case 216 -> 90;
                    case 217 -> 117;
                    case 218 -> 101;
                    case 219 -> 24;
                    case 220 -> 210;
                    case 221 -> 65;
                    case 222 -> 68;
                    case 223 -> 31;
                    case 224 -> 149;
                    case 225 -> 9;
                    case 226 -> 115;
                    case 227 -> 17;
                    case 228 -> 208;
                    case 229 -> 136;
                    case 230 -> 114;
                    case 231 -> 21;
                    case 232 -> 127;
                    case 233 -> 238;
                    case 234 -> 232;
                    case 235 -> 212;
                    case 236 -> 84;
                    case 237 -> 201;
                    case 238 -> 110;
                    case 239 -> 141;
                    case 240 -> 78;
                    case 241 -> 194;
                    case 242 -> 121;
                    case 243 -> 135;
                    case 244 -> 80;
                    case 245 -> 123;
                    case 246 -> 172;
                    case 247 -> 226;
                    case 248 -> 58;
                    case 249 -> 164;
                    case 250 -> 139;
                    case 251 -> 12;
                    case 252 -> 132;
                    case 253 -> 187;
                    case 254 -> 186;
                    default -> 64;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 64620021375350L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "Dm&9Jah\u001d\tCg53\u0007#u\u0001!";
                    var5_4 = "Dm&9Jah\u001d\tCg53\u0007#u\u0001!".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 41;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 6;
                                    break;
                                }
                                case 1: {
                                    v11 = 33;
                                    break;
                                }
                                case 2: {
                                    v11 = 125;
                                    break;
                                }
                                case 3: {
                                    v11 = 126;
                                    break;
                                }
                                case 4: {
                                    v11 = 6;
                                    break;
                                }
                                case 5: {
                                    v11 = 36;
                                    break;
                                }
                                default: {
                                    v11 = 114;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 131117680473653L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "=t.iW\u001a{\u0004;j\"s\n7u)s[\u0018c\u001dt \t7u)s[\u0018c\u0011~\r0s4~Q\u0015y\u0011y3tP\u001c";
                    var5_4 = "=t.iW\u001a{\u0004;j\"s\n7u)s[\u0018c\u001dt \t7u)s[\u0018c\u0011~\r0s4~Q\u0015y\u0011y3tP\u001c".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 121;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "k*t2\u000bI,\u0006k*t2\u0007C";
                        var5_4 = "k*t2\u000bI,\u0006k*t2\u0007C".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 37;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 13;
                                break;
                            }
                            case 1: {
                                v15 = 99;
                                break;
                            }
                            case 2: {
                                v15 = 62;
                                break;
                            }
                            case 3: {
                                v15 = 100;
                                break;
                            }
                            case 4: {
                                v15 = 71;
                                break;
                            }
                            case 5: {
                                v15 = 2;
                                break;
                            }
                            default: {
                                v15 = 110;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 29695453811519L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(49937670 + 704, 49937670 - 22630, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 73320067042981L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "),\u00ae\u00d9\u0002\u0003]`\u0094\u0005\u0090r\u00bf\u00d6\u00c3\ro2v\u0094\u000f\u00b0l\u0017\u00b8\u00eb\u008b}\u00d4\u0010\u00d7\u00d1\u00a6\u0003*\u00d7\u00e3\u00c6\u0080Uo\u00e7\u00ae\u008eP{\u0005\u0096\u00a1\u007f\u00ac\u00db3-C\u0019\u0087\b\u0003\u0097Hsy\u009aK\u00d6Js\u00fc\u009b\u00b9D.\u00dd\u0011\u00f0\u0002Ezh\u00a5\u001a\u00b1\u0089\u00c3\u00c4\u0099E9m\u0007\u0093\u00c8t\u00b6\u0082!\u00b6'\u00ec/s\u00f8\u00a2";
                    var4_3 = "),\u00ae\u00d9\u0002\u0003]`\u0094\u0005\u0090r\u00bf\u00d6\u00c3\ro2v\u0094\u000f\u00b0l\u0017\u00b8\u00eb\u008b}\u00d4\u0010\u00d7\u00d1\u00a6\u0003*\u00d7\u00e3\u00c6\u0080Uo\u00e7\u00ae\u008eP{\u0005\u0096\u00a1\u007f\u00ac\u00db3-C\u0019\u0087\b\u0003\u0097Hsy\u009aK\u00d6Js\u00fc\u009b\u00b9D.\u00dd\u0011\u00f0\u0002Ezh\u00a5\u001a\u00b1\u0089\u00c3\u00c4\u0099E9m\u0007\u0093\u00c8t\u00b6\u0082!\u00b6'\u00ec/s\u00f8\u00a2".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 93;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "9\u00c7\u00fa@ >#z\u0019C\u00dd\u00a4yg+\u00c7L\u00c6\u00bb\u00f2\u0005\u000b^(\u0018\u00f1\u009cl\u00e6A\u00a1\u00bff\u0086\u00ba\u00999\u008f\u0016\u0011\u00c1\u00dbh\u001f\u00a0\u008f\u00d9U \u00ce\u008a\u00f4\u00c6\u00e8\u00a7\u0098;\u00a2\u00b4\u0016\u009d\u00b0\u00eff\u008fQY\u008f\u0096\u008c\u009f\u00f6\u00a1\u00c1\u0091\u0085O\u00e1\u009c\u00a3\u00cd\u00c0?C\u00ec\u00ce\u001b\u0018\u00e1\u009du\u00f7W";
                        var4_3 = "9\u00c7\u00fa@ >#z\u0019C\u00dd\u00a4yg+\u00c7L\u00c6\u00bb\u00f2\u0005\u000b^(\u0018\u00f1\u009cl\u00e6A\u00a1\u00bff\u0086\u00ba\u00999\u008f\u0016\u0011\u00c1\u00dbh\u001f\u00a0\u008f\u00d9U \u00ce\u008a\u00f4\u00c6\u00e8\u00a7\u0098;\u00a2\u00b4\u0016\u009d\u00b0\u00eff\u008fQY\u008f\u0096\u008c\u009f\u00f6\u00a1\u00c1\u0091\u0085O\u00e1\u009c\u00a3\u00cd\u00c0?C\u00ec\u00ce\u001b\u0018\u00e1\u009du\u00f7W".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 120;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 88;
                                break;
                            }
                            case 1: {
                                v15 = 51;
                                break;
                            }
                            case 2: {
                                v15 = 94;
                                break;
                            }
                            case 3: {
                                v15 = 41;
                                break;
                            }
                            case 4: {
                                v15 = 87;
                                break;
                            }
                            case 5: {
                                v15 = 119;
                                break;
                            }
                            default: {
                                v15 = 109;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2CF9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 29;
                    case 1 -> 31;
                    case 2 -> 246;
                    case 3 -> 170;
                    case 4 -> 87;
                    case 5 -> 137;
                    case 6 -> 143;
                    case 7 -> 220;
                    case 8 -> 195;
                    case 9 -> 30;
                    case 10 -> 81;
                    case 11 -> 145;
                    case 12 -> 3;
                    case 13 -> 40;
                    case 14 -> 110;
                    case 15 -> 215;
                    case 16 -> 207;
                    case 17 -> 243;
                    case 18 -> 16;
                    case 19 -> 60;
                    case 20 -> 135;
                    case 21 -> 224;
                    case 22 -> 126;
                    case 23 -> 171;
                    case 24 -> 74;
                    case 25 -> 245;
                    case 26 -> 242;
                    case 27 -> 11;
                    case 28 -> 244;
                    case 29 -> 15;
                    case 30 -> 227;
                    case 31 -> 71;
                    case 32 -> 57;
                    case 33 -> 10;
                    case 34 -> 179;
                    case 35 -> 229;
                    case 36 -> 93;
                    case 37 -> 14;
                    case 38 -> 95;
                    case 39 -> 33;
                    case 40 -> 91;
                    case 41 -> 174;
                    case 42 -> 213;
                    case 43 -> 161;
                    case 44 -> 82;
                    case 45 -> 192;
                    case 46 -> 39;
                    case 47 -> 200;
                    case 48 -> 70;
                    case 49 -> 164;
                    case 50 -> 173;
                    case 51 -> 197;
                    case 52 -> 45;
                    case 53 -> 255;
                    case 54 -> 250;
                    case 55 -> 122;
                    case 56 -> 235;
                    case 57 -> 86;
                    case 58 -> 214;
                    case 59 -> 153;
                    case 60 -> 56;
                    case 61 -> 19;
                    case 62 -> 105;
                    case 63 -> 186;
                    case 64 -> 65;
                    case 65 -> 232;
                    case 66 -> 37;
                    case 67 -> 131;
                    case 68 -> 69;
                    case 69 -> 80;
                    case 70 -> 133;
                    case 71 -> 0;
                    case 72 -> 160;
                    case 73 -> 72;
                    case 74 -> 55;
                    case 75 -> 111;
                    case 76 -> 44;
                    case 77 -> 83;
                    case 78 -> 187;
                    case 79 -> 102;
                    case 80 -> 210;
                    case 81 -> 149;
                    case 82 -> 25;
                    case 83 -> 117;
                    case 84 -> 217;
                    case 85 -> 18;
                    case 86 -> 222;
                    case 87 -> 1;
                    case 88 -> 150;
                    case 89 -> 75;
                    case 90 -> 189;
                    case 91 -> 92;
                    case 92 -> 168;
                    case 93 -> 9;
                    case 94 -> 36;
                    case 95 -> 108;
                    case 96 -> 241;
                    case 97 -> 104;
                    case 98 -> 113;
                    case 99 -> 17;
                    case 100 -> 204;
                    case 101 -> 64;
                    case 102 -> 228;
                    case 103 -> 89;
                    case 104 -> 134;
                    case 105 -> 50;
                    case 106 -> 90;
                    case 107 -> 114;
                    case 108 -> 248;
                    case 109 -> 38;
                    case 110 -> 236;
                    case 111 -> 77;
                    case 112 -> 120;
                    case 113 -> 177;
                    case 114 -> 206;
                    case 115 -> 183;
                    case 116 -> 98;
                    case 117 -> 46;
                    case 118 -> 155;
                    case 119 -> 6;
                    case 120 -> 212;
                    case 121 -> 154;
                    case 122 -> 53;
                    case 123 -> 234;
                    case 124 -> 2;
                    case 125 -> 178;
                    case 126 -> 140;
                    case 127 -> 79;
                    case 128 -> 103;
                    case 129 -> 34;
                    case 130 -> 158;
                    case 131 -> 172;
                    case 132 -> 76;
                    case 133 -> 211;
                    case 134 -> 198;
                    case 135 -> 128;
                    case 136 -> 182;
                    case 137 -> 239;
                    case 138 -> 199;
                    case 139 -> 167;
                    case 140 -> 129;
                    case 141 -> 43;
                    case 142 -> 21;
                    case 143 -> 32;
                    case 144 -> 141;
                    case 145 -> 201;
                    case 146 -> 63;
                    case 147 -> 205;
                    case 148 -> 4;
                    case 149 -> 124;
                    case 150 -> 193;
                    case 151 -> 23;
                    case 152 -> 188;
                    case 153 -> 51;
                    case 154 -> 144;
                    case 155 -> 190;
                    case 156 -> 185;
                    case 157 -> 99;
                    case 158 -> 62;
                    case 159 -> 116;
                    case 160 -> 41;
                    case 161 -> 109;
                    case 162 -> 61;
                    case 163 -> 252;
                    case 164 -> 181;
                    case 165 -> 208;
                    case 166 -> 84;
                    case 167 -> 226;
                    case 168 -> 127;
                    case 169 -> 184;
                    case 170 -> 180;
                    case 171 -> 249;
                    case 172 -> 136;
                    case 173 -> 66;
                    case 174 -> 94;
                    case 175 -> 115;
                    case 176 -> 97;
                    case 177 -> 138;
                    case 178 -> 12;
                    case 179 -> 26;
                    case 180 -> 24;
                    case 181 -> 194;
                    case 182 -> 253;
                    case 183 -> 73;
                    case 184 -> 159;
                    case 185 -> 196;
                    case 186 -> 216;
                    case 187 -> 169;
                    case 188 -> 251;
                    case 189 -> 152;
                    case 190 -> 202;
                    case 191 -> 118;
                    case 192 -> 151;
                    case 193 -> 176;
                    case 194 -> 35;
                    case 195 -> 146;
                    case 196 -> 22;
                    case 197 -> 8;
                    case 198 -> 230;
                    case 199 -> 106;
                    case 200 -> 67;
                    case 201 -> 49;
                    case 202 -> 58;
                    case 203 -> 54;
                    case 204 -> 233;
                    case 205 -> 121;
                    case 206 -> 52;
                    case 207 -> 132;
                    case 208 -> 148;
                    case 209 -> 100;
                    case 210 -> 156;
                    case 211 -> 139;
                    case 212 -> 147;
                    case 213 -> 96;
                    case 214 -> 7;
                    case 215 -> 142;
                    case 216 -> 157;
                    case 217 -> 20;
                    case 218 -> 130;
                    case 219 -> 48;
                    case 220 -> 209;
                    case 221 -> 59;
                    case 222 -> 238;
                    case 223 -> 5;
                    case 224 -> 42;
                    case 225 -> 231;
                    case 226 -> 162;
                    case 227 -> 237;
                    case 228 -> 219;
                    case 229 -> 218;
                    case 230 -> 123;
                    case 231 -> 165;
                    case 232 -> 27;
                    case 233 -> 175;
                    case 234 -> 107;
                    case 235 -> 119;
                    case 236 -> 240;
                    case 237 -> 78;
                    case 238 -> 247;
                    case 239 -> 191;
                    case 240 -> 112;
                    case 241 -> 254;
                    case 242 -> 88;
                    case 243 -> 221;
                    case 244 -> 203;
                    case 245 -> 68;
                    case 246 -> 28;
                    case 247 -> 13;
                    case 248 -> 101;
                    case 249 -> 166;
                    case 250 -> 163;
                    case 251 -> 47;
                    case 252 -> 225;
                    case 253 -> 125;
                    case 254 -> 223;
                    default -> 85;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 131870961334113L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1714526670 + 11486, -1714526670 + -10054, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 128244172824525L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.i();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-744346530 - -419, 744346530 - 7597, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 9944958032864L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00eeJ\u0080Z\u009e\u0003U,\u00a1";
                var4_3 = "\u00eeJ\u0080Z\u009e\u0003U,\u00a1".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 80;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 96;
                                break;
                            }
                            case 1: {
                                v11 = 6;
                                break;
                            }
                            case 2: {
                                v11 = 35;
                                break;
                            }
                            case 3: {
                                v11 = 108;
                                break;
                            }
                            case 4: {
                                v11 = 13;
                                break;
                            }
                            case 5: {
                                v11 = 109;
                                break;
                            }
                            default: {
                                v11 = 115;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB1CD) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 169;
                    case 1 -> 195;
                    case 2 -> 173;
                    case 3 -> 243;
                    case 4 -> 255;
                    case 5 -> 228;
                    case 6 -> 253;
                    case 7 -> 136;
                    case 8 -> 9;
                    case 9 -> 45;
                    case 10 -> 215;
                    case 11 -> 140;
                    case 12 -> 44;
                    case 13 -> 74;
                    case 14 -> 126;
                    case 15 -> 28;
                    case 16 -> 13;
                    case 17 -> 50;
                    case 18 -> 135;
                    case 19 -> 159;
                    case 20 -> 164;
                    case 21 -> 209;
                    case 22 -> 61;
                    case 23 -> 73;
                    case 24 -> 111;
                    case 25 -> 210;
                    case 26 -> 213;
                    case 27 -> 202;
                    case 28 -> 231;
                    case 29 -> 115;
                    case 30 -> 38;
                    case 31 -> 179;
                    case 32 -> 142;
                    case 33 -> 114;
                    case 34 -> 122;
                    case 35 -> 112;
                    case 36 -> 0;
                    case 37 -> 64;
                    case 38 -> 251;
                    case 39 -> 158;
                    case 40 -> 67;
                    case 41 -> 113;
                    case 42 -> 154;
                    case 43 -> 190;
                    case 44 -> 56;
                    case 45 -> 52;
                    case 46 -> 151;
                    case 47 -> 188;
                    case 48 -> 81;
                    case 49 -> 193;
                    case 50 -> 69;
                    case 51 -> 40;
                    case 52 -> 205;
                    case 53 -> 66;
                    case 54 -> 26;
                    case 55 -> 235;
                    case 56 -> 54;
                    case 57 -> 8;
                    case 58 -> 207;
                    case 59 -> 245;
                    case 60 -> 110;
                    case 61 -> 5;
                    case 62 -> 33;
                    case 63 -> 148;
                    case 64 -> 118;
                    case 65 -> 234;
                    case 66 -> 218;
                    case 67 -> 184;
                    case 68 -> 224;
                    case 69 -> 134;
                    case 70 -> 39;
                    case 71 -> 18;
                    case 72 -> 104;
                    case 73 -> 125;
                    case 74 -> 102;
                    case 75 -> 249;
                    case 76 -> 211;
                    case 77 -> 30;
                    case 78 -> 156;
                    case 79 -> 14;
                    case 80 -> 46;
                    case 81 -> 41;
                    case 82 -> 62;
                    case 83 -> 58;
                    case 84 -> 79;
                    case 85 -> 137;
                    case 86 -> 214;
                    case 87 -> 168;
                    case 88 -> 116;
                    case 89 -> 197;
                    case 90 -> 254;
                    case 91 -> 176;
                    case 92 -> 219;
                    case 93 -> 227;
                    case 94 -> 3;
                    case 95 -> 35;
                    case 96 -> 194;
                    case 97 -> 77;
                    case 98 -> 246;
                    case 99 -> 171;
                    case 100 -> 223;
                    case 101 -> 34;
                    case 102 -> 19;
                    case 103 -> 181;
                    case 104 -> 232;
                    case 105 -> 165;
                    case 106 -> 149;
                    case 107 -> 21;
                    case 108 -> 236;
                    case 109 -> 93;
                    case 110 -> 27;
                    case 111 -> 241;
                    case 112 -> 212;
                    case 113 -> 1;
                    case 114 -> 133;
                    case 115 -> 72;
                    case 116 -> 4;
                    case 117 -> 198;
                    case 118 -> 31;
                    case 119 -> 6;
                    case 120 -> 217;
                    case 121 -> 237;
                    case 122 -> 139;
                    case 123 -> 153;
                    case 124 -> 230;
                    case 125 -> 226;
                    case 126 -> 90;
                    case 127 -> 155;
                    case 128 -> 225;
                    case 129 -> 242;
                    case 130 -> 182;
                    case 131 -> 174;
                    case 132 -> 16;
                    case 133 -> 121;
                    case 134 -> 143;
                    case 135 -> 12;
                    case 136 -> 132;
                    case 137 -> 145;
                    case 138 -> 229;
                    case 139 -> 166;
                    case 140 -> 250;
                    case 141 -> 120;
                    case 142 -> 85;
                    case 143 -> 178;
                    case 144 -> 53;
                    case 145 -> 63;
                    case 146 -> 92;
                    case 147 -> 15;
                    case 148 -> 65;
                    case 149 -> 20;
                    case 150 -> 70;
                    case 151 -> 187;
                    case 152 -> 101;
                    case 153 -> 51;
                    case 154 -> 89;
                    case 155 -> 57;
                    case 156 -> 203;
                    case 157 -> 25;
                    case 158 -> 42;
                    case 159 -> 124;
                    case 160 -> 239;
                    case 161 -> 177;
                    case 162 -> 82;
                    case 163 -> 100;
                    case 164 -> 103;
                    case 165 -> 99;
                    case 166 -> 76;
                    case 167 -> 2;
                    case 168 -> 36;
                    case 169 -> 107;
                    case 170 -> 37;
                    case 171 -> 183;
                    case 172 -> 47;
                    case 173 -> 123;
                    case 174 -> 200;
                    case 175 -> 80;
                    case 176 -> 161;
                    case 177 -> 24;
                    case 178 -> 83;
                    case 179 -> 201;
                    case 180 -> 248;
                    case 181 -> 191;
                    case 182 -> 59;
                    case 183 -> 128;
                    case 184 -> 192;
                    case 185 -> 97;
                    case 186 -> 185;
                    case 187 -> 131;
                    case 188 -> 108;
                    case 189 -> 23;
                    case 190 -> 221;
                    case 191 -> 32;
                    case 192 -> 160;
                    case 193 -> 10;
                    case 194 -> 163;
                    case 195 -> 152;
                    case 196 -> 60;
                    case 197 -> 22;
                    case 198 -> 138;
                    case 199 -> 208;
                    case 200 -> 180;
                    case 201 -> 146;
                    case 202 -> 17;
                    case 203 -> 216;
                    case 204 -> 186;
                    case 205 -> 240;
                    case 206 -> 247;
                    case 207 -> 91;
                    case 208 -> 78;
                    case 209 -> 220;
                    case 210 -> 199;
                    case 211 -> 244;
                    case 212 -> 86;
                    case 213 -> 43;
                    case 214 -> 157;
                    case 215 -> 105;
                    case 216 -> 117;
                    case 217 -> 129;
                    case 218 -> 96;
                    case 219 -> 119;
                    case 220 -> 127;
                    case 221 -> 196;
                    case 222 -> 206;
                    case 223 -> 175;
                    case 224 -> 233;
                    case 225 -> 48;
                    case 226 -> 106;
                    case 227 -> 98;
                    case 228 -> 144;
                    case 229 -> 172;
                    case 230 -> 189;
                    case 231 -> 147;
                    case 232 -> 88;
                    case 233 -> 167;
                    case 234 -> 170;
                    case 235 -> 68;
                    case 236 -> 84;
                    case 237 -> 7;
                    case 238 -> 71;
                    case 239 -> 94;
                    case 240 -> 252;
                    case 241 -> 150;
                    case 242 -> 95;
                    case 243 -> 109;
                    case 244 -> 49;
                    case 245 -> 29;
                    case 246 -> 204;
                    case 247 -> 130;
                    case 248 -> 238;
                    case 249 -> 75;
                    case 250 -> 11;
                    case 251 -> 87;
                    case 252 -> 162;
                    case 253 -> 141;
                    case 254 -> 222;
                    default -> 55;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

