/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hunspell;

import com.intellij.hunspell.HunspellBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.NlsActions;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u000f2\b\b\u0001\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/hunspell/HunspellStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "huDictionaryRegex", "Lkotlin/text/Regex;", "property", "", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "notification", "Lcom/intellij/notification/Notification;", "prepareToUninstall", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "onRestartRequired", "Ljava/lang/Runnable;", "action", "label", "run", "Lkotlin/Function0;", "isHungarianInstalled", "", "intellij.hunspell"})
@SourceDebugExtension(value={"SMAP\nHunspellStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HunspellStartupActivity.kt\ncom/intellij/hunspell/HunspellStartupActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1761#3,3:85\n*S KotlinDebug\n*F\n+ 1 HunspellStartupActivity.kt\ncom/intellij/hunspell/HunspellStartupActivity\n*L\n81#1:85,3\n*E\n"})
public final class HunspellStartupActivity
implements ProjectActivity {
    @NotNull
    private final Regex huDictionaryRegex = new Regex("(?:^|.*/)(?:hu\\.dic|hu[-_][A-Z]+\\.dic|hu/index\\.dic)$");
    @NotNull
    private final String property;

    public HunspellStartupActivity() {
        this.property = "hunspell.uninstall.notified";
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        block3: {
            if (PropertiesComponent.getInstance().getBoolean(this.property)) {
                return Unit.INSTANCE;
            }
            if (this.isHungarianInstalled(project)) {
                return Unit.INSTANCE;
            }
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Hunspell");
            if (notificationGroup == null) break block3;
            String string = HunspellBundle.message("notification.uninstallation.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification = notificationGroup.createNotification("", string, NotificationType.INFORMATION);
            if (notification != null) {
                Notification notification2;
                Notification $this$execute_u24lambda_u240 = notification2 = notification;
                boolean bl = false;
                this.getActions($this$execute_u24lambda_u240, project);
                notification2.notify(project);
            }
        }
        return Unit.INSTANCE;
    }

    private final Collection<AnAction> getActions(Notification notification, Project project) {
        List list;
        List $this$getActions_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        String string = HunspellBundle.message("notification.uninstallation.action.got.it", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$getActions_u24lambda_u240.add(this.action(string, (Function0<Unit>)((Function0)() -> HunspellStartupActivity.getActions$lambda$0$0(this, notification))));
        IdeaPluginDescriptor hunspellPlugin = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.getId("hunspell"));
        if (hunspellPlugin instanceof IdeaPluginDescriptorImpl) {
            String string2 = HunspellBundle.message("notification.uninstallation.action.uninstall", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $this$getActions_u24lambda_u240.add(this.action(string2, (Function0<Unit>)((Function0)() -> HunspellStartupActivity.getActions$lambda$0$1(this, hunspellPlugin, project))));
        }
        return list;
    }

    private final void prepareToUninstall(IdeaPluginDescriptorImpl plugin, Runnable onRestartRequired) {
        boolean isRestartRequired = PluginInstaller.prepareToUninstall((IdeaPluginDescriptorImpl)plugin);
        if (isRestartRequired) {
            onRestartRequired.run();
        }
    }

    private final AnAction action(@NlsActions.ActionText String label, Function0<Unit> run) {
        return (AnAction)new DumbAwareAction(label, run){
            final /* synthetic */ Function0<Unit> $run;
            {
                this.$run = $run;
                super($label);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$run.invoke();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isHungarianInstalled(Project project) {
        boolean bl;
        Set set;
        SpellCheckerEngine spellCheckerEngine = SpellCheckerManager.Companion.getInstance(project).getSpellChecker();
        if (spellCheckerEngine != null && (set = spellCheckerEngine.getDictionaryNames()) != null) {
            boolean bl2;
            block5: {
                void $this$any$iv;
                Iterable iterable = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        CharSequence charSequence = it;
                        if (!this.huDictionaryRegex.containsMatchIn(charSequence)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Unit getActions$lambda$0$0(HunspellStartupActivity this$0, Notification $notification) {
        PropertiesComponent.getInstance().setValue(this$0.property, true);
        $notification.expire();
        $notification.hideBalloon();
        return Unit.INSTANCE;
    }

    private static final Unit getActions$lambda$0$1(HunspellStartupActivity this$0, IdeaPluginDescriptor $hunspellPlugin, Project $project) {
        this$0.prepareToUninstall((IdeaPluginDescriptorImpl)$hunspellPlugin, () -> HunspellStartupActivity.getActions$lambda$0$1$0($project));
        return Unit.INSTANCE;
    }

    private static final void getActions$lambda$0$1$0(Project $project) {
        PluginManagerMain.notifyPluginsUpdated((Project)$project);
    }
}

