/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.util;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.twig.TwigFile;
import com.jetbrains.twig.elements.TwigBlockTag;
import com.jetbrains.twig.elements.TwigExtendsTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TwigLookupUtil {
    private static final int MAX_LOOKUP_DEPTH = 5;

    @Nullable
    private static TwigExtendsTag findExtendsTag(PsiFile psiFile) {
        final PsiElement[] foundElement = new PsiElement[1];
        ElementFinder finder = new ElementFinder(element -> element instanceof TwigExtendsTag){

            @Override
            public boolean handleMatch(PsiElement element) {
                foundElement[0] = element;
                return true;
            }
        };
        psiFile.accept((PsiElementVisitor)finder);
        return foundElement[0] instanceof TwigExtendsTag ? (TwigExtendsTag)foundElement[0] : null;
    }

    @Nullable
    public static TwigBlockTag findBaseTag(PsiFile file, String blockIdentifier) {
        final PsiElement[] foundElement = new PsiElement[1];
        ElementFinder finder = new ElementFinder(element -> {
            PsiElement targetIdentifier;
            return element instanceof TwigBlockTag && (targetIdentifier = ((TwigBlockTag)((Object)element)).findIdentifier()) != null && targetIdentifier.getText().equals(blockIdentifier);
        }){

            @Override
            public boolean handleMatch(PsiElement element) {
                foundElement[0] = element;
                return true;
            }
        };
        TwigLookupUtil.lookupExtends(file, finder, 0);
        return (TwigBlockTag)foundElement[0];
    }

    public static void lookupExtends(PsiFile file, ElementFinder finder) {
        TwigLookupUtil.lookupExtends(file, finder, 0);
    }

    private static void lookupExtends(PsiFile file, ElementFinder finder, int currLookupDepth) {
        if (currLookupDepth >= 5) {
            return;
        }
        TwigExtendsTag extendsTag = TwigLookupUtil.findExtendsTag(file);
        if (extendsTag != null) {
            PsiReference[] extendsTagReferences;
            for (PsiReference tagRef : extendsTagReferences = extendsTag.getReferences()) {
                PsiElement resolvedExtends = tagRef.resolve();
                if (!(resolvedExtends instanceof TwigFile)) continue;
                TwigFile targetFile = (TwigFile)resolvedExtends;
                targetFile.accept((PsiElementVisitor)finder);
                if (finder.isDone()) {
                    return;
                }
                TwigLookupUtil.lookupExtends((PsiFile)targetFile, finder, currLookupDepth + 1);
            }
        }
    }

    public static abstract class ElementFinder
    extends PsiRecursiveElementVisitor {
        private final Condition<? super PsiElement> myCondition;
        private boolean myDone = false;

        public ElementFinder(Condition<? super PsiElement> condition) {
            this.myCondition = condition;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ElementFinder.$$$reportNull$$$0(0);
            }
            if (this.myDone) {
                return;
            }
            if (this.myCondition.value((Object)element)) {
                this.myDone = this.handleMatch(element);
                return;
            }
            super.visitElement(element);
        }

        public abstract boolean handleMatch(PsiElement var1);

        public boolean isDone() {
            return this.myDone;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/twig/util/TwigLookupUtil$ElementFinder", "visitElement"));
        }
    }
}

