/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.formatter.ui;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.RightMarginForm;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.twig.TwigFileType;
import com.jetbrains.twig.TwigLanguage;
import com.jetbrains.twig.formatter.TwigFormatterOptions;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class TwigFormatterOptionsPanel
extends CodeStyleAbstractPanel {
    private JPanel myTopPanel;
    private JBCheckBox mySpacesInDelimitersBox;
    private JPanel myPreviewPane;
    private JBCheckBox mySpacesInVarDelimitersBox;
    private JBCheckBox mySpacesInDocDelimitersBox;
    private JPanel myRightMarginPanel;
    private RightMarginForm myRightMarginForm;

    public TwigFormatterOptionsPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPane);
        this.addPanelToWatch(this.myTopPanel);
    }

    protected int getRightMargin() {
        return 40;
    }

    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            TwigFormatterOptionsPanel.$$$reportNull$$$0(0);
        }
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.twig"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        TwigFileType twigFileType = TwigFileType.INSTANCE;
        if (twigFileType == null) {
            TwigFormatterOptionsPanel.$$$reportNull$$$0(1);
        }
        return twigFileType;
    }

    protected String getPreviewText() {
        return "<!DOCTYPE html>\n<html>\n    <body>\n        <div id=\"content\">{% block content %}{% endblock %}</div>\n        <div id=\"footer\">\n            {# footer #}\n            {% block footer %}\n                &copy; Copyright 2011 by <a href=\"http://domain.invalid/\">you</a>.\n            {% endblock %}\n        </div>\n <p>{{ textarea('comment') }}</p>\n    </body>\n</html>";
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            TwigFormatterOptionsPanel.$$$reportNull$$$0(2);
        }
        settings.getCustomSettings(TwigFormatterOptions.class);
        TwigFormatterOptions options = TwigFormatterOptionsPanel.getTwigOptions(settings);
        options.SPACES_INSIDE_DELIMITERS = this.mySpacesInDelimitersBox.isSelected();
        options.SPACES_INSIDE_VARIABLE_DELIMITERS = this.mySpacesInVarDelimitersBox.isSelected();
        options.SPACES_INSIDE_COMMENTS_DELIMITERS = this.mySpacesInDocDelimitersBox.isSelected();
        this.myRightMarginForm.apply(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        TwigFormatterOptions options = TwigFormatterOptionsPanel.getTwigOptions(settings);
        return this.mySpacesInDelimitersBox.isSelected() != options.SPACES_INSIDE_DELIMITERS || this.mySpacesInVarDelimitersBox.isSelected() != options.SPACES_INSIDE_VARIABLE_DELIMITERS || this.mySpacesInDocDelimitersBox.isSelected() != options.SPACES_INSIDE_COMMENTS_DELIMITERS || this.myRightMarginForm.isModified(settings);
    }

    public JComponent getPanel() {
        return this.myTopPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            TwigFormatterOptionsPanel.$$$reportNull$$$0(3);
        }
        TwigFormatterOptions options = TwigFormatterOptionsPanel.getTwigOptions(settings);
        this.mySpacesInDelimitersBox.setSelected(options.SPACES_INSIDE_DELIMITERS);
        this.mySpacesInVarDelimitersBox.setSelected(options.SPACES_INSIDE_VARIABLE_DELIMITERS);
        this.mySpacesInDocDelimitersBox.setSelected(options.SPACES_INSIDE_COMMENTS_DELIMITERS);
        this.myRightMarginForm.reset(settings);
    }

    @NotNull
    private static TwigFormatterOptions getTwigOptions(CodeStyleSettings settings) {
        TwigFormatterOptions options = (TwigFormatterOptions)settings.getCustomSettings(TwigFormatterOptions.class);
        assert (options != null);
        TwigFormatterOptions twigFormatterOptions = options;
        if (twigFormatterOptions == null) {
            TwigFormatterOptionsPanel.$$$reportNull$$$0(4);
        }
        return twigFormatterOptions;
    }

    private void createUIComponents() {
        this.myRightMarginForm = new RightMarginForm((Language)TwigLanguage.INSTANCE, this.getSettings());
        this.myRightMarginPanel = this.myRightMarginForm.getTopPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/formatter/ui/TwigFormatterOptionsPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/formatter/ui/TwigFormatterOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTwigOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySpacesInDelimitersBox = jBCheckBox3 = new JBCheckBox();
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/TwigBundle", TwigFormatterOptionsPanel.class).getString("formatter.options.space.inside.delimiters"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPreviewPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 3, 5, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(5, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySpacesInVarDelimitersBox = jBCheckBox2 = new JBCheckBox();
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/TwigBundle", TwigFormatterOptionsPanel.class).getString("formatter.options.space.inside.variable.delimiters"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = this.myRightMarginPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySpacesInDocDelimitersBox = jBCheckBox = new JBCheckBox();
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/TwigBundle", TwigFormatterOptionsPanel.class).getString("formatter.options.space.inside.comments"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

