/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.twig.TwigBundle;
import com.jetbrains.twig.TwigFileType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TwigConfiguration", storages={@Storage(value="twig.xml")})
public class TwigConfiguration
implements PersistentStateComponent<TwigLexerProperties> {
    private static final TwigConfiguration DEFAULT_INSTANCE = new TwigConfiguration(null);
    @Nullable
    private final Project myProject;
    @Nullable
    private TwigLexerProperties myState;

    public TwigConfiguration(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public TwigLexerProperties getState() {
        TwigLexerProperties twigLexerProperties = this.myState == null ? TwigLexerProperties.DEFAULT : this.myState;
        if (twigLexerProperties == null) {
            TwigConfiguration.$$$reportNull$$$0(0);
        }
        return twigLexerProperties;
    }

    public void loadState(@NotNull TwigLexerProperties state) {
        if (state == null) {
            TwigConfiguration.$$$reportNull$$$0(1);
        }
        this.doApplyState(state, false);
    }

    public void resetFormState(TwigLexerProperties state) {
        this.doApplyState(state, true);
    }

    private void doApplyState(TwigLexerProperties state, boolean reloadFilesIfChanged) {
        this.myState = state;
        if (reloadFilesIfChanged && this.myProject != null) {
            Task.Backgroundable task = new Task.Backgroundable(this, this.myProject, TwigBundle.message("reparsing.twig.files", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    int index;
                    int partCapacity;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(false);
                    Collection twigFiles = (Collection)ReadAction.compute(() -> FileTypeIndex.getFiles((FileType)TwigFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.getProject())));
                    VirtualFile[] filesArray = twigFiles.toArray(VirtualFile.EMPTY_ARRAY);
                    int capacity = 20;
                    for (index = 0; index < filesArray.length && !indicator.isCanceled() && !this.getProject().isDisposed(); index += partCapacity) {
                        indicator.setFraction((double)index / (double)filesArray.length);
                        partCapacity = Math.min(20, filesArray.length - index);
                        VirtualFile[] part = new VirtualFile[partCapacity];
                        System.arraycopy(filesArray, index, part, 0, partCapacity);
                        ApplicationManager.getApplication().invokeAndWait(() -> PsiDocumentManager.getInstance((Project)this.getProject()).reparseFiles(Arrays.asList(part), true));
                    }
                    assert (indicator.isCanceled() || index == filesArray.length);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/twig/TwigConfiguration$1", "run"));
                }
            };
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> TwigConfiguration.lambda$doApplyState$0((Task)task));
        }
    }

    public static TwigConfiguration getInstance(@Nullable Project project) {
        if (project == null) {
            return DEFAULT_INSTANCE;
        }
        return (TwigConfiguration)project.getService(TwigConfiguration.class);
    }

    private static /* synthetic */ void lambda$doApplyState$0(Task task) {
        task.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/TwigConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/TwigConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class TwigLexerProperties {
        @NotNull
        private String myBlockStartDelimiter;
        @NotNull
        private String myBlockEndDelimiter;
        @NotNull
        private String myDocStartDelimiter;
        @NotNull
        private String myDocEndDelimiter;
        @NotNull
        private String myVariableStartDelimiter;
        @NotNull
        private String myVariableEndDelimiter;
        public static final TwigLexerProperties DEFAULT = new TwigLexerProperties("{%", "%}", "{#", "#}", "{{", "}}");

        public TwigLexerProperties() {
            this(TwigLexerProperties.DEFAULT.myBlockStartDelimiter, TwigLexerProperties.DEFAULT.myBlockEndDelimiter, TwigLexerProperties.DEFAULT.myDocStartDelimiter, TwigLexerProperties.DEFAULT.myDocEndDelimiter, TwigLexerProperties.DEFAULT.myVariableStartDelimiter, TwigLexerProperties.DEFAULT.myVariableEndDelimiter);
        }

        public TwigLexerProperties(@NotNull String textBlockStart, @NotNull String textBlockEnd, @NotNull String docStartDelimiter, @NotNull String docEndDelimiter, @NotNull String printStartDelimiter, @NotNull String printEndDelimiter) {
            if (textBlockStart == null) {
                TwigLexerProperties.$$$reportNull$$$0(0);
            }
            if (textBlockEnd == null) {
                TwigLexerProperties.$$$reportNull$$$0(1);
            }
            if (docStartDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(2);
            }
            if (docEndDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(3);
            }
            if (printStartDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(4);
            }
            if (printEndDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(5);
            }
            this.myBlockStartDelimiter = textBlockStart;
            this.myBlockEndDelimiter = textBlockEnd;
            this.myDocStartDelimiter = docStartDelimiter;
            this.myDocEndDelimiter = docEndDelimiter;
            this.myVariableStartDelimiter = printStartDelimiter;
            this.myVariableEndDelimiter = printEndDelimiter;
        }

        @Attribute(value="startBlockDelimiter")
        @NotNull
        public String getBlockStartDelimiter() {
            String string = this.myBlockStartDelimiter;
            if (string == null) {
                TwigLexerProperties.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Attribute(value="endBlockDelimiter")
        @NotNull
        public String getBlockEndDelimiter() {
            String string = this.myBlockEndDelimiter;
            if (string == null) {
                TwigLexerProperties.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Attribute(value="startDocDelimiter")
        @NotNull
        public String getDocStartDelimiter() {
            String string = this.myDocStartDelimiter;
            if (string == null) {
                TwigLexerProperties.$$$reportNull$$$0(8);
            }
            return string;
        }

        public void setDocStartDelimiter(@NotNull String docStartDelimiter) {
            if (docStartDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(9);
            }
            this.myDocStartDelimiter = docStartDelimiter;
        }

        @Attribute(value="endDocDelimiter")
        @NotNull
        public String getDocEndDelimiter() {
            String string = this.myDocEndDelimiter;
            if (string == null) {
                TwigLexerProperties.$$$reportNull$$$0(10);
            }
            return string;
        }

        public void setDocEndDelimiter(@NotNull String docEndDelimiter) {
            if (docEndDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(11);
            }
            this.myDocEndDelimiter = docEndDelimiter;
        }

        @Attribute(value="startVariableDelimiter")
        @NotNull
        public String getVariableStartDelimiter() {
            String string = this.myVariableStartDelimiter;
            if (string == null) {
                TwigLexerProperties.$$$reportNull$$$0(12);
            }
            return string;
        }

        @Attribute(value="endVariableDelimiter")
        @NotNull
        public String getVariableEndDelimiter() {
            String string = this.myVariableEndDelimiter;
            if (string == null) {
                TwigLexerProperties.$$$reportNull$$$0(13);
            }
            return string;
        }

        public void setVariableStartDelimiter(@NotNull String variableStartDelimiter) {
            if (variableStartDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(14);
            }
            this.myVariableStartDelimiter = variableStartDelimiter;
        }

        public void setVariableEndDelimiter(@NotNull String variableEndDelimiter) {
            if (variableEndDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(15);
            }
            this.myVariableEndDelimiter = variableEndDelimiter;
        }

        public void setBlockStartDelimiter(@NotNull String blockStartDelimiter) {
            if (blockStartDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(16);
            }
            this.myBlockStartDelimiter = blockStartDelimiter;
        }

        public void setBlockEndDelimiter(@NotNull String blockEndDelimiter) {
            if (blockEndDelimiter == null) {
                TwigLexerProperties.$$$reportNull$$$0(17);
            }
            this.myBlockEndDelimiter = blockEndDelimiter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwigLexerProperties that = (TwigLexerProperties)o;
            return Objects.equals(this.myBlockStartDelimiter, that.myBlockStartDelimiter) && Objects.equals(this.myBlockEndDelimiter, that.myBlockEndDelimiter) && Objects.equals(this.myDocStartDelimiter, that.myDocStartDelimiter) && Objects.equals(this.myDocEndDelimiter, that.myDocEndDelimiter) && Objects.equals(this.myVariableStartDelimiter, that.myVariableStartDelimiter) && Objects.equals(this.myVariableEndDelimiter, that.myVariableEndDelimiter);
        }

        public int hashCode() {
            return Objects.hash(this.myBlockStartDelimiter, this.myBlockEndDelimiter, this.myDocStartDelimiter, this.myDocEndDelimiter, this.myVariableStartDelimiter, this.myVariableEndDelimiter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 10, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBlockStart";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBlockEnd";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docStartDelimiter";
                    break;
                }
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docEndDelimiter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printStartDelimiter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printEndDelimiter";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/twig/TwigConfiguration$TwigLexerProperties";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableStartDelimiter";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableEndDelimiter";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockStartDelimiter";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockEndDelimiter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/twig/TwigConfiguration$TwigLexerProperties";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlockStartDelimiter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlockEndDelimiter";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocStartDelimiter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocEndDelimiter";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariableStartDelimiter";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariableEndDelimiter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setDocStartDelimiter";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setDocEndDelimiter";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "setVariableStartDelimiter";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setVariableEndDelimiter";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setBlockStartDelimiter";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "setBlockEndDelimiter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 10, 12, 13 -> new IllegalStateException(string);
            };
        }
    }
}

