/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.dql.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpFqnPrefixMatcher;
import com.jetbrains.php.dql.DqlLanguage;
import com.jetbrains.php.dql.DqlTypes;
import com.jetbrains.php.dql.lexer.DqlLexer;
import com.jetbrains.php.dql.psi.DqlFullyQualifiedName;
import com.jetbrains.php.dql.psi.DqlNamespaceReferenceExpression;
import com.jetbrains.php.dql.psi.impl.DqlLiteralImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DqlCompletionContributor
extends CompletionContributor {
    public static final PsiElementPattern.Capture<PsiElement> IN_DQL_STRING_EXPRESSION = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(DqlLiteralImpl.class);

    public DqlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage(DqlLanguage.INSTANCE)).andNot(IN_DQL_STRING_EXPRESSION), new DqlKeywordCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage(DqlLanguage.INSTANCE)).withSuperParent(2, DqlFullyQualifiedName.class), new DqlFullyQualifiedNameCompletionContributor());
    }

    @NotNull
    private static LookupElementBuilder createLookupElement(PhpClass e, boolean hasNamespaceReferenceBefore) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(hasNamespaceReferenceBefore ? e.getName() : PhpLangUtil.toPresentableFQN((String)e.getFQN()))).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Class));
        if (lookupElementBuilder == null) {
            DqlCompletionContributor.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/dql/completion/DqlCompletionContributor", "createLookupElement"));
    }

    static final class DqlKeywordCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        public static final Set<IElementType> NOT_KEYWORD_CONTEXT_ELEMENT_TYPES = Set.of(DqlTypes.DQL_STRING, DqlTypes.DQL_NUMBER, DqlTypes.DQL_BOOLEAN, DqlTypes.DQL_CHAR, DqlLexer.DQL_ID, DqlTypes.DQL_FLOAT);
        private static final Set<String> ourFunctionsWithParens = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("AVG", "MAX", "MIN", "SUM", "COUNT", "LENGTH", "LOCALE", "ABS", "SQRT", "MOD", "SIZE", "DATE_DIFF", "BIT_AND", "BIT_OR", "DATE_ADD", "DATE_SUB", "CONCAT", "SUBSTRING", "TRIM", "LOWER", "UPPER", "IDENTITY"));

        DqlKeywordCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                DqlKeywordCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DqlKeywordCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                DqlKeywordCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String keyword : DqlKeywordCompletionProvider.getKeywords(parameters.getPosition())) {
                result.addElement(DqlKeywordCompletionProvider.createKeywordLookupElement(keyword));
            }
        }

        private static Collection<String> getKeywords(PsiElement position) {
            PsiFile dqlFile = position.getContainingFile();
            String fragment = InjectedLanguageUtilBase.getUnescapedText((PsiFile)dqlFile, null, (PsiElement)position);
            boolean empty = StringUtil.isEmptyOrSpaces((String)fragment);
            String text = empty ? "IntellijIdeaRulezzz " : fragment;
            PsiFile file = PsiFileFactory.getInstance((Project)dqlFile.getProject()).createFileFromText("a.ql", DqlLanguage.INSTANCE, (CharSequence)text, true, false);
            int completionOffset = empty ? 0 : fragment.length();
            GeneratedParserUtilBase.CompletionState state = new GeneratedParserUtilBase.CompletionState(completionOffset){

                @Nullable
                public String convertItem(Object o) {
                    if (o instanceof IElementType[]) {
                        return super.convertItem(o);
                    }
                    String text = o instanceof IElementType && !NOT_KEYWORD_CONTEXT_ELEMENT_TYPES.contains((IElementType)o) ? o.toString() : null;
                    return text != null && !text.isEmpty() && StringUtil.isJavaIdentifierStart((char)text.charAt(0)) ? text : null;
                }
            };
            file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, (Object)state);
            TreeUtil.ensureParsed((ASTNode)file.getNode());
            return state.items;
        }

        @NotNull
        private static LookupElement createKeywordLookupElement(String keyword) {
            LookupElementBuilder builder = LookupElementBuilder.create((String)keyword).bold();
            if (ourFunctionsWithParens.contains(keyword)) {
                LookupElementBuilder lookupElementBuilder = builder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS).withTailText("()").withIcon(PhpIcons.FUNCTION);
                if (lookupElementBuilder == null) {
                    DqlKeywordCompletionProvider.$$$reportNull$$$0(3);
                }
                return lookupElementBuilder;
            }
            TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)builder.withCaseSensitivity(false), (TailType)TailTypes.spaceType());
            if (tailTypeDecorator == null) {
                DqlKeywordCompletionProvider.$$$reportNull$$$0(4);
            }
            return tailTypeDecorator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/dql/completion/DqlCompletionContributor$DqlKeywordCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/dql/completion/DqlCompletionContributor$DqlKeywordCompletionProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createKeywordLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class DqlFullyQualifiedNameCompletionContributor
    extends CompletionProvider<CompletionParameters> {
        private DqlFullyQualifiedNameCompletionContributor() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet resultSet) {
            if (parameters == null) {
                DqlFullyQualifiedNameCompletionContributor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DqlFullyQualifiedNameCompletionContributor.$$$reportNull$$$0(1);
            }
            if (resultSet == null) {
                DqlFullyQualifiedNameCompletionContributor.$$$reportNull$$$0(2);
            }
            PhpIndex phpIndex = PhpIndex.getInstance((Project)parameters.getPosition().getProject());
            DqlFullyQualifiedName position = (DqlFullyQualifiedName)PhpPsiUtil.getParentOfClass((PsiElement)parameters.getPosition().getOriginalElement(), DqlFullyQualifiedName.class);
            if (position == null) {
                return;
            }
            DqlNamespaceReferenceExpression namespaceReferenceExpression = position.getNamespaceReferenceExpression();
            boolean hasNamespaceReferenceBefore = namespaceReferenceExpression != null && !namespaceReferenceExpression.getText().isEmpty();
            Predicate<PhpClass> predicate = aClass -> !hasNamespaceReferenceBefore || PhpCompletionUtil.hasNamespace((String)("\\" + namespaceReferenceExpression.getText()), (boolean)false, (PhpNamedElement)aClass);
            PrefixMatcher resultSetPrefixMatcher = resultSet.getPrefixMatcher();
            if (!PhpCompletionUtil.addClasses((PhpIndex)phpIndex, (PrefixMatcher)(hasNamespaceReferenceBefore ? resultSetPrefixMatcher : new PhpFqnPrefixMatcher(resultSetPrefixMatcher)), predicate, c -> resultSet.addElement((LookupElement)DqlCompletionContributor.createLookupElement(c, hasNamespaceReferenceBefore)))) {
                PhpCompletionContributor.handleOverflow((CompletionResultSet)resultSet);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultSet";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/dql/completion/DqlCompletionContributor$DqlFullyQualifiedNameCompletionContributor";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

