/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.presentation;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class EdgeInfo {
    @Nullable
    @NlsSafe
    private final String mySrc;
    @Nullable
    @NlsSafe
    private final String myTrg;
    @Nullable
    @NlsSafe
    private final String myRelationshipName;
    @NotNull
    private final List<Couple<Double>> myPoints;

    public EdgeInfo(@NotNull DiagramEdge<?> edge, @NotNull DiagramBuilder builder) {
        if (edge == null) {
            EdgeInfo.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            EdgeInfo.$$$reportNull$$$0(1);
        }
        DiagramProvider<?> provider = builder.getProvider();
        DiagramVfsResolver<?> resolver = provider.getVfsResolver();
        this.mySrc = resolver.getQualifiedName(edge.getSource().getIdentifyingElement());
        this.myTrg = edge instanceof DiagramNoteEdge ? null : resolver.getQualifiedName(edge.getTarget().getIdentifyingElement());
        this.myRelationshipName = edge.getRelationship().toString();
        EdgeLayout edgeLayout = builder.getGraph().getEdgeLayout((Object)builder.getEdge(edge));
        YPoint sp = edgeLayout.getSourcePoint();
        this.myPoints = new ArrayList<Couple<Double>>();
        this.myPoints.add((Couple<Double>)Couple.of((Object)sp.getX(), (Object)sp.getY()));
        for (int i = 0; i < edgeLayout.pointCount(); ++i) {
            YPoint p = edgeLayout.getPoint(i);
            this.myPoints.add((Couple<Double>)Couple.of((Object)p.getX(), (Object)p.getY()));
        }
        YPoint tp = edgeLayout.getTargetPoint();
        this.myPoints.add((Couple<Double>)Couple.of((Object)tp.getX(), (Object)tp.getY()));
    }

    public EdgeInfo(@Nullable @NlsSafe String src, @Nullable @NlsSafe String trg, @Nullable @NlsSafe String relationshipName, @NotNull List<Couple<Double>> points) {
        if (points == null) {
            EdgeInfo.$$$reportNull$$$0(2);
        }
        this.mySrc = src;
        this.myTrg = trg;
        this.myRelationshipName = relationshipName;
        this.myPoints = points;
    }

    @Nullable
    public String getSrc() {
        return this.mySrc;
    }

    @Nullable
    public String getTrg() {
        return this.myTrg;
    }

    @Nullable
    public String getRelationshipName() {
        return this.myRelationshipName;
    }

    @NotNull
    public List<Couple<Double>> getPoints() {
        List<Couple<Double>> list = Collections.unmodifiableList(this.myPoints);
        if (list == null) {
            EdgeInfo.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeInfo info = (EdgeInfo)o;
        return Objects.equals(this.mySrc, info.mySrc) && Objects.equals(this.myTrg, info.myTrg) && Objects.equals(this.myRelationshipName, info.myRelationshipName) && this.myPoints.equals(info.myPoints);
    }

    public int hashCode() {
        return Objects.hash(this.mySrc, this.myTrg, this.myRelationshipName, this.myPoints);
    }

    public String toString() {
        return "EdgeInfo{mySrc='" + this.mySrc + "', myTrg='" + this.myTrg + "', myRelationshipName='" + this.myRelationshipName + "', myPoints=" + String.valueOf(this.myPoints) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/presentation/EdgeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/presentation/EdgeInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

