/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.parser;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.blade.parser.BladeDirectiveStack;
import com.jetbrains.php.blade.psi.BladeDirectiveElementType;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladePsiDirectiveParameter;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class BladeDirectiveStructureData {
    public static final MultiMap<IElementType, IElementType> CLOSING_DIRECTIVES = new MultiMap();
    public static final MultiMap<IElementType, IElementType> CONTINUING_DIRECTIVES = new MultiMap();

    public static boolean isToBeClosed(IElementType type, BladePsiDirective element) {
        if (CLOSING_DIRECTIVES.get((Object)type).isEmpty()) {
            return false;
        }
        if (type == BladeTokenTypes.SLOT_DIRECTIVE) {
            return !element.hasMultipleParameters();
        }
        if (type == BladeTokenTypes.LANG_DIRECTIVE) {
            BladePsiDirectiveParameter parameter = element.getParameter();
            if (parameter == null) {
                return true;
            }
            String text = parameter.getParameterText();
            return text != null && text.startsWith("[");
        }
        if (type == BladeTokenTypes.SECTION_DIRECTIVE && BladeDirectiveStack.isInlinedSection(element)) {
            return false;
        }
        if (type == BladeTokenTypes.PUSH_DIRECTIVE && BladeDirectiveStack.isInlinedPush(element)) {
            return false;
        }
        if (type == BladeTokenTypes.PREPEND_DIRECTIVE && BladeDirectiveStack.isInlinedPrepend(element)) {
            return false;
        }
        if (type == BladeTokenTypes.PREPENDONCE_DIRECTIVE && BladeDirectiveStack.isInlinedPrependOnce(element)) {
            return false;
        }
        return type != BladeTokenTypes.PHP_DIRECTIVE || element.getParameter() == null;
    }

    public static boolean isContinued(IElementType type) {
        return !CONTINUING_DIRECTIVES.get((Object)type).isEmpty();
    }

    public static boolean continues(IElementType type, IElementType previousType) {
        return CONTINUING_DIRECTIVES.get((Object)previousType).contains(type);
    }

    public static boolean isContinuing(IElementType type, BladePsiDirective element) {
        if (!CONTINUING_DIRECTIVES.values().contains(type)) {
            return false;
        }
        if (type == BladeTokenTypes.EMPTY_DIRECTIVE) {
            BladePsiDirectiveParameter parameter = element.getParameter();
            return parameter == null;
        }
        return true;
    }

    public static boolean closes(IElementType type, IElementType previousType) {
        return CLOSING_DIRECTIVES.get((Object)previousType).contains(type);
    }

    public static boolean isClosing(IElementType type) {
        return CLOSING_DIRECTIVES.values().contains(type);
    }

    static {
        List<BladeDirectiveElementType> ifDirectives = Arrays.asList(BladeTokenTypes.IF_DIRECTIVE, BladeTokenTypes.UNLESS_DIRECTIVE, BladeTokenTypes.CAN_DIRECTIVE, BladeTokenTypes.CANNOT_DIRECTIVE, BladeTokenTypes.HASSECTION_DIRECTIVE, BladeTokenTypes.ISSET_DIRECTIVE, BladeTokenTypes.EMPTY_DIRECTIVE, BladeTokenTypes.AUTH_DIRECTIVE, BladeTokenTypes.GUEST_DIRECTIVE, BladeTokenTypes.CANANY_DIRECTIVE);
        List<BladeDirectiveElementType> elseIfDirectives = Arrays.asList(BladeTokenTypes.ELSEIF_DIRECTIVE, BladeTokenTypes.ELSECAN_DIRECTIVE, BladeTokenTypes.ELSECANNOT_DIRECTIVE, BladeTokenTypes.ELSE_AUTH_DIRECTIVE, BladeTokenTypes.ELSE_GUEST_DIRECTIVE, BladeTokenTypes.ELSECANANY_DIRECTIVE);
        List<BladeDirectiveElementType> elseDirectives = Collections.singletonList(BladeTokenTypes.ELSE_DIRECTIVE);
        List<BladeDirectiveElementType> endIfDirectives = Arrays.asList(BladeTokenTypes.ENDIF_DIRECTIVE, BladeTokenTypes.ENDUNLESS_DIRECTIVE, BladeTokenTypes.ENDCAN_DIRECTIVE, BladeTokenTypes.ENDCANNOT_DIRECTIVE, BladeTokenTypes.ENDISSET_DIRECTIVE, BladeTokenTypes.ENDEMPTY_DIRECTIVE, BladeTokenTypes.ENDAUTH_DIRECTIVE, BladeTokenTypes.ENDGUEST_DIRECTIVE, BladeTokenTypes.ENDCANANY_DIRECTIVE);
        for (BladeDirectiveElementType ifDirective : ifDirectives) {
            CLOSING_DIRECTIVES.putValues((Object)ifDirective, endIfDirectives);
            CONTINUING_DIRECTIVES.putValues((Object)ifDirective, elseDirectives);
            CONTINUING_DIRECTIVES.putValues((Object)ifDirective, elseIfDirectives);
        }
        for (BladeDirectiveElementType elseIfDirective : elseIfDirectives) {
            CLOSING_DIRECTIVES.putValues((Object)elseIfDirective, endIfDirectives);
            CONTINUING_DIRECTIVES.putValues((Object)elseIfDirective, elseDirectives);
            CONTINUING_DIRECTIVES.putValues((Object)elseIfDirective, elseIfDirectives);
        }
        for (BladeDirectiveElementType elseDirective : elseDirectives) {
            CLOSING_DIRECTIVES.putValues((Object)elseDirective, endIfDirectives);
        }
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.FOREACH_DIRECTIVE, (Object)BladeTokenTypes.ENDFOREACH_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.FOR_DIRECTIVE, (Object)BladeTokenTypes.ENDFOR_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.WHILE_DIRECTIVE, (Object)BladeTokenTypes.ENDWHILE_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.FORELSE_DIRECTIVE, (Object)BladeTokenTypes.ENDFORELSE_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.EMPTY_DIRECTIVE, (Object)BladeTokenTypes.ENDFORELSE_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.LANG_DIRECTIVE, (Object)BladeTokenTypes.ENDLANG_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.SLOT_DIRECTIVE, (Object)BladeTokenTypes.ENDSLOT_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.COMPONENT_DIRECTIVE, (Object)BladeTokenTypes.ENDCOMPONENT_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.COMPONENT_DIRECTIVE, (Object)BladeTokenTypes.ENDCOMPONENT_CLASS_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.COMPONENT_FIRST_DIRECTIVE, (Object)BladeTokenTypes.ENDCOMPONENT_FIRST_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.ENV_DIRECTIVE, (Object)BladeTokenTypes.ENDENV_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.PRODUCTION_DIRECTIVE, (Object)BladeTokenTypes.ENDPRODUCTION_DIRECTIVE);
        for (IElementType type : BladeTokenSets.CLOSING_SECTION_DIRECTIVES.getTypes()) {
            CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.SECTION_DIRECTIVE, (Object)type);
        }
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.VERBATIM_DIRECTIVE, (Object)BladeTokenTypes.ENDVERBATIM_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.SWITCH_DIRECTIVE, (Object)BladeTokenTypes.ENDSWITCH_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.PHP_DIRECTIVE, (Object)BladeTokenTypes.ENDPHP_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.PUSH_DIRECTIVE, (Object)BladeTokenTypes.ENDPUSH_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.PUSHIF_DIRECTIVE, (Object)BladeTokenTypes.ENDPUSHIF_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.PUSHONCE_DIRECTIVE, (Object)BladeTokenTypes.ENDPUSHONCE_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.PREPEND_DIRECTIVE, (Object)BladeTokenTypes.ENDPREPEND_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.PREPENDONCE_DIRECTIVE, (Object)BladeTokenTypes.ENDPREPENDONCE_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.SECTION_MISSING_DIRECTIVE, (Object)BladeTokenTypes.ENDIF_DIRECTIVE);
        CONTINUING_DIRECTIVES.putValue((Object)BladeTokenTypes.FORELSE_DIRECTIVE, (Object)BladeTokenTypes.EMPTY_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.ONCE_DIRECTIVE, (Object)BladeTokenTypes.ENDONCE_DIRECTIVE);
        CLOSING_DIRECTIVES.putValue((Object)BladeTokenTypes.FRAGMENT_DIRECTIVE, (Object)BladeTokenTypes.ENDFRAGMENT_DIRECTIVE);
    }
}

