/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.inspections.filter;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.blade.BladeLanguage;
import com.jetbrains.php.blade.inspections.filter.BladePhpQuickFixesFilter;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladePsiDirectiveParameter;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladePsiPhpBlock;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;
import com.jetbrains.php.lang.inspections.PhpFullyQualifiedNameUsageInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedVariableInspection;
import com.jetbrains.php.lang.inspections.PhpUnnecessaryFullyQualifiedNameInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladePhpInspectionSuppressor
implements InspectionSuppressor {
    private static final List<String> SUPPRESSED_PHP_INSPECTIONS = Arrays.asList(new PhpUndefinedVariableInspection().getID(), new PhpUndefinedClassInspection().getID());
    private static final List<String> SUPPRESSED_IN_CUSTOM_INJECTIONS = Arrays.asList(new PhpFullyQualifiedNameUsageInspection().getID(), new PhpUnnecessaryFullyQualifiedNameInspection().getID());

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            BladePhpInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            BladePhpInspectionSuppressor.$$$reportNull$$$0(1);
        }
        if (toolId.startsWith("Php")) {
            List<TextRange> nonEditableFragments = BladePhpInspectionSuppressor.getNonEditableFragments(element.getContainingFile());
            if (ContainerUtil.exists(nonEditableFragments, f -> f.intersectsStrict(element.getTextRange()))) {
                return true;
            }
            if (SUPPRESSED_IN_CUSTOM_INJECTIONS.contains(toolId) && BladePhpInspectionSuppressor.isCustomInjectionInBlade(element)) {
                return true;
            }
            if (SUPPRESSED_PHP_INSPECTIONS.contains(toolId)) {
                if (element instanceof BladeFileImpl || element instanceof BladePsiLanguageInjectionHost) {
                    return false;
                }
                PsiElement bladeElement = BladePhpQuickFixesFilter.getBladeElement(element);
                if (BladeTokenTypes.TEMPLATE_HTML_TEXT == PsiUtilCore.getElementType((PsiElement)bladeElement)) {
                    return true;
                }
                BladeTranslatableElement bladeTranslatableElement = (BladeTranslatableElement)PhpPsiUtil.getParentOfClass((PsiElement)bladeElement, BladeTranslatableElement.class);
                if (bladeTranslatableElement == null || bladeTranslatableElement instanceof BladePsiPhpBlock) {
                    return false;
                }
                if (BladeElementTypes.PHP_FRAGMENT == PsiUtilCore.getElementType((PsiElement)bladeTranslatableElement)) {
                    return false;
                }
                BladePsiDirectiveParameter directiveParameter = (BladePsiDirectiveParameter)ObjectUtils.tryCast((Object)((Object)bladeTranslatableElement), BladePsiDirectiveParameter.class);
                return directiveParameter == null || directiveParameter.getDirectiveElementType() != BladeTokenTypes.PHP_DIRECTIVE;
            }
        }
        return false;
    }

    public static boolean isCustomInjectionInBlade(@NotNull PsiElement element) {
        InjectedLanguageManager injectionManager;
        List allFiles;
        if (element == null) {
            BladePhpInspectionSuppressor.$$$reportNull$$$0(2);
        }
        if (!ContainerUtil.exists((Iterable)(allFiles = (injectionManager = InjectedLanguageManager.getInstance((Project)element.getProject())).getTopLevelFile(element).getViewProvider().getAllFiles()), f -> BladeLanguage.INSTANCE.equals(f.getLanguage()))) {
            return false;
        }
        PsiLanguageInjectionHost injectionHost = injectionManager.getInjectionHost(element);
        return injectionHost != null && !(injectionHost instanceof BladePsiLanguageInjectionHost);
    }

    public static List<TextRange> getNonEditableFragments(@NotNull PsiFile file) {
        Document document;
        DocumentWindow documentWindow;
        if (file == null) {
            BladePhpInspectionSuppressor.$$$reportNull$$$0(3);
        }
        if ((documentWindow = (DocumentWindow)ObjectUtils.tryCast((Object)(document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file.getContainingFile())), DocumentWindow.class)) == null) {
            return Collections.emptyList();
        }
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)file.getProject());
        return (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)injectionManager.getNonEditableFragments(documentWindow), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            BladePhpInspectionSuppressor.$$$reportNull$$$0(4);
        }
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            BladePhpInspectionSuppressor.$$$reportNull$$$0(5);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/inspections/filter/BladePhpInspectionSuppressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/inspections/filter/BladePhpInspectionSuppressor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCustomInjectionInBlade";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNonEditableFragments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

