/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.inspections.filter;

import com.intellij.codeInsight.daemon.impl.analysis.XmlUnboundNsPrefixInspection;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.CheckEmptyTagInspection;
import com.jetbrains.php.blade.BladeLanguage;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeHtmlInspectionSuppressor
implements InspectionSuppressor {
    private static final List<String> SUPPRESSED_INSPECTIONS = Arrays.asList(new CheckEmptyTagInspection().getID(), new HtmlUnknownTagInspection().getID());
    private static final List<String> ALWAYS_SUPPRESSED_INSPECTIONS = List.of(new XmlUnboundNsPrefixInspection().getID());

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            BladeHtmlInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            BladeHtmlInspectionSuppressor.$$$reportNull$$$0(1);
        }
        if (ALWAYS_SUPPRESSED_INSPECTIONS.contains(toolId)) {
            return true;
        }
        if (!SUPPRESSED_INSPECTIONS.contains(toolId)) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (file == null || !file.getViewProvider().hasLanguage(BladeLanguage.INSTANCE)) {
            return false;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        return xmlTag != null && xmlTag.getName().startsWith("x-");
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            BladeHtmlInspectionSuppressor.$$$reportNull$$$0(2);
        }
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            BladeHtmlInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/inspections/filter/BladeHtmlInspectionSuppressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/inspections/filter/BladeHtmlInspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

