/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.blade.parser.BladeDirectiveStructureData;
import com.jetbrains.php.blade.psi.BladeDirectiveElementType;
import com.jetbrains.php.blade.psi.BladeDirectivePsiImpl;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BladeDirectiveLookupElement
extends LookupElement {
    static final Key<Object> DIRECTIVE_LOOKUP_USER_DATA_MARKER_KEY = new Key("BLADE_DIRECTIVE_COMPLETION_LOOKUP_ELEMENT_MARKER");
    private final String myDirective;
    private final CompletionParameters myParameters;
    private final boolean myHasAt;
    private final boolean myIsParametrized;
    private final Set<String> myAllLookupStrings;
    private final LookupElementPresentation myPresentation;
    @Nullable
    private final BladeDirectiveElementType myCloseDirective;
    private final boolean myIsOpeningMissed;

    BladeDirectiveLookupElement(@NotNull String directive, @NotNull CompletionParameters parameters, @NotNull List<BladePsiDirective> missingOpeningDirectives, boolean hasAt, boolean isParametrized) {
        if (directive == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(1);
        }
        if (missingOpeningDirectives == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(2);
        }
        this(directive, parameters, missingOpeningDirectives, BladeDirectiveLookupElement.getCloseDirective(directive), hasAt, isParametrized);
    }

    BladeDirectiveLookupElement(@NotNull String directive, @NotNull CompletionParameters parameters, @NotNull List<BladePsiDirective> missingOpeningDirectives, @Nullable BladeDirectiveElementType closeDirective, boolean hasAt, boolean isParametrized) {
        if (directive == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(4);
        }
        if (missingOpeningDirectives == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(5);
        }
        this.myPresentation = new LookupElementPresentation();
        this.myDirective = directive;
        this.myParameters = parameters;
        this.myHasAt = hasAt;
        this.myIsParametrized = isParametrized;
        this.myPresentation.setItemTextBold(true);
        this.myAllLookupStrings = ContainerUtil.newHashSet((Object[])new String[]{this.myDirective, directive.substring(1)});
        this.myCloseDirective = closeDirective;
        this.myIsOpeningMissed = ContainerUtil.exists(missingOpeningDirectives, d -> d.getDirectiveElementType().equals((Object)this.myCloseDirective));
        if (this.myCloseDirective != null && !this.myIsOpeningMissed) {
            this.myPresentation.appendTailText("..." + this.myCloseDirective.getText(), true);
        }
        this.putUserData(DIRECTIVE_LOOKUP_USER_DATA_MARKER_KEY, new Object());
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(6);
        }
        presentation.copyFrom(this.myPresentation);
        super.renderElement(presentation);
    }

    @NotNull
    public String getLookupString() {
        String string = this.myDirective;
        if (string == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(8);
        }
        return set;
    }

    void addLookupString(String lookupString) {
        this.myAllLookupStrings.add(lookupString);
    }

    @NotNull
    public Object getObject() {
        String string = this.myDirective;
        if (string == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        int atOffset;
        if (context == null) {
            BladeDirectiveLookupElement.$$$reportNull$$$0(10);
        }
        if (this.myHasAt && (atOffset = context.getStartOffset() - 1) >= 0) {
            context.getEditor().getDocument().deleteString(atOffset, atOffset + 1);
        }
        if (this.myIsParametrized) {
            if (context.getCompletionChar() == '(') {
                context.setAddCompletionChar(false);
            }
            if (!PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)"(")) {
                boolean isClosed = PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)")");
                PhpInsertHandlerUtil.insertStringAtCaret((Editor)context.getEditor(), (String)(isClosed ? "(" : "()"));
                if (!isClosed) {
                    context.getEditor().getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                }
            } else if (PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)"()")) {
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            } else {
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                if (!PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)")")) {
                    PhpInsertHandlerUtil.insertStringAtCaret((Editor)context.getEditor(), (String)")");
                    context.getEditor().getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                }
            }
        }
        if (this.myCloseDirective != null && !this.myIsOpeningMissed) {
            int caretOffset = context.getEditor().getCaretModel().getOffset();
            if (this.myIsParametrized) {
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            }
            PhpInsertHandlerUtil.insertStringAtCaret((Editor)context.getEditor(), (String)(" " + this.myCloseDirective.getText()));
            context.getEditor().getCaretModel().moveToOffset(caretOffset);
        }
        context.commitDocument();
        PsiFile file = context.getFile();
        PsiElement elementAtCaret = file.findElementAt(context.getEditor().getCaretModel().getOffset() - 1);
        PsiElement elementToAllign = BladeDirectiveLookupElement.getElementToAlign(elementAtCaret);
        if (elementToAllign != null) {
            CodeStyleManager.getInstance((Project)context.getProject()).adjustLineIndent(file, elementToAllign.getTextOffset());
        }
    }

    @Nullable
    private static BladeDirectiveElementType getCloseDirective(String directive) {
        if (BladeTokenTypes.IF_DIRECTIVE.getText().equals(directive)) {
            return BladeTokenTypes.ENDIF_DIRECTIVE;
        }
        List<IElementType> openDirectives = BladeDirectiveStructureData.CLOSING_DIRECTIVES.keySet().stream().filter(d -> ((BladeDirectiveElementType)((Object)d)).getText().equals(directive)).limit(2L).toList();
        if (openDirectives.size() != 1) {
            return null;
        }
        Collection closingDirectives = BladeDirectiveStructureData.CLOSING_DIRECTIVES.get((Object)openDirectives.get(0));
        if (closingDirectives.size() != 1) {
            return null;
        }
        return (BladeDirectiveElementType)((Object)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem((Collection)closingDirectives), BladeDirectiveElementType.class));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BladeDirectiveLookupElement element = (BladeDirectiveLookupElement)((Object)o);
        return this.myHasAt == element.myHasAt && this.myIsParametrized == element.myIsParametrized && this.myIsOpeningMissed == element.myIsOpeningMissed && Objects.equals(this.myDirective, element.myDirective) && Objects.equals(this.myParameters, element.myParameters) && Objects.equals(this.myAllLookupStrings, element.myAllLookupStrings) && Objects.equals(this.myPresentation, element.myPresentation) && Objects.equals((Object)this.myCloseDirective, (Object)element.myCloseDirective);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myDirective, this.myParameters, this.myHasAt, this.myIsParametrized, this.myAllLookupStrings, this.myPresentation, this.myCloseDirective, this.myIsOpeningMissed});
    }

    private static PsiElement getElementToAlign(@Nullable PsiElement elementAtCaret) {
        if (elementAtCaret != null) {
            PsiElement parentOfParent;
            if (BladeDirectiveStructureData.CLOSING_DIRECTIVES.containsScalarValue((Object)elementAtCaret.getNode().getElementType()) || BladeDirectiveStructureData.CONTINUING_DIRECTIVES.containsScalarValue((Object)elementAtCaret.getNode().getElementType())) {
                return elementAtCaret;
            }
            PsiElement parent = elementAtCaret.getParent();
            PsiElement psiElement = parentOfParent = parent != null ? parent.getParent() : null;
            if (parentOfParent instanceof BladeDirectivePsiImpl && BladeDirectiveStructureData.CONTINUING_DIRECTIVES.containsScalarValue((Object)((BladeDirectivePsiImpl)parentOfParent).getDirectiveElementType())) {
                return parentOfParent;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingOpeningDirectives";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/completion/BladeDirectiveLookupElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/completion/BladeDirectiveLookupElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

