/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker.ui;

import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.remote.DockerInterpreterContainerSettingsEditorDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.remote.docker.PhpDockerContainerSettingsManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpProjectConfigComponentProvider;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterConfigurationForm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PhpDockerContainerComponentProvider
extends PhpProjectConfigComponentProvider {
    private static final Logger LOG = Logger.getInstance(PhpDockerContainerComponentProvider.class);

    @NotNull
    public PhpProjectConfigComponentProvider.PhpProjectConfigComponent create(@NotNull Project project) {
        if (project == null) {
            PhpDockerContainerComponentProvider.$$$reportNull$$$0(0);
        }
        return new PhpDockerContainerComponent(project);
    }

    public boolean isChildComponent(@NotNull PhpProjectConfigComponentProvider.PhpProjectConfigComponent component) {
        if (component == null) {
            PhpDockerContainerComponentProvider.$$$reportNull$$$0(1);
        }
        return component instanceof PhpDockerContainerComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/docker/ui/PhpDockerContainerComponentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isChildComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PhpDockerContainerComponent
    extends PhpProjectConfigComponentProvider.PhpProjectConfigComponent {
        private final Project myProject;
        private String myInterpreterId;
        private final TextFieldWithBrowseButton myContainerSettingsField;
        private RemoteServer<?> myCurrentServer;
        private DockerContainerSettings myContainerSettings;

        PhpDockerContainerComponent(@NotNull Project project) {
            if (project == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myContainerSettingsField = new TextFieldWithBrowseButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DockerInterpreterContainerSettingsEditorDialog dialog = new DockerInterpreterContainerSettingsEditorDialog(myCurrentServer, myContainerSettings);
                    if (dialog.showAndGet()) {
                        myContainerSettingsField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)myContainerSettings));
                        if (StringUtil.isNotEmpty((String)myInterpreterId)) {
                            PhpDockerContainerSettingsManager.getInstance(myProject).setSettings(myInterpreterId, myContainerSettings);
                            PhpRemoteInterpreterConfigurationForm.fireChanges((Project)myProject);
                        }
                    }
                }
            });
            this.myContainerSettingsField.getTextField().setEditable(false);
            if (project.isDefault()) {
                this.myContainerSettingsField.setEnabled(false);
                this.myContainerSettingsField.setText(PhpBundle.message((String)"PhpProjectConfigurable.docker.default.project.error.tooltip", (Object[])new Object[0]));
            }
            this.init((JComponent)this.myContainerSettingsField, PhpBundle.message((String)"label.docker.container", (Object[])new Object[0]));
        }

        public boolean isAvailable(@NotNull PhpRemoteSdkAdditionalData data) {
            if (data == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(1);
            }
            return data.getRemoteConnectionType() == DockerCredentialsType.getInstance();
        }

        public void onInterpreterChange(@NotNull String interpreterId, @NotNull PhpRemoteSdkAdditionalData data) {
            if (interpreterId == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(2);
            }
            if (data == null) {
                PhpDockerContainerComponent.$$$reportNull$$$0(3);
            }
            this.myInterpreterId = interpreterId;
            boolean available = this.isAvailable(data);
            if (available && !this.myProject.isDefault()) {
                this.myContainerSettings = PhpDockerContainerSettingsManager.getInstance(this.myProject).getSettings(interpreterId).clone();
                DockerCredentialsHolder docker = DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)data);
                try {
                    this.myCurrentServer = docker == null ? null : PhpDockerProcessUtil.getAccount(docker);
                }
                catch (RemoteSdkException e) {
                    LOG.debug((Throwable)e);
                    this.myCurrentServer = null;
                }
                this.myContainerSettingsField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)this.myContainerSettings));
            }
        }

        public void disposeUI() {
            Disposer.dispose((Disposable)this.myContainerSettingsField);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterId";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/ui/PhpDockerContainerComponentProvider$PhpDockerContainerComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onInterpreterChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

