/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpEditConfigurationOptionsDialog;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.PhpDebugErrorDetector;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpDebuggerError;
import com.jetbrains.php.debug.PhpDebuggerFixableError;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsManager;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsProvider;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDockerDebugErrorDetector
extends PhpDebugErrorDetector {
    private final Project myProject;
    private static final String OLD_REMOTE_HOST_WINDOWS = "docker.for.win.localhost";
    private static final String OLD_REMOTE_HOST_MAC = "docker.for.mac.localhost";

    public PhpDockerDebugErrorDetector(@NotNull Project project) {
        if (project == null) {
            PhpDockerDebugErrorDetector.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public PhpDebuggerError detectPotentialError(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpDockerDebugErrorDetector.$$$reportNull$$$0(1);
        }
        if (!SystemInfo.isMac && !SystemInfo.isWindows) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)interpreter.getDebuggerId()) && PhpDebugUtil.isXDebug((String)interpreter.getDebuggerId())) {
            List options = interpreter.getConfigurationOptions();
            String configured = this.findConfiguredHost(options, interpreter);
            String message = PhpRemoteSdkBundle.message((String)"validation.debug.connection.was.not.established.host.incorrect", (Object[])new Object[]{StringUtil.notNullize((String)configured, (String)"host.docker.internal")});
            String action = PhpRemoteSdkBundle.message((String)"validation.debug.connection.was.not.established.host.update", (Object[])new Object[0]);
            return PhpDebuggerFixableError.create((String)message, (String)action, () -> {
                PhpEditConfigurationOptionsDialog dialog;
                ArrayList<PhpConfigurationOptionData> suggested = new ArrayList<PhpConfigurationOptionData>(options);
                if (StringUtil.isEmpty((String)configured)) {
                    PhpConfigurationOptionData newOption = new PhpConfigurationOptionData();
                    String host = SystemInfo.isMac ? OLD_REMOTE_HOST_MAC : OLD_REMOTE_HOST_WINDOWS;
                    XdebugConfigurationOptionsProvider optionsProvider = XdebugConfigurationOptionsManager.getConfigurationOptionsProvider((Project)this.myProject, (PhpInterpreter)interpreter);
                    newOption.setName(optionsProvider.getRemoteHostOptionName());
                    newOption.setValue(host);
                    suggested.add(newOption);
                }
                if ((dialog = PhpEditConfigurationOptionsDialog.showDialog((Project)this.myProject, suggested)).isOK()) {
                    interpreter.setConfigurationOptions(dialog.getConfigurationOptions());
                }
            });
        }
        return null;
    }

    @Nullable
    private String findConfiguredHost(@NotNull List<PhpConfigurationOptionData> options, @NotNull PhpInterpreter interpreter) {
        if (options == null) {
            PhpDockerDebugErrorDetector.$$$reportNull$$$0(2);
        }
        if (interpreter == null) {
            PhpDockerDebugErrorDetector.$$$reportNull$$$0(3);
        }
        XdebugConfigurationOptionsProvider optionsProvider = XdebugConfigurationOptionsManager.getConfigurationOptionsProvider((Project)this.myProject, (PhpInterpreter)interpreter);
        for (int i = options.size() - 1; i >= 0; --i) {
            PhpConfigurationOptionData option = options.get(i);
            if (!optionsProvider.isRemoteHostOption(option.getName())) continue;
            return option.getValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/docker/PhpDockerDebugErrorDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "detectPotentialError";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findConfiguredHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

