/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.compose.DockerComposeVersionProvider;
import com.intellij.docker.remote.settings.DockerExtraHost;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.docker.PhpDockerContainerSettingsManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeRemoteProcessRunner;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeStartCommand;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.settingsSummary.util.PhpSettingsCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerTroubleInfoCollector
implements TroubleInfoCollector {
    public String toString() {
        return "Docker";
    }

    @NotNull
    public String collectInfo(@NotNull Project project) {
        if (project == null) {
            DockerTroubleInfoCollector.$$$reportNull$$$0(0);
        }
        StringBuilder output = new StringBuilder();
        PhpSettingsCollector.collectCurrentPHPInterpreter((Project)project, (StringBuilder)output);
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance((Project)project).getInterpreter();
        if (interpreter != null) {
            PhpSdkAdditionalData phpSdkAdditionalData = interpreter.getPhpSdkAdditionalData();
            if (phpSdkAdditionalData instanceof PhpRemoteSdkAdditionalData) {
                try {
                    output.append("=====DOCKER EXECUTION COMMAND=====\n");
                    PhpDockerComposeStartCommand command = PhpDockerComposeRemoteProcessRunner.getDockerComposeCommand((PhpRemoteSdkAdditionalData)phpSdkAdditionalData);
                    DockerTroubleInfoCollector.appendEntry("Execution Command", command.toString(), output);
                    output.append("=====DOCKER SETTINGS=====\n");
                    DockerCloudConfiguration configuration = (DockerCloudConfiguration)PhpDockerProcessUtil.getAccount((RemoteSdkAdditionalData)phpSdkAdditionalData).getConfiguration();
                    DockerTroubleInfoCollector.appendEntry("Docker Compose Version", DockerComposeVersionProvider.getInstance().getDockerComposeVersion(configuration), output);
                    DockerTroubleInfoCollector.appendEntry("API URL", configuration.getApiUrl(), output);
                    DockerTroubleInfoCollector.appendEntry("Certificates folder", configuration.getCertificatesPath(), output);
                    DockerTroubleInfoCollector.appendEntry("Effective CLI connection parameters (-H / DOCKER_HOST)", configuration.getCliConnectionHint().toString(), output);
                    DockerTroubleInfoCollector.appendEntry("Docker Compose", DockerComposeCliUtil.createDockerComposeCommandlineBlocking((DockerCloudConfiguration)configuration).getExePath(), output);
                    for (DockerPathMappingImpl mapping : configuration.getPathMappings()) {
                        DockerTroubleInfoCollector.appendEscapedMappingEntry(mapping.getVirtualMachinePath(), mapping.getLocalPath(), output);
                    }
                    output.append("=====DOCKER CONTAINER=====\n");
                    DockerContainerSettings containerSettings = PhpDockerContainerSettingsManager.getInstance(project).getSettings(interpreter.getId());
                    DockerTroubleInfoCollector.appendEntry("Disable networking", containerSettings.isNetworkDisabled(), output);
                    DockerTroubleInfoCollector.appendEntry("Network mode", containerSettings.getNetworkMode(), output);
                    DockerTroubleInfoCollector.appendEntry("Publish all ports", containerSettings.isPublishAllPorts(), output);
                    DockerTroubleInfoCollector.appendEntry("Port bindings:", "", output);
                    for (DockerPortBindingImpl portBinding : containerSettings.getPortBindings()) {
                        DockerTroubleInfoCollector.appendEntry(String.valueOf(portBinding.getContainerPort()), portBinding.getProtocol() + " " + portBinding.getHostIp() + " " + portBinding.getHostPort(), output);
                    }
                    DockerTroubleInfoCollector.appendEntry("Links:", "", output);
                    for (DockerLinkImpl dockerLink : containerSettings.getLinks()) {
                        DockerTroubleInfoCollector.appendEntry(dockerLink.getName(), dockerLink.getAlias(), output);
                    }
                    DockerTroubleInfoCollector.appendEntry("Extra hosts:", "", output);
                    for (DockerExtraHost dockerExtraHost : containerSettings.getExtraHosts()) {
                        DockerTroubleInfoCollector.appendEntry(dockerExtraHost.getHostname(), dockerExtraHost.getIP(), output);
                    }
                    DockerTroubleInfoCollector.appendEntry("Volume bindings:", "", output);
                    for (DockerVolumeBindingImpl volumeBinding : containerSettings.getVolumeBindings()) {
                        DockerTroubleInfoCollector.appendEscapedMappingEntry(volumeBinding.getContainerPath(), volumeBinding.getHostPath() + " " + volumeBinding.isReadOnly(), output);
                    }
                    DockerTroubleInfoCollector.appendEntry("Environment variables:", "", output);
                    for (DockerEnvVarImpl envVar : containerSettings.getEnvVars()) {
                        DockerTroubleInfoCollector.appendEntry(envVar.getName(), envVar.getValue(), output);
                    }
                }
                catch (Exception ignored) {
                    output.append(ignored.getMessage());
                }
            } else {
                output.append("Non Docker PHP interpreter");
            }
        } else {
            output.append("No PHP interpreter is chosen\n");
        }
        String string = output.toString();
        if (string == null) {
            DockerTroubleInfoCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void appendEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerTroubleInfoCollector.$$$reportNull$$$0(2);
        }
        output.append(key).append(" : ").append(value).append("\n");
    }

    private static void appendEntry(@Nullable String key, int value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerTroubleInfoCollector.$$$reportNull$$$0(3);
        }
        DockerTroubleInfoCollector.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEntry(@Nullable String key, boolean value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerTroubleInfoCollector.$$$reportNull$$$0(4);
        }
        DockerTroubleInfoCollector.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEscapedEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerTroubleInfoCollector.$$$reportNull$$$0(5);
        }
        output.append(key).append(" : \"").append(value).append("\"\n");
    }

    private static void appendEscapedMappingEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerTroubleInfoCollector.$$$reportNull$$$0(6);
        }
        output.append("\"").append(key).append("\" : \"").append(value).append("\"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/DockerTroubleInfoCollector";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/DockerTroubleInfoCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendEntry";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedMappingEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

