#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxsshhostcertget.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

ALGORITHM=$3

SSH_HOST_DSA_KEY="/etc/ssh/ssh_host_dsa_key"
SSH_HOST_RSA_KEY="/etc/ssh/ssh_host_rsa_key"
SSH_HOST_ECDSA_KEY="/etc/ssh/ssh_host_ecdsa_key"
SSH_HOST_ED25519_KEY="/etc/ssh/ssh_host_ed25519_key"

if [[ "$ALGORITHM" == "DSA" ]]; then
  FILE=$SSH_HOST_DSA_KEY
elif [[ "$ALGORITHM" == "RSA" ]]; then
  FILE=$SSH_HOST_RSA_KEY
elif [[ "$ALGORITHM" == "ECDSA" ]]; then
  FILE=$SSH_HOST_ECDSA_KEY
elif [[ "$ALGORITHM" == "ED25519" ]]; then
  FILE=$SSH_HOST_ED25519_KEY
else
  errorMsg "Unknow ssh host key." "1"
fi

if test ! -e "${FILE}"; then
  exit 0
fi

${COMMAND_CAT} ${FILE}
