#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxrouteinadd.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

source "${RestrictedDir}/nxroutein.sh"

#
# Set value of ip_forward.
#

if [ ! -f "${NX_IP_FORWARD}" ]; then

  #
  # Create copy of ip_forward value if there is none already.
  #

  ${COMMAND_CAT} "${IP_FORWARD}" > "${NX_IP_FORWARD}"

fi

${COMMAND_ECHO} 1 > "${IP_FORWARD}"

#
# Call nftables.
#

if [ "${NETFILTER_MODE}" == "NFT" ]; then

  ${COMMAND_NFT} add table ip ${TABLE_NAME}

  ${COMMAND_NFT} add chain ip ${TABLE_NAME} postrouting \
      {type nat hook postrouting priority 100\;}

  ${COMMAND_NFT} add chain ip ${TABLE_NAME} forward \
      {type filter hook forward priority 0\;}

  #
  # Add all networks.
  #

  for gate in ${GATEWAYS[*]}; do

    ${COMMAND_NFT} add rule ip ${TABLE_NAME} postrouting \
        oifname ${gate} masquerade

    ${COMMAND_NFT} add rule ip ${TABLE_NAME} forward \
        iifname ${gate} oifname ${TAP_INTERFACE} ct state new,related,established accept

    ${COMMAND_NFT} add rule ip ${TABLE_NAME} forward \
        iifname ${TAP_INTERFACE} oifname ${gate} accept

  done

fi

#
# Call iptables.
#

if [ "${NETFILTER_MODE}" == "IPTABLES" ]; then

  #
  # Add all networks.
  #

  for gate in ${GATEWAYS[*]}; do
    ${COMMAND_IPTABLES} -t nat -A POSTROUTING -o ${gate} -j MASQUERADE

    ${COMMAND_IPTABLES} -A FORWARD -i ${gate} -o ${TAP_INTERFACE} -m state --state RELATED,ESTABLISHED -j ACCEPT

    ${COMMAND_IPTABLES} -A FORWARD -i ${TAP_INTERFACE} -o ${gate} -j ACCEPT

  done

fi

RESULT="${FIREWALL_MODE}|"

if [ "${FIREWALL_MODE}" == "FIREWALLD" ]; then

  ${COMMAND_FIREWALL_CMD} --zone=trusted --add-interface="${TAP_INTERFACE}"

elif [ "${FIREWALL_MODE}" == "UFW" ]; then

  OUT=$(${COMMAND_UFW} route allow in on ${TAP_INTERFACE})

  RESULT="${RESULT}${OUT}|"

  OUT=$(${COMMAND_UFW} route allow out on ${TAP_INTERFACE})

  RESULT="${RESULT}${OUT}|"

fi

${COMMAND_ECHO} "${RESULT}Exit success."
