#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2008, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxhtdchown.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

HTD_CONFIG_FILE="${NX_ROOT}/etc/web.cfg"

if test ! -e "${HTD_CONFIG_FILE}"; then
  errorMsg "Config file ${HTD_CONFIG_FILE} doesn't exist." "1"
fi

if test "x$3" = "xpublicCert" ; then
  DEST="${NX_ROOT}/etc/keys/host/ht_host_rsa_key.crt"
elif test "x$3" = "xprivateCert" ; then
  DEST="${NX_ROOT}/etc/keys/host/ht_host_rsa_key"
elif test "x$3" = "xconfig" ; then
  DEST=${HTD_CONFIG_FILE}
else
  errorMsg "Unknown option: $3." "1"
fi

if test ! -e "${DEST}"; then
  errorMsg "File ${DEST} doesn't exist." "1"
fi

NXHTD_USER=$($COMMAND_AWK -F' ' '/^User/ {print $2}' ${HTD_CONFIG_FILE})
NXHTD_GROUP=$($COMMAND_AWK -F' ' '/^Group/ {print $2}' ${HTD_CONFIG_FILE})

if test "x${NXHTD_USER}" = "x"; then
    errorMsg "User '${NXHTD_USER}' doesn't exist." "1"
fi

if test "x${NXHTD_GROUP}" = "x"; then
  NXHTD_GROUP=${NXHTD_USER}
fi

${COMMAND_CHOWN} -R ${NXHTD_USER}:${NXHTD_GROUP} ${DEST}

exit 0
