#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxsetsshagent.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=7

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

CONNECTED_USER=$3
SESSION_USER=$4
AGENT_DIR=$5
AGENT_FILE=$6
PARENT_PID=$7

AGENT_PATH="${AGENT_DIR}/${AGENT_FILE}"

COMMAND_READLINK="none"

if [ -x "/bin/readlink" ] ; then
  COMMAND_READLINK="/bin/readlink"
elif [ -x "/usr/bin/readlink" ] ; then
  COMMAND_READLINK="usr/bin/readlink"
fi

if [ "${COMMAND_READLINK}" = "none" ] ; then
  exit 1
fi

COMMAND_TR="none"

if [ -x "/bin/tr" ] ; then
  COMMAND_TR="/bin/tr"
elif [ -x "/usr/bin/tr" ] ; then
  COMMAND_TR="/usr/bin/tr"
fi

if [ "${COMMAND_TR}" = "none" ] ; then
  exit 1
fi

COMMAND_GREP="none"

if [ -x "/bin/grep" ]; then
  COMMAND_GREP="/bin/grep"
elif [ -x "/usr/bin/grep" ] ; then
  COMMAND_GREP="/usr/bin/grep"
fi

if [ "${COMMAND_GREP}" = "none" ] ; then
  exit 1
fi

# Read cmdline and remove null byte from end.

IFS= read -r -d '' command </proc/${PARENT_PID}/cmdline

if [[ $command != "sshd: ${CONNECTED_USER}@notty" ]] ; then
  ${COMMAND_ECHO} "Parent command line is not valid."
  exit 1
fi

valid=0

for file in /proc/${PARENT_PID}/fd/* ; do

  link=$(${COMMAND_READLINK} $file)

  if [[ $link =~ "socket:[".*"]" ]]; then

    # Inode is a number, so remove all other characters.

    inode=$(${COMMAND_ECHO} "$link" | ${COMMAND_TR} -d -c [:digit:])

    # Check if opened file descriptor is agent socket.

    if ${COMMAND_GREP} "$inode ${AGENT_PATH}" /proc/${PARENT}/net/unix; then
      valid=1
      break
    fi
  fi
done

if [[ $valid != 1 ]] ; then
  ${COMMAND_ECHO} "Cannot validate SSH agent path in parent environment."
  exit 1
fi


if [[ ${CONNECTED_USER} == "nx" ]]; then
  ${COMMAND_CHOWN} -R "${SESSION_USER}" ${AGENT_DIR}
else
  ${COMMAND_CHOWN} -R ":nx" ${AGENT_DIR}
  ${COMMAND_CHMOD} -R "g+rwx" ${AGENT_DIR}
fi

exit 0;
