#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxfwget.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=5

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

UTILITY="$3"
CHAIN="$4"
SETPATH="$5"

COMMAND="none"

if [ "x$UTILITY" = "xiptables" ];
then
  if [ -x "/bin/iptables" ];
  then
    COMMAND="/bin/iptables"
  elif [ -x "/sbin/iptables" ];
  then
    COMMAND="/sbin/iptables"
  elif [ -x "/usr/bin/iptables" ];
  then
    COMMAND="/usr/bin/iptables"
  elif [ -x "/usr/sbin/iptables" ];
  then
    COMMAND="/usr/sbin/iptables"
  elif [ -x "/usr/local/bin/iptables" ];
  then
    COMMAND="/usr/local/bin/iptables"
  elif [ -x "/usr/local/sbin/iptables" ];
  then
    COMMAND="/usr/local/sbin/iptables"
  fi
elif [ "x$UTILITY" = "xip6tables" ];
  then
    if [ -x "/bin/ip6tables" ];
    then
      COMMAND="/bin/ip6tables"
    elif [ -x "/sbin/ip6tables" ];
    then
      COMMAND="/sbin/ip6tables"
    elif [ -x "/usr/bin/ip6tables" ];
    then
      COMMAND="/usr/bin/ip6tables"
    elif [ -x "/usr/sbin/ip6tables" ];
    then
      COMMAND="/usr/sbin/ip6tables"
    elif [ -x "/usr/local/bin/ip6tables" ];
    then
      COMMAND="/usr/local/bin/ip6tables"
    elif [ -x "/usr/local/sbin/ip6tables" ];
    then
      COMMAND="/usr/local/sbin/ip6tables"
    fi
elif [ "x$UTILITY" = "xufw" ];
then
  if [ -x "/bin/ufw" ];
  then
    COMMAND="/bin/ufw"
  elif [ -x "/sbin/ufw" ];
  then
    COMMAND="/sbin/ufw"

  elif [ -x "/usr/bin/ufw" ];
  then
    COMMAND="/usr/bin/ufw"
  elif [ -x "/usr/sbin/ufw" ];
  then
    COMMAND="/usr/sbin/ufw"
  elif [ -x "/usr/local/bin/ufw" ];
  then
    COMMAND="/usr/local/bin/ufw"
  elif [ -x "/usr/local/sbin/ufw" ];
  then
    COMMAND="/usr/local/sbin/ufw"
  fi
elif [ "x$UTILITY" = "xfirewall-cmd" ];
then
  if [ -x "/bin/firewall-cmd" ];
  then
    COMMAND="/bin/firewall-cmd"
  elif [ -x "/sbin/firewall-cmd" ];
  then
    COMMAND="/sbin/firewall-cmd"
  elif [ -x "/usr/bin/firewall-cmd" ];
  then
    COMMAND="/usr/bin/firewall-cmd"
  elif [ -x "/usr/sbin/firewall-cmd" ];
  then
    COMMAND="/usr/sbin/firewall-cmd"
  elif [ -x "/usr/local/bin/firewall-cmd" ];
  then
    COMMAND="/usr/local/bin/firewall-cmd"
  elif [ -x "/usr/local/sbin/firewall-cmd" ];
  then
    COMMAND="/usr/local/sbin/firewall-cmd"
  fi
else
  exit 1
fi

if [ "$COMMAND" = "none" ];
then
  exit 1
fi

RET=1

ZONE="public"

if [ "x$UTILITY" = "xiptables" ] || [ "x$UTILITY" = "xip6tables" ];
then
  ${COMMAND} -L $CHAIN -n --line-numbers
  RET=$?
elif [ "x$UTILITY" = "xfirewall-cmd" ];
then
  ZONEFILE="${NX_ROOT}/var/db/server/firewall-zone"
  if [ -e "$ZONEFILE" ];
  then
    ZONE=$(${COMMAND_CAT} "$ZONEFILE")
  else
    ZONE=$(${COMMAND} --get-default-zone)

    if [[ $RESULT -ne 0 ]];
    then
      echo "NX> 500 Error: Execution of command $COMMAND failed with exit code: $RESULT."

      exit 1
    fi

    echo "$ZONE" > "$ZONEFILE"

    ${COMMAND_CHOWN}  -R nx ${ZONEFILE}

    ${COMMAND_CHMOD} 600 ${ZONEFILE}
  fi

  ${COMMAND} --zone=$ZONE --list-all
  RET=$?
else
  if [ "x$SETPATH" = "x1" ];
  then
    export PATH="/sbin"
  fi

  ${COMMAND} status
  RET=$?
fi

exit $RET
