#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxlicense.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=2
PARAMS_COUNT_MAX=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

if test "x$2" = "xnode"; then
  LICENSE_FILE="${NX_ROOT}/etc/node.lic"
elif  test "x$2" = "xserver"; then
  if  test "x$3" = "xnode"; then
    LICENSE_FILE="${NX_ROOT}/etc/node.lic"
  elif  test "x$3" = "xcloud"; then
    LICENSE_FILE="${NX_ROOT}/etc/cloud.lic"
  else
    LICENSE_FILE="${NX_ROOT}/etc/server.lic"
  fi
else
  errorMsg "Wrong application name: $2." "1"
fi

if test ! -e "${LICENSE_FILE}";
then
  errorMsg "Cannot stat file: ${LICENSE_FILE}." "1"
fi

${COMMAND_CAT} "${LICENSE_FILE}"
