#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxcopy.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=4

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

SOURCE_DIRECTORY="$3"
DEST_DIRECTORY="$4"
SOURCE_FILE_NAME="nxhtd-error.log"
DEST_FILE_NAME="nxhtd-error.log.1"

if test "x${SOURCE_DIRECTORY}" = "x"; then
  errorMsg "Missing source directory parameter." "1"
fi

if test "x${DEST_DIRECTORY}" = "x"; then
  errorMsg "Missing destination directory parameter." "1"
fi

if test ! -d "${SOURCE_DIRECTORY}"; then
  errorMsg "Source directory ${SOURCE_DIRECTORY} does not exist." "1"
fi

if test ! -d "${DEST_DIRECTORY}"; then
  errorMsg "Destination directory ${DEST_DIRECTORY} does not exist." "1"
fi

SOURCE_PATH="${SOURCE_DIRECTORY}/${SOURCE_FILE_NAME}"
DEST_PATH="${DEST_DIRECTORY}/${DEST_FILE_NAME}"

if test -f "${SOURCE_PATH}"; then
  ${COMMAND_CP} "${SOURCE_PATH}" "${DEST_PATH}"
else
  errorMsg "File ${SOURCE_PATH} does not exist." "1"
fi

if test $? -eq 0; then
  ${COMMAND_CHOWN} nx:nx "${DEST_PATH}"
fi

exit $?
