#!/bin/bash


#
# Define environment variables for the NoMachine virtual desktop or
# custom session. This script will be executed when a new session is
# created. Place it in a directory accessible by the user and specify
# path to this script in the VirtualDesktopVariables key in node.cfg.
# This script will be executed for all users who will run a session
# on this host.
#

#
# Add new path '/tmp/newpath/' to the $PATH environment variable. 
#

echo "PATH=$PATH:/tmp/newpath/"

#
# Modify an existing environment variable, e.g. $EXISTING_VAR1 and 
# set it to 'new_value'.
#

echo "EXISTING_VAR1=new_value"

#
# Define a new environment variable, e.g. $NEW_VAR and set it to 
# 'new_value'.
#

echo "NEW_VAR=new_value"

#
# Reset an existing environment variable, e.g. $EXISTING_VAR2. This 
# will delete the value set for the given variable. 
#

echo "EXISTING_VAR2="

exit 0
