#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxrouteindel.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

source "${RestrictedDir}/nxroutein.sh"

#
# Set value of ip_forward.
#

if [ ! -f "${NX_IP_FORWARD}" ]; then

  ${COMMAND_ECHO} "NX> 500 Error: Cannot find temporary value to restore."

  exit 1

else

  #
  # Restore ip_forward from temp value.
  #

  ${COMMAND_CAT} "${NX_IP_FORWARD}" > "${IP_FORWARD}"

  ${COMMAND_RM} "${NX_IP_FORWARD}"

fi

#
# Call nftables.
#

if [ "${NETFILTER_MODE}" == "NFT" ]; then

  ${COMMAND_NFT} delete table ip ${TABLE_NAME}

fi

#
# Call iptables.
#

if [ "${NETFILTER_MODE}" == "IPTABLES" ]; then

  #
  # Remove all networks.
  #

  for gate in ${GATEWAYS[*]}; do

    ${COMMAND_IPTABLES} -t nat -D POSTROUTING -o ${gate} -j MASQUERADE

    ${COMMAND_IPTABLES} -D FORWARD -i ${gate} -o ${TAP_INTERFACE} -m state --state RELATED,ESTABLISHED -j ACCEPT

    ${COMMAND_IPTABLES} -D FORWARD -i ${TAP_INTERFACE} -o ${gate} -j ACCEPT

  done

fi

${COMMAND_ECHO} "Exit success."
