#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

PARAMS_COUNT_MIN=3
PARAMS_COUNT_MAX=99

. "${RestrictedDir}"/nxfunct.sh

isRunByNodeOrPlayer

#
# Depending on what is available we will use
# nftables or iptables for network filtering.
#

NETFILTER_MODE=""

if test -x "/sbin/nft"; then
  NETFILTER_MODE="NFT"
  COMMAND_NFT="/sbin/nft"
elif test -x "/usr/sbin/nft"; then
  NETFILTER_MODE="NFT"
  COMMAND_NFT="/usr/sbin/nft"

elif test -x "/sbin/iptables"; then
  NETFILTER_MODE="IPTABLES"
  COMMAND_IPTABLES="/sbin/iptables"
elif test -x "/usr/sbin/iptables"; then
  NETFILTER_MODE="IPTABLES"
  COMMAND_IPTABLES="/usr/sbin/iptables"

else
  ${COMMAND_ECHO} "NX> 500 Error: Network filtering command not found."
  exit 1
fi

#
# User parameters.
#

TAP_INTERFACE="${3}"

for par in "${@:4}"; do
  if test "x${par}" != "x--skip_iptables"; then
    GATEWAYS[${#GATEWAYS[*]}]=${par}
  fi
done

#
# Table name for nftables.
#

if [ "${NETFILTER_MODE}" == "NFT" ]; then
  TABLE_NAME="nxvpn_${TAP_INTERFACE}"
fi

#
# Directory to backup current / restore old settings.
#

NX_VPN_TEMP="${NX_ROOT}/var/tmp/nxvpn"

if [ ! -d "${NX_VPN_TEMP}" ]; then
  ${COMMAND_MKDIR} "${NX_VPN_TEMP}"
fi

IP_FORWARD="/proc/sys/net/ipv4/ip_forward"
NX_IP_FORWARD="${NX_VPN_TEMP}/nxtemp_ip_forward_${TAP_INTERFACE}"
