#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxfwdel.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=7

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

UTILITY="$3"
PORT="$4"
PROTO="$5"
SETPATH="$6"
IP="$7"

COMMAND="none"

if [ "x$UTILITY" = "xiptables" ];
then
  if [ -x "/bin/iptables" ];
  then
    COMMAND="/bin/iptables"
  elif [ -x "/sbin/iptables" ];
  then
    COMMAND="/sbin/iptables"
  elif [ -x "/usr/bin/iptables" ];
  then
    COMMAND="/usr/bin/iptables"
  elif [ -x "/usr/sbin/iptables" ];
  then
    COMMAND="/usr/sbin/iptables"
  elif [ -x "/usr/local/bin/iptables" ];
  then
    COMMAND="/usr/local/bin/iptables"
  elif [ -x "/usr/local/sbin/iptables" ];
  then
    COMMAND="/usr/local/sbin/iptables"
  fi
elif [ "x$UTILITY" = "xip6tables" ];
  then
    if [ -x "/bin/ip6tables" ];
    then
      COMMAND="/bin/ip6tables"
    elif [ -x "/sbin/ip6tables" ];
    then
      COMMAND="/sbin/ip6tables"
    elif [ -x "/usr/bin/ip6tables" ];
    then
      COMMAND="/usr/bin/ip6tables"
    elif [ -x "/usr/sbin/ip6tables" ];
    then
      COMMAND="/usr/sbin/ip6tables"
    elif [ -x "/usr/local/bin/ip6tables" ];
    then
      COMMAND="/usr/local/bin/ip6tables"
    elif [ -x "/usr/local/sbin/ip6tables" ];
    then
      COMMAND="/usr/local/sbin/ip6tables"
    fi
elif [ "x$UTILITY" = "xufw" ];
then
  if [ -x "/bin/ufw" ];
  then
    COMMAND="/bin/ufw"
  elif [ -x "/sbin/ufw" ];
  then
    COMMAND="/sbin/ufw"
  elif [ -x "/usr/bin/ufw" ];
  then
    COMMAND="/usr/bin/ufw"
  elif [ -x "/usr/sbin/ufw" ];
  then
    COMMAND="/usr/sbin/ufw"
  elif [ -x "/usr/local/bin/ufw" ];
  then
    COMMAND="/usr/local/bin/ufw"
  elif [ -x "/usr/local/sbin/ufw" ];
  then
    COMMAND="/usr/local/sbin/ufw"
  fi
elif [ "x$UTILITY" = "xfirewall-cmd" ];
then
  if [ -x "/bin/firewall-cmd" ];
  then
    COMMAND="/bin/firewall-cmd"
  elif [ -x "/sbin/firewall-cmd" ];
  then
    COMMAND="/sbin/firewall-cmd"
  elif [ -x "/usr/bin/firewall-cmd" ];
  then
    COMMAND="/usr/bin/firewall-cmd"
  elif [ -x "/usr/sbin/firewall-cmd" ];
  then
    COMMAND="/usr/sbin/firewall-cmd"
  elif [ -x "/usr/local/bin/firewall-cmd" ];
  then
    COMMAND="/usr/local/bin/firewall-cmd"
  elif [ -x "/usr/local/sbin/firewall-cmd" ];
  then
    COMMAND="/usr/local/sbin/firewall-cmd"
  fi
else
  exit 1
fi

if [ "$COMMAND" = "none" ];
then
  exit 1
fi

RET=1

if [ "x$UTILITY" = "xiptables" ] || [ "x$UTILITY" = "xip6tables" ];
then
  DPORT="-m $PROTO --dport"
  if [[ "$PORT" == *,* ]];
  then
    DPORT="-m multiport --dports"
  fi

  if [[ "$IP" = "any" ]];
  then
    ${COMMAND} -D INPUT -p $PROTO $DPORT $PORT -j ACCEPT
  else
    ${COMMAND} -D INPUT -s $IP -p $PROTO $DPORT $PORT -j ACCEPT
  fi

  RET=$?
elif [ "x$UTILITY" = "xfirewall-cmd" ];
then
  ZONEFILE="${NX_ROOT}/var/db/server/firewall-zone"
  ZONE=""
  if [ -e "$ZONEFILE" ];
  then
    ZONE=$(${COMMAND_CAT} "$ZONEFILE")
  fi

  if [[ -z "$ZONE" ]];
  then
    echo "NX> 500 Error: Cannot execute $COMMAND without zone."

    exit 1
  fi

  if [[ "$IP" = "any" ]];
  then
    if [[ "$PORT" == *,* ]];
    then
      CMD="${COMMAND} --zone=$ZONE --remove-port={$PORT}/$PROTO"
      eval "$CMD"
    else
      ${COMMAND} --zone=${ZONE} --remove-port=$PORT/$PROTO
    fi
  else
    ${COMMAND} --zone=${ZONE} --remove-rich-rule="rule family='ipv4' source address='$IP' port port='$PORT' protocol='$PROTO' accept"
  fi

  RET=$?
else
  if [ "x$SETPATH" = "x1" ];
  then
    export PATH="/sbin"
  else
    unset PATH
  fi

  if [ "$IP" = "any" ];
  then
    ${COMMAND} delete allow proto $PROTO from $IP to any port $PORT
  else
    ${COMMAND} delete allow from $IP port $PORT to any proto $PROTO
  fi

  RET=$?
fi

exit $RET
