#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxrouteoutadd.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

source "${RestrictedDir}/nxrouteout.sh"

#
# Add all given routes.
#

RESULT=""

for i in "${!NETWORKS[@]}"; do

  net="${NETWORKS[$i]}"
  nextHop="${HOPS_IP[$i]}"
  nextHopInt="${HOPS_INT[$i]}"

  if [ "${nextHop}" == "" ]; then
    OUT=$( ${COMMAND_IP} route add $net dev ${nextHopInt} 2>&1 )
  else
    OUT=$( ${COMMAND_IP} route add $net via ${nextHop} dev ${nextHopInt} 2>&1 )
  fi

  RESULT="${RESULT}${OUT}|"

done

RESULT="${RESULT}Exit success."

${COMMAND_ECHO} "${RESULT}"
