# Set UTF-8 Encoding for the Welcome Message to be shown
if ($ExecutionContext.SessionState.LanguageMode -ne "ConstrainedLanguage") {
    $OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding =
                        New-Object System.Text.UTF8Encoding
}
$env:ELECTRON_RUN_AS_NODE = 1

$escapedArgs = @($args | foreach { 
        $aux = [string]$_
        "`"$aux`""
    })

$env:Path = "$env:GITKRAKEN_GIT_BINARY_PATH;$env:Path"

$proc = Start-Process -NoNewWindow -Passthru -Wait "$env:GITKRAKEN_BINARY_PATH" -ArgumentList "`"$env:GK_CLI_CLIENT_PATH`" $escapedArgs"
exit $proc.ExitCode
