// Copyright 2000-2022 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.stubs.PhpAttributeStub;
import com.jetbrains.php.lang.psi.stubs.PhpStubBasedPsiElement;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

public interface PhpAttribute extends PhpPsiElement, ParameterListOwner, PhpStubBasedPsiElement<PhpAttributeStub> {
  PsiElement getOwner();

  class PhpAttributeArgument {
    private final String myName;
    private final PhpExpectedFunctionArgument myArgument;

    public PhpAttributeArgument(String name, PhpExpectedFunctionArgument argument) {
      myName = name;
      myArgument = argument;
    }

    public String getName() {
      return myName;
    }

    public PhpExpectedFunctionArgument getArgument() {
      return myArgument;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;
      PhpAttributeArgument argument = (PhpAttributeArgument)o;
      return myName.equals(argument.myName) && myArgument.equals(argument.myArgument);
    }

    @Override
    public int hashCode() {
      return Objects.hash(myName, myArgument);
    }
  }
  PhpAttribute[] EMPTY_ARRAY = new PhpAttribute[0];
  @Nullable String getFQN();

  @Nullable
  ClassReference getClassReference();

  @NotNull List<@NotNull PhpExpectedFunctionArgument> getArgumentsValues();

  @NotNull List<@NotNull PhpAttributeArgument> getArguments();
}
