// Copyright 2000-2021 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Represents both Declaration and Call parameter list.
 */
public interface ParameterList extends PhpPsiElement {

  Condition<PsiElement> INSTANCEOF = use -> use instanceof ParameterList;

  PsiElement @NotNull [] getParameters();

  @Nullable
  PsiElement getParameter(int index);

  /**
   * Returns the named parameter with the specified name.
   * If there is no parameter with such name then the parameter with the specified index will be returned.
   */
  @Nullable @ApiStatus.Internal PsiElement getParameter(@NotNull String name, int index);
}
