// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpParameterStub;
import com.jetbrains.php.lang.psi.stubs.PhpStubBasedPsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.List;

public interface Parameter extends PhpNamedElement, RWAccess, PhpStubBasedPsiElement<PhpParameterStub>, PhpTypeDeclarationOwner<PhpTypeDeclaration>, PhpAttributesOwner {

  Parameter[] EMPTY_ARRAY = new Parameter[0];
  /**
   * The empty array of PSI parameters which can be reused to avoid unnecessary allocations.
   */
  ArrayFactory<Parameter> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new Parameter[count];

  Condition<PsiElement> INSTANCEOF = use -> use instanceof Parameter;

  @Override
  Icon getIcon();

  boolean isOptional();

  boolean isVariadic();

  @Override
  @NotNull
  PhpType getDeclaredType();

  @NotNull
  PhpType getLocalType();

  /**
   * Warning: tree materialisation!
   */
  @Nullable
  PsiElement getDefaultValue();

  @Nullable
  String getDefaultValuePresentation();

  boolean isPassByRef();

  @Nullable
  PhpDocParamTag getDocTag();

  @Override
  @NotNull @NlsSafe
  String getName();

  boolean isPromotedField();

  @NotNull PhpModifier.Access getPromotedFieldAccess();

  @ApiStatus.Internal
  boolean isOptional(List<? extends PsiElement> arguments);
}
