// Copyright 2000-2025 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GroupStatement extends  Statement {

  Condition<PsiElement> INSTANCEOF = e -> e instanceof GroupStatement;

  default PsiElement @NotNull [] getStatements() {
    PsiElement[] children = PsiTreeUtil.getChildrenOfType(this, PhpPsiElement.class);
    return children!=null ? children : PhpPsiElement.EMPTY_ARRAY;
  }

  @ApiStatus.Internal
  default JBIterable<? extends PsiElement> statements() {
    PsiElement child = getFirstChild();
    if (child == null) {
      return JBIterable.empty();
    }
    return JBIterable.generate(child, PsiElement::getNextSibling).filter(PhpPsiElement.class);
  }

  @ApiStatus.Internal
  default @Nullable PsiElement getOnlyStatement() {
    return ContainerUtil.getOnlyItem(statements().take(2).toList());
  }
}
