// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

/**
 * Extension point to implement to provide names of predefined variables.
 */
public interface PhpPredefinedVariableProvider {
  ExtensionPointName<PhpPredefinedVariableProvider> EP_NAME = ExtensionPointName.create("com.jetbrains.php.predefinedVariableProvider");

  /**
   *
   * Provides list of variable names that should be treated as predefined, for example,
   * never marked as undefined and handled properly in refactorings.
   *
   * @return set of variable names
   */
  @NotNull
  Set<CharSequence> getPredefinedVariables(@NotNull PhpFile file);
}
