// Copyright 2000-2024 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiReference;
import com.intellij.util.Processor;
import com.jetbrains.php.lang.inspections.reference.elements.*;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import org.jetbrains.annotations.NotNull;

public abstract class PhpGlobalInspectionContext implements GlobalInspectionContextExtension<PhpGlobalInspectionContext> {
  private static final @NotNull Key<PhpGlobalInspectionContext> CONTEXT = Key.create("GlobalPhpInspectionContext");

  public static @NotNull PhpGlobalInspectionContext getInstance(@NotNull GlobalInspectionContext globalContext) {
    return globalContext.getExtension(CONTEXT);
  }

  public interface UsagesProcessor extends Processor<PsiReference> {
    UsagesProcessor[] EMPTY_ARRAY = new UsagesProcessor[0];

    default boolean isSensibleToProcess() {
      return true;
    }
  }

  public abstract void enqueueClassUsagesProcessor(@NotNull PhpRefClass refClass, @NotNull UsagesProcessor p);

  public abstract void enqueueDerivedClassesProcessor(@NotNull PhpRefClass refClass, @NotNull Processor<PhpClass> p);

  public abstract void enqueueDerivedMethodUsagesProcessor(@NotNull PhpRefMethod refMethod, @NotNull Processor<PhpClassMember> p);

  public abstract void enqueueMethodUsagesProcessor(@NotNull PhpRefMethod refMethod, @NotNull UsagesProcessor p);

  public abstract void enqueueFunctionUsagesProcessor(@NotNull PhpRefFunction refFunction, @NotNull UsagesProcessor p);

  public abstract void enqueueDerivedFieldUsagesProcessor(@NotNull PhpRefField refField, @NotNull Processor<PhpClassMember> p);
  
  public abstract void enqueueFieldUsagesProcessor(@NotNull PhpRefField refField, @NotNull UsagesProcessor p);

  public abstract void enqueueConstantUsagesProcessor(@NotNull PhpRefConstant refConstant, @NotNull UsagesProcessor p);

  @Override
  public @NotNull Key<PhpGlobalInspectionContext> getID() {
    return CONTEXT;
  }
}
